package jp.sf.wagashi;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.rulers.AbstractContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;

public class FakeRulerColumn implements IContributedRulerColumn{

	private Control fControl;
	private RulerColumnDescriptor fDescriptor;
	private ITextEditor fEditor;
	
	public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
		fControl = new Canvas(parentControl, SWT.NONE);
		return fControl;
	}

	public RulerColumnDescriptor getDescriptor() {
		return fDescriptor;
	}
	
	public void setDescriptor(RulerColumnDescriptor descriptor) {
		fDescriptor = descriptor;
	}
	
	public void setEditor(ITextEditor editor) {
		fEditor = editor;
	}

	public ITextEditor getEditor() {
		return fEditor;
	}

	public void columnCreated() {
		IEditorListener[] listeners = WagashiPlugin.getEditorListeners();
		for(IEditorListener listener : listeners){
			try{
				listener.editorOpen(fEditor);
			}
			catch(Exception e){
			}
		}
	}

	public void columnRemoved() {
		IEditorListener[] listeners = WagashiPlugin.getEditorListeners();
		for(IEditorListener listener : listeners){
			try{
				listener.editorClose(fEditor);
			}
			catch(Exception e){
			}
		}
	}

	public Control getControl() {
		return fControl;
	}

	public int getWidth() {
		return 0;
	}

	public void redraw() {
	}

	public void setFont(Font font) {
	}

	public void setModel(IAnnotationModel model) {
	}

}
