package jp.sf.wagashi.anmitsu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditorPreferenceConstants;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class LinePainterPreferencePage extends PreferencePage implements IWorkbenchPreferencePage{

	private ArrayList<Control> fControlList = new ArrayList<Control>();
	private ArrayList<ColorSelector> fSelectorList = new ArrayList<ColorSelector>();
	//private List fAppearanceColorList;
	//private ColorSelector fAppearanceColorSelector;

	private String fAppearanceColorListModel[] = {
		EditorToolsConstants.TAB_COLOR,
		EditorToolsConstants.HALF_SPACE_COLOR,
		EditorToolsConstants.FULL_SPACE_COLOR,
		EditorToolsConstants.LINE_FEED_COLOR,
		EditorToolsConstants.EOF_COLOR
	};

	private OverlayPreferenceStore fOverlayStore;
	
	
	public void init(IWorkbench workbench) {
		fOverlayStore = createOverlayStore();
		fOverlayStore.load();
	}

	private OverlayPreferenceStore createOverlayStore() {

		ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, EditorToolsConstants.ENABLE_LINE_PAINTER));

		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, EditorToolsConstants.TAB));
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, EditorToolsConstants.HALF_SPACE));
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, EditorToolsConstants.FULL_SPACE));
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, EditorToolsConstants.LINE_FEED));
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, EditorToolsConstants.EOF));

		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, EditorToolsConstants.CUT_SELECTION_TEXT));

		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, EditorToolsConstants.TAB_COLOR));
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, EditorToolsConstants.HALF_SPACE_COLOR));
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, EditorToolsConstants.FULL_SPACE_COLOR));
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, EditorToolsConstants.LINE_FEED_COLOR));
		overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, EditorToolsConstants.EOF_COLOR));
		
		
		OverlayPreferenceStore.OverlayKey[] keys= new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
		overlayKeys.toArray(keys);
		return new OverlayPreferenceStore(EditorToolsPlugin.getDefault().getPreferenceStore(), keys);
	}

	private Button addCheckBox(Composite parent, String label, final String key){
		final Button b = new Button(parent, SWT.CHECK);
		b.setText(label);
		b.setData(key);
		b.setSelection(fOverlayStore.getBoolean(key));
		b.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				fOverlayStore.setValue(key, b.getSelection());
			}
		});
		GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING | GridData.VERTICAL_ALIGN_BEGINNING);
		gd.horizontalSpan = 2;
		b.setLayoutData(gd);
		fControlList.add(b);
		return b;
	}
	
	private Button addColorButton(Composite parent, final String key){
		final ColorSelector selector = new ColorSelector(parent);
		Button b = selector.getButton();
		b.setData(key);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalAlignment = GridData.BEGINNING;
		b.setLayoutData(gd);
		b.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				PreferenceConverter.setValue(fOverlayStore, key, selector.getColorValue());
			}
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		selector.setColorValue(PreferenceConverter.getColor(fOverlayStore, key));
		fSelectorList.add(selector);
		return b;
	}
	
	private void addLabel(Composite parent, String label){
		Label l= new Label(parent, SWT.LEFT);
		l.setText(label);
		GridData gd= new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		gd.horizontalSpan= 2;
		l.setLayoutData(gd);

	}
	
	
	protected Control createContents(Composite parent) {
		ArrayList<Control> slaveList = new ArrayList<Control>(); 
		Composite appearanceComposite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns= 1;
		layout.marginHeight= 0;
		layout.marginWidth= 0;
		GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_CENTER | GridData.VERTICAL_ALIGN_FILL);
		appearanceComposite.setLayoutData(gd);
		appearanceComposite.setLayout(layout);

		Button master = addCheckBox(appearanceComposite, EditorToolsMessages.LinePainterPreferencePage_enableLinePainter, EditorToolsConstants.ENABLE_LINE_PAINTER);
		
		Group group = new Group(appearanceComposite, SWT.NONE);
		group.setText(EditorToolsMessages.LinePainterPreferencePage_group_options);
		layout = new GridLayout();
		layout.numColumns= 1;
		gd = new GridData(GridData.VERTICAL_ALIGN_FILL);
		gd.horizontalIndent = 15;
		group.setLayoutData(gd);
		group.setLayout(layout);

		slaveList.add(addCheckBox(group, EditorToolsMessages.LinePainterPreferencePage_showTab, EditorToolsConstants.TAB));
		slaveList.add(addCheckBox(group, EditorToolsMessages.LinePainterPreferencePage_showHalfSpace, EditorToolsConstants.HALF_SPACE));
		slaveList.add(addCheckBox(group, EditorToolsMessages.LinePainterPreferencePage_showFullSpace, EditorToolsConstants.FULL_SPACE));
		slaveList.add(addCheckBox(group, EditorToolsMessages.LinePainterPreferencePage_showLineFeed, EditorToolsConstants.LINE_FEED));
		slaveList.add(addCheckBox(group, EditorToolsMessages.LinePainterPreferencePage_showEOF, EditorToolsConstants.EOF));
		slaveList.add(addCheckBox(group, EditorToolsMessages.LinePainterPreferencePage_cutAtLineFeed, EditorToolsConstants.CUT_SELECTION_TEXT));

		group = new Group(appearanceComposite, SWT.NONE);
		group.setText(EditorToolsMessages.LinePainterPreferencePage_group_colors);
		layout = new GridLayout();
		layout.numColumns= 3;
		gd = new GridData(GridData.VERTICAL_ALIGN_FILL);
		gd.horizontalIndent = 15;
		group.setLayoutData(gd);
		group.setLayout(layout);
		
		addLabel(group, EditorToolsMessages.LinePainterPreferencePage_tabColor);
		slaveList.add(addColorButton(group, EditorToolsConstants.TAB_COLOR));
		addLabel(group, EditorToolsMessages.LinePainterPreferencePage_halfSpaceColor);
		slaveList.add(addColorButton(group, EditorToolsConstants.HALF_SPACE_COLOR));
		addLabel(group, EditorToolsMessages.LinePainterPreferencePage_fullSpaceColor);
		slaveList.add(addColorButton(group, EditorToolsConstants.FULL_SPACE_COLOR));
		addLabel(group, EditorToolsMessages.LinePainterPreferencePage_lineFeedColor);
		slaveList.add(addColorButton(group, EditorToolsConstants.LINE_FEED_COLOR));
		addLabel(group, EditorToolsMessages.LinePainterPreferencePage_EOFColor);
		slaveList.add(addColorButton(group, EditorToolsConstants.EOF_COLOR));
		
		
		createDependency(master, slaveList);
		//parent.layout();
		return appearanceComposite;
	}
	
	private void createDependency(final Button master, final ArrayList<Control> slaveList){
		master.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				setDependencyEnabled(master, slaveList);
//				boolean b = master.getSelection();
//				for(Control c : slaveList){
//					c.setEnabled(b);
//				}
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		setDependencyEnabled(master, slaveList);
	}
	
	private void setDependencyEnabled(Button master, ArrayList<Control> slaveList){
		boolean b = master.getSelection();
		for(Control c : slaveList){
			c.setEnabled(b);
		}
	}

	public boolean performOk() {
		fOverlayStore.propagate();
    	return true;
    }

   protected void performDefaults() {
	   super.performDefaults();
	   fOverlayStore.loadDefaults();
	   for(Control c : fControlList){
		   if(c instanceof Button){
			   ((Button)c).setSelection(fOverlayStore.getBoolean(c.getData().toString()));
		   }
	   }
	   for(ColorSelector c : fSelectorList){
		   c.setColorValue(PreferenceConverter.getColor(fOverlayStore, c.getButton().getData().toString()));
	   }
   }
}
