package jp.sf.wagashi.sakuramochi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import jp.sf.wagashi.sakuramochi.translate.GoogleTranslate;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.IWorkbenchActionDefinitionIds;
import org.osgi.framework.Bundle;

public class TranslateView extends ViewPart {

	public static final String id = "jp.sf.wagashi.sakuramochi.translateView"; //$NON-NLS-1$
	
	private Composite fComposite;
	private Combo fTranslationCombo;
	private Button fTranslateButton;
//	private Button fStopButton;
	private TextViewer fTextViewer;
	private Browser fDestBrowser;
	private IUndoManager fUndoManager;
	private IPreferenceStore fStore = TranslatePlugin.getDefault().getPreferenceStore();

	private String fSrcText;
	private static String fStyleSheet = null;
	
	private String fLangFrom;
	private String fLangTo;
	
	private TranslatorThread fTranslateThread = null;
	
	private boolean isTranslating = false;
	private Cursor fCoursor;
	private Cursor fTextViewerCoursor;
	private Cursor fDestBrowserCoursor;
	private HashMap<String,IAction> fActions;
	private List<String> fSelectionList;
	private IAction fTranslateAction;

	public void createPartControl(Composite parent) {
		fComposite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		fComposite.setLayoutData(gridData);
		fComposite.setLayout(layout);

		fTranslationCombo = new Combo(fComposite, SWT.READ_ONLY | SWT.SINGLE);
		for (String value : TranslateLanguageUtil.getSortedLanguagePairValues()) {
			fTranslationCombo.add(value);
		}
		fTranslationCombo.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				int index = fTranslationCombo.getSelectionIndex();
				String value = fTranslationCombo.getItem(index);
				String key = TranslateLanguageUtil.getPairKey(value);
				fStore.setValue(TranslateConstants.TRANSLATEVIEW_PAIR, key);
				String[] lang = key.split("\\|");
				fLangFrom = lang[0];
				fLangTo = lang[1];
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		fTranslationCombo.setVisibleItemCount(10);

		gridData = new GridData();
		gridData.horizontalIndent = 4;
		gridData.verticalIndent = 4;
		fTranslationCombo.setLayoutData(gridData);

		fTranslateButton = new Button(fComposite, SWT.PUSH);
		fTranslateButton.setText(TranslateMessages.TranslateView_translateButton);
		fTranslateButton.setEnabled(false);
		fTranslateButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				doTranslate();
//				fSrcText = fTextViewer.getTextWidget().getText();
//				fTranslateThread = new TranslatorThread();
//				fTranslateThread.start();
//				fTranslateButton.setEnabled(false);
//				fCoursor = getSite().getShell().getCursor();
//				getSite().getShell().setCursor(new Cursor(fComposite.getDisplay(), SWT.CURSOR_WAIT));
//				fStopButton.setEnabled(true);
			}
		});

		gridData = new GridData();
		gridData.verticalIndent = 4;
		fTranslateButton.setLayoutData(gridData);

		
//		fStopButton = new Button(fComposite, SWT.PUSH);
//		fStopButton.setText(TranslateMessages.TranslateView_stopButton);
//		fStopButton.setEnabled(false);
//		fStopButton.addSelectionListener(new SelectionAdapter(){
//			public void widgetSelected(SelectionEvent e) {
//				fTranslateThread = null;
//				fTranslateButton.setEnabled(true);
//				fStopButton.setEnabled(false);
//			}
//		});
		
		Label separator = new Label(fComposite, SWT.HORIZONTAL | SWT.SEPARATOR);
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = 2;
		separator.setLayoutData(gridData);

		SashForm sashForm = new SashForm(fComposite, SWT.HORIZONTAL);
		gridData = new GridData(GridData.FILL_BOTH);
		gridData.horizontalSpan = 2;
		sashForm.setLayoutData(gridData);

		fTextViewer = new TextViewer(sashForm, SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI | SWT.FULL_SELECTION);
		fTextViewer.setDocument(new Document());
		fTextViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){
			public void selectionChanged(SelectionChangedEvent event) {
				for(String id : fSelectionList){
					IAction action = fActions.get(id);
					if (action instanceof IUpdate) {
						 ((IUpdate) action).update();
					}
				}
				
			}
		});
		
		fTextViewer.getTextWidget().addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e) {
				fTranslateButton.setEnabled(fTextViewer.getTextWidget().getText().length() > 0);
				fTranslateAction.setEnabled(isHandled());
			}
		});
		
		fUndoManager = new DefaultUndoManager(10);
		fTextViewer.setUndoManager(fUndoManager);
		fUndoManager.connect(fTextViewer);

		fDestBrowser = new Browser(sashForm, SWT.NONE);

		MenuManager menuMgr = new MenuManager("#PopUp");
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager mgr) {
				fillContextMenu(mgr);
			}
		});
		
		Menu menu = menuMgr.createContextMenu(fTextViewer.getTextWidget());
		fTextViewer.getTextWidget().setMenu(menu);
		getSite().registerContextMenu(menuMgr, fTextViewer.getSelectionProvider());

		createActions();
		createUndoRedoActions();
		
		loadValue();
		
		fComposite.pack();
	}

	protected void createActions(){
		fActions = new HashMap<String,IAction>();
		fSelectionList = new ArrayList<String>();
		
		IAction action= new TranslateViewTextAction(this, ITextOperationTarget.CUT);
		action.setText(TranslateMessages.TranslateView_popupMenu_cut);
		action.setActionDefinitionId(IWorkbenchActionDefinitionIds.CUT);
		setAction(ActionFactory.CUT.getId(), action);

		action= new TranslateViewTextAction(this, ITextOperationTarget.COPY);
		action.setText(TranslateMessages.TranslateView_popupMenu_copy);
		action.setActionDefinitionId(IWorkbenchActionDefinitionIds.COPY);
		setAction(ActionFactory.COPY.getId(), action);

		action= new TranslateViewTextAction(this, ITextOperationTarget.PASTE);
		action.setText(TranslateMessages.TranslateView_popupMenu_paste);
		action.setActionDefinitionId(IWorkbenchActionDefinitionIds.PASTE);
		setAction(ActionFactory.PASTE.getId(), action);

		action= new TranslateViewTextAction(this, ITextOperationTarget.SELECT_ALL);
		action.setText(TranslateMessages.TranslateView_popupMenu_selectAll);
		action.setActionDefinitionId(IWorkbenchActionDefinitionIds.SELECT_ALL);
		setAction(ActionFactory.SELECT_ALL.getId(), action);
		
		fTranslateAction = new TranslateViewAction(this);
		//action.setId(ITranslateActionDefinitionIds.TRANSLATE);
		fTranslateAction.setText(TranslateMessages.TranslateView_popupMenu_translate);
		fTranslateAction.setActionDefinitionId(ITranslateActionDefinitionIds.TRANSLATE);
		setAction(ITranslateActionDefinitionIds.TRANSLATE, fTranslateAction);
		fTranslateAction.setEnabled(false);
		
		fSelectionList.add(ActionFactory.CUT.getId());
		fSelectionList.add(ActionFactory.COPY.getId());
		
	}
	
	protected void createUndoRedoActions() {
		IUndoContext undoContext= getUndoContext();
		if (undoContext != null) {
			// Use actions provided by global undo/redo
			
			// Create the undo action
			OperationHistoryActionHandler undoAction= new UndoActionHandler(getSite(), undoContext);
			PlatformUI.getWorkbench().getHelpSystem().setHelp(undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
			undoAction.setActionDefinitionId(IWorkbenchActionDefinitionIds.UNDO);
			setAction(ITextEditorActionConstants.UNDO, undoAction);

			// Create the redo action.
			OperationHistoryActionHandler redoAction= new RedoActionHandler(getSite(), undoContext);
			PlatformUI.getWorkbench().getHelpSystem().setHelp(redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
			redoAction.setActionDefinitionId(IWorkbenchActionDefinitionIds.REDO);
			setAction(ITextEditorActionConstants.REDO, redoAction);
		}
	}	

	private IUndoContext getUndoContext() {
		IUndoManager undoManager= fTextViewer.getUndoManager();
		if (undoManager instanceof IUndoManagerExtension)
			return ((IUndoManagerExtension)undoManager).getUndoContext();
		return null;
	}	

	protected void setAction(String actionID, IAction action) {
		fActions.put(actionID, action);
		getViewSite().getActionBars().setGlobalActionHandler(actionID, action);
	}

	
	protected void updateActions(){
		for(IAction action : fActions.values()){
			if (action instanceof IUpdate) {
				 ((IUpdate) action).update();
			}
		}
	}

	protected void fillContextMenu(IMenuManager menu) {
		
		if (fTextViewer.getDocument() == null) {
			return;
		} 
		menu.add(new Separator());		

		
		menu.add(fActions.get(ActionFactory.CUT.getId()));
		menu.add(fActions.get(ActionFactory.COPY.getId()));
		menu.add(fActions.get(ActionFactory.PASTE.getId()));
		menu.add(fActions.get(ActionFactory.SELECT_ALL.getId()));
		menu.add(new Separator());
		menu.add(fActions.get(ITranslateActionDefinitionIds.TRANSLATE));
		updateActions();
	}

	public void setFocus() {
	}

	public synchronized void doTranslate(){
		if(isTranslating || !isHandled()){
			System.out.println("running!");
			return;
		}
		
		isTranslating = true;
		
		fCoursor = getSite().getShell().getCursor();
		getSite().getShell().setCursor(new Cursor(getSite().getShell().getDisplay(), SWT.CURSOR_WAIT));
		
		fTextViewerCoursor = fTextViewer.getControl().getCursor(); 
		fTextViewer.getControl().setCursor(new Cursor(fTextViewer.getControl().getDisplay(), SWT.CURSOR_WAIT));
		
		fSrcText = fTextViewer.getTextWidget().getText();
		fTranslateThread = new TranslatorThread();
		fTranslateThread.start();
		fTranslateButton.setEnabled(false);
	}
	
	public boolean isHandled(){
		if(isTranslating){
			System.out.println("isHandled!!");
			return false;
		}
		return (fTextViewer.getTextWidget().getText().length() >= 1);
	}
	
	private void loadValue() {
		
		String key = fStore.getString(TranslateConstants.TRANSLATEVIEW_PAIR);
		String value = TranslateLanguageUtil.getPairValue(key);
		for (int i = 0; i < fTranslationCombo.getItemCount(); i++) {
			if (fTranslationCombo.getItem(i).equals(value)) {
				fTranslationCombo.select(i);
				break;
			}
		}
		String[] lang = key.split("\\|");
		fLangFrom = lang[0];
		fLangTo = lang[1];
	}

	private static String getStyleSheet(){
		if(fStyleSheet != null){
			return fStyleSheet;
		}
		
		Bundle bundle= Platform.getBundle(JavaPlugin.getPluginId());
		URL styleSheetURL= bundle.getEntry("/JavadocHoverStyleSheet.css"); //$NON-NLS-1$
		if (styleSheetURL != null) {
			try {
				styleSheetURL= FileLocator.toFileURL(styleSheetURL);
				BufferedReader reader= new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
				StringBuffer buffer= new StringBuffer(200);
				String line= reader.readLine();
				while (line != null) {
					buffer.append(line);
					buffer.append('\n');
					line= reader.readLine();
				}
				fStyleSheet = buffer.toString();
			} catch (IOException ex) {
				fStyleSheet = null;
			}
		}
		return fStyleSheet;
	}

	private static String toHTML(String text){
		StringBuffer buffer = new StringBuffer();
		
		buffer.append("<html><head><style CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
		buffer.append(getStyleSheet());
		buffer.append("</style></head><body text=\"#000000\" bgcolor=\"#FFFFFF\">");
		buffer.append(text == null ? "" : text);
		buffer.append("</body></html>");
		return buffer.toString();
	}

	public Object getAdapter(Class adapter) {
		if (ITextOperationTarget.class.equals(adapter)) {
			return fTextViewer.getTextOperationTarget();
		}
		
		if (ITextViewer.class.equals(adapter)) {
			return fTextViewer;
		}
			
		return super.getAdapter(adapter);
	}

	private static void appendColor(StringBuffer buffer, RGB rgb){
		buffer.append('#');
		buffer.append(Integer.toHexString(rgb.red));
		buffer.append(Integer.toHexString(rgb.green));
		buffer.append(Integer.toHexString(rgb.blue));
	}

	class TranslatorThread extends Thread{
		public void run(){
			String str;
			try{
				str = GoogleTranslate.translate(fSrcText, fLangFrom, fLangTo);
				final String out = toHTML(str);
				getSite().getShell().getDisplay().asyncExec(new Runnable(){
					public void run(){
						fDestBrowser.setText(out);
					}
				});
			}
			catch(Exception e){
				e.printStackTrace();
				final String out = toHTML(e.toString());
				getSite().getShell().getDisplay().asyncExec(new Runnable(){
					public void run(){
						fDestBrowser.setText(out);
					}
				});
			}
			finally{
				getSite().getShell().getDisplay().asyncExec(new Runnable(){
					public void run(){
						fTranslateButton.setEnabled(true);
						getSite().getShell().setCursor(fCoursor);
						fTextViewer.getControl().setCursor(fTextViewerCoursor);
						isTranslating = false;
//						fStopButton.setEnabled(false);
					}
				});
			}
		}
	}
}
