package jp.sf.wagashi.sakuramochi.translate;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class GoogleTranslate {
	private static final String ENCODING = "UTF-8";
	private static final String INTERMEDIATE_LANGUAGE = "en";
	private static final String URL_STRING = "http://translate.google.com/translate_t";
	private static final String TEXT_VAR = "&text=";
	private static final int RATE_DELAY = 2000;
	private static boolean rateControl = true;
	private static long lastQueryTime = 0L;

	public GoogleTranslate() {
	}

	public static boolean isUsingRateControl() {
		return rateControl;
	}

	public static void setUsingRateControl(boolean rateControl) {
		rateControl = rateControl;
	}

	private static String toString(InputStream inputStream) throws Exception {
		StringBuilder outputBuilder = new StringBuilder();
		try {
			while (rateControl && lastQueryTime + 2000L > System.currentTimeMillis())
				try {
					Thread.sleep((lastQueryTime + 2000L) - System.currentTimeMillis());
				} catch (InterruptedException e) {
					System.out.println("[google-api-translate-java] Interrupted sleep.");
			}
			if (inputStream != null) {
				BufferedReader reader = new BufferedReader( new InputStreamReader(inputStream, "UTF-8"));
				String string;
				while ((string = reader.readLine()) != null)
					outputBuilder.append(string).append('\n');
			}
			if (rateControl)
				lastQueryTime = System.currentTimeMillis();
		} catch (Exception ex) {
			throw new Exception("[google-api-translate-java] Error reading translation stream.", ex);
		}
		return outputBuilder.toString();
	}

	public static String translate(String text, String from, String to) throws Exception { 
		return retrieveTranslation(text, from, to);
	}

	private static String retrieveTranslation(String text, String from, String to) throws Exception {
        String s;
        PrintWriter writer;
    	URL url = new URL(URL_STRING);
    	HttpURLConnection uc = (HttpURLConnection)url.openConnection();
    	uc.setRequestMethod("POST");
    	uc.setDoOutput(true);        
        uc.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)");

        writer = new PrintWriter(uc.getOutputStream());
        writer.write("langpair=" + from + "|" + to + "&text=" + URLEncoder.encode(text, "UTF-8"));
        writer.close();
		
		String page = toString(uc.getInputStream());
		int resultBox = page.indexOf("<div id=result_box dir=");
		if (resultBox < 0)
			throw new Error("No translation result returned.");
		String start = page.substring(resultBox);
		s = start.substring(start.indexOf('>') + 1, start.indexOf("</div>"));
		uc.getInputStream().close();
		if (uc.getErrorStream() != null)
			uc.getErrorStream().close();
		return s;
	}

}
