/*
 * @(#) $Id: ByteToCharUTF7.java,v 1.3 2004/07/12 04:14:31 Shin Exp $ $Revision:
 * 1.3 $ Copyright (c) 2000 Shin Kinoshita All Rights Reserved.
 */
package com.sk_jp.io;

/**
 * UTF-7のデコーダです。
 * <p>
 * </p>
 * 
 * @author Shin
 */
public class ByteToCharUTF7 extends sun.io.ByteToCharConverter {
	private boolean b64Context = false;

	private int currentB64Off = 0;

	private char currentChar = 0;

	@Override
	public int convert(byte[] bytes, int byteStart, int byteEnd, char[] chars,
			int charStart, int charEnd)
			throws sun.io.ConversionBufferFullException,
			sun.io.UnknownCharacterException {
		this.charOff = charStart;

		for (this.byteOff = byteStart; this.byteOff < byteEnd; this.byteOff++) {
			if (this.charOff >= charEnd) {
				throw new sun.io.ConversionBufferFullException();
			}
			if (this.b64Context) {
				if (bytes[this.byteOff] == '-') {
					if (this.currentB64Off != 0 && this.currentChar > 0) {
						chars[this.charOff] = this.currentChar;
						this.charOff++;
					}
					this.b64Context = false;
					continue;
				}
				int part = ("ABCDEFGHIJKLMNOPQRSTUVWXYZ"
						+ "abcdefghijklmnopqrstuvwxyz0123456789+/")
						.indexOf(bytes[this.byteOff]);
				if (part == -1) {
					throw new sun.io.UnknownCharacterException(
							"Invalid UTF-7 code: " + (char) bytes[this.byteOff]);
				}

				switch (this.currentB64Off) {
				case 0:
					this.currentChar = (char) (part << 10);
					break;
				case 1:
					this.currentChar |= (char) (part << 4);
					break;
				case 2:
					this.currentChar |= (char) (part >> 2);
					chars[this.charOff] = this.currentChar;
					this.charOff++;
					this.currentChar = (char) ((part & 0x03) << 14);
					break;
				case 3:
					this.currentChar |= (char) (part << 8);
					break;
				case 4:
					this.currentChar |= (char) (part << 2);
					break;
				case 5:
					this.currentChar |= (char) (part >> 4);
					chars[this.charOff] = this.currentChar;
					this.charOff++;
					this.currentChar = (char) ((part & 0x0f) << 12);
					break;
				case 6:
					this.currentChar |= (char) (part << 6);
					break;
				case 7:
					this.currentChar |= (char) part;
					chars[this.charOff] = this.currentChar;
					this.charOff++;
					break;
				}
				this.currentB64Off = (this.currentB64Off + 1) % 8;
				continue;
			}

			if (bytes[this.byteOff] == '+') {
				// shift character
				// This is start of the Base64 sequence.
				this.b64Context = true;
				this.currentB64Off = 0;
				continue;
			}
			chars[this.charOff] = (char) bytes[this.byteOff];
			this.charOff++;
		}
		return this.charOff - charStart;
	}

	@Override
	public int flush(char[] chars, int off, int len) {
		this.byteOff = 0;
		this.charOff = 0;
		this.b64Context = false;
		this.currentB64Off = 0;
		this.currentChar = 0;
		return 0;
	}

	@Override
	public String getCharacterEncoding() {
		return "UTF7";
	}

	@Override
	public void reset() {
		this.byteOff = 0;
		this.charOff = 0;
		this.b64Context = false;
		this.currentB64Off = 0;
		this.currentChar = 0;
	}

	/*
	 * public static void main(String[] args) throws Exception {
	 * System.setProperty("file.encoding.pkg", "com.sk_jp.io");
	 * ByteArrayOutputStream o = new ByteArrayOutputStream(); byte[] b = new
	 * byte[2048]; int len; while ((len = System.in.read(b)) != -1) { o.write(b,
	 * 0, len); } byte[] bytes = o.toByteArray();
	 * 
	 * System.out.println(new String(bytes, "UTF7")); }
	 */
}
