/*
 * @(#) $Id: CorrectOutputStreamWriter.java,v 1.3 2001/03/11 03:11:39 shin Exp $
 * $Revision: 1.3 $ Copyright (c) 2000 Shin Kinoshita All Rights Reserved.
 */
package com.sk_jp.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

/**
 * CorrectOutputStreamWriter.
 * <p>
 * OutputStreamをラップしてWAVE DASHなどの文字に対するtoUnicodeConverterの 変換揺れを補正します。<br>
 * </p>
 * <p>
 * </p>
 * 
 * @version $Revision: 1.3 $ $Date: 2001/03/11 03:11:39 $
 * @author Shin
 */
public class CorrectOutputStreamWriter extends OutputStreamWriter {
	private UnicodeCorrector corrector;

	/**
	 * Create an CorrectOutputStreamWriter that uses the platform default
	 * character encoding.
	 * 
	 * @param out
	 *            An OutputStream
	 */
	public CorrectOutputStreamWriter(OutputStream out) {
		super(out);
		try {
			this.corrector = UnicodeCorrector.getInstance(this.getEncoding());
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e.getMessage());
		}
	}

	/**
	 * Create an CorrectOutputStreamWriter that uses the named character
	 * encoding.
	 * 
	 * @param out
	 *            An OutputStream
	 * @param enc
	 *            Name of the encoding to be used
	 * @exception UnsupportedEncodingException
	 *                If the named encoding is not supported
	 */
	public CorrectOutputStreamWriter(OutputStream out, String enc)
			throws UnsupportedEncodingException {
		super(out, enc);
		this.corrector = UnicodeCorrector.getInstance(this.getEncoding());
	}

	/**
	 * Write a portion of an array of characters.
	 * <p>
	 * 特定の文字を特定エンコーディングで出力しようとした際の sun.ioコンバータでは正常に変換できない部分を補正します。
	 * </p>
	 * 
	 * @param cbuf
	 *            Buffer of characters
	 * @param off
	 *            Offset from which to start writing characters
	 * @param len
	 *            Number of characters to write
	 * 
	 * @exception IOException
	 *                If an I/O error occurs
	 */
	@Override
	public void write(char cbuf[], int off, int len) throws IOException {
		char[] buf = this.corrector.correct(cbuf, off, len);
		super.write(buf, 0, buf.length);
	}
}
