/*
 * @(#) $Id: JISDataSource.java,v 1.1 2004/07/12 04:48:14 Shin Exp $ $Revision:
 * 1.1 $ Copyright (c) 2000 Shin Kinoshita All Rights Reserved.
 */
package com.sk_jp.mail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

import javax.activation.DataSource;

import com.sk_jp.io.CharCodeConverter;
import com.sk_jp.io.UnicodeCorrector;

/**
 * テキストの本文を送信するための DataSource です。
 */
public class JISDataSource implements DataSource {
	private byte[] data;

	public JISDataSource(String s) {
		try {
			this.data = CharCodeConverter.sjisToJis(UnicodeCorrector
					.getInstance("Windows-31J").correct(s).getBytes(
							"Windows-31J"));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException("CANT HAPPEN");
		}
	}

	public String getContentType() {
		return "text/plain; charset=ISO-2022-JP";
	}

	public InputStream getInputStream() throws IOException {
		if (this.data == null) {
			throw new IOException("no data");
		}
		return new ByteArrayInputStream(this.data);
	}

	public String getName() {
		return "dummy";
	}

	public OutputStream getOutputStream() throws IOException {
		throw new IOException("cannot do this");
	}
}