/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

/**
 * メール処理での失敗もしくはラップされたAPIによってスローされた例外をラップする例外です。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public class MailException extends RuntimeException {

	private static final long serialVersionUID = -5124844533966076358L;

	/**
	 * 指定のメッセージで例外を構築します。
	 * 
	 * @param message
	 *            メッセージ
	 */
	public MailException(String message) {
		super(message);
	}

	/**
	 * 指定の原因で例外を構築します。
	 * 
	 * @param cause
	 *            原因
	 */
	public MailException(Throwable cause) {
		super(cause);
	}
}
