/*
 * @(#) $Id: PlainPartExtractor.java,v 1.7 2004/07/12 04:48:14 Shin Exp $
 * $Revision: 1.7 $ Copyright (c) 2000 Shin Kinoshita All Rights Reserved.
 */
package com.sk_jp.mail;

import java.io.IOException;

import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;

/**
 * text/plainを結合した文字列を得るPartHandlerです。
 * <P>
 * </P>
 * 
 * @version $Revision: 1.7 $ $Date: 2004/07/12 04:48:14 $
 * @author Shin
 */
public class PlainPartExtractor implements PartHandler {
	public static void main(String[] args) throws Exception {
		MimeMessage msg = new MimeMessage(javax.mail.Session
				.getDefaultInstance(System.getProperties(), null), System.in);
		PlainPartExtractor h = new PlainPartExtractor();
		MultipartUtility.process(msg, h);

		System.out.println("This is the detected text/plain parts.");
		System.out.println(h.getText());
	}

	private String text = null;

	public String getText() {
		return this.text;
	}

	public boolean processPart(Part part, ContentType context)
			throws MessagingException, IOException {
		if (!part.isMimeType("text/plain")) {
			return true;
		}
		if (this.text == null) {
			// 最初のテキストパートを無条件に抽出
			this.text = (String) MultipartUtility.getContent(part);
		} else {
			String disposition = part.getDisposition();
			if (disposition == null
					|| disposition.equalsIgnoreCase(Part.INLINE)) {
				this.text += "\r\n\r\n-- inline --\r\n\r\n"
						+ (String) MultipartUtility.getContent(part);
			}
		}
		return true;
	}
}
