/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

import java.util.Properties;

/**
 * メールレシーバのインスタンスを生成する機能を提供します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface MailReceiverFactory {

	/**
	 * 指定の接続プロパティを利用してメールレシーバのインスタンスを生成して返します。<br>
	 * プロパティは利用されるプロバイダによって要求されるキーと値が変わります。
	 * 
	 * @param protocol
	 *            プロトコル
	 * @param properties
	 *            プロパティ
	 * @return メールレシーバ
	 * 
	 * @throws NullPointerException
	 *             protocolもしくはpropertiesが{@code null}の場合
	 */
	MailReceiver getMailReceiver(MailReceiverProtocol protocol,
			Properties properties);

	/**
	 * 指定のホスト名をメール受信サーバとするメールレシーバのインスタンスを生成して返します。
	 * 
	 * @param protocol
	 *            プロトコル
	 * @param host
	 *            ホスト名
	 * @return メールレシーバ
	 * 
	 * @throws NullPointerException
	 *             protocolもしくはhostが{@code null}の場合
	 */
	MailReceiver getMailReceiver(MailReceiverProtocol protocol, String host);

	/**
	 * 指定のホスト名をメール受信サーバとするメールレシーバのインスタンスを生成して返します。
	 * 
	 * @param protocol
	 *            プロトコル
	 * @param host
	 *            ホスト名
	 * @param port
	 *            ポート番号
	 * @return メールレシーバ
	 * 
	 * @throws NullPointerException
	 *             protocolもしくはhostが{@code null}の場合
	 */
	MailReceiver getMailReceiver(MailReceiverProtocol protocol, String host,
			int port);
}
