/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

/**
 * メールサーバへの接続の設定を表現します。<br>
 * 実装によってこのオブジェクトが示す設定内容がサポートされない可能性があります。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public class Configuration {

	/**
	 * 標準の接続タイムアウトを示します。
	 */
	public static final long DEFAULT_CONNECTION_TIME_OUT = 5000L;

	/**
	 * 標準の送信タイムアウトを示します。
	 */
	public static final long DEFAULT_TIME_OUT = 5000L;

	private long connectionTimeout = Configuration.DEFAULT_CONNECTION_TIME_OUT;

	private boolean debug;

	private String password;

	private long timeout = Configuration.DEFAULT_TIME_OUT;

	private String user;

	/**
	 * 接続のタイムアウト(ミリ秒)を返します。
	 * 
	 * @return 接続のタイムアウト
	 */
	public long getConnectionTimeout() {
		return this.connectionTimeout;
	}

	/**
	 * パスワードを返します。
	 * 
	 * @return パスワード
	 */
	public String getPassword() {
		return this.password;
	}

	/**
	 * 送信のタイムアウト(ミリ秒)を返します。
	 * 
	 * @return 送信のタイムアウト
	 */
	public long getTimeout() {
		return this.timeout;
	}

	/**
	 * ユーザを返します。
	 * 
	 * @return ユーザ
	 */
	public String getUser() {
		return this.user;
	}

	/**
	 * デバッグモードを返します。
	 * 
	 * @return デバッグモード
	 */
	public boolean isDebug() {
		return this.debug;
	}

	/**
	 * 接続のタイムアウト(ミリ秒)を設定します。
	 * 
	 * @param connectionTimeout
	 *            接続のタイムアウト
	 */
	public void setConnectionTimeout(long connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	/**
	 * デバッグモードを設定します。
	 * 
	 * @param debug
	 *            デバッグモード
	 */
	public void setDebug(boolean debug) {
		this.debug = debug;
	}

	/**
	 * パスワードを設定します。
	 * 
	 * @param password
	 *            パスワード
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * 送信のタイムアウト(ミリ秒)を設定します。
	 * 
	 * @param timeout
	 *            送信のタイムアウト
	 */
	public void setTimeout(long timeout) {
		this.timeout = timeout;
	}

	/**
	 * ユーザを設定します。
	 * 
	 * @param user
	 *            ユーザ
	 */
	public void setUser(String user) {
		this.user = user;
	}
}
