/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

/**
 * メッセージの重要度を示します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public enum Importance {

	/**
	 * 高重要度を示します。
	 */
	HIGH("high", 1, "urgent"),

	/**
	 * 低重要度を示します。
	 */
	LOW("low", 5, "non-urgent"),

	/**
	 * 中重要度を示します。
	 */
	NORMAL("normal", 3, "normal"),

	;

	private String importance;

	private int xpriority;

	private String priority;

	private Importance(String importance, int xpriority, String priority) {
		this.importance = importance;
		this.xpriority = xpriority;
		this.priority = priority;
	}

	/**
	 * 一般のメーラが認知可能な重要度を示す文字列を返します。
	 * 
	 * @return 重要度
	 */
	public String getImportance() {
		return this.importance;
	}

	/**
	 * 一般のメーラが認知可能な優先度を示す文字列を返します。
	 * 
	 * @return 優先度
	 */
	public String getPriority() {
		return this.priority;
	}

	/**
	 * 一般のメーラが認知可能な優先度を示す数値を返します。
	 * 
	 * @return 優先度
	 */
	public int getXPriority() {
		return this.xpriority;
	}
}
