/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

import java.util.Properties;

/**
 * メールセンダーのインスタンスを生成する機能を提供します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface MailSenderFactory {

	/**
	 * 標準のSTMP Over SSLのポートを示します。
	 */
	int DEFAULT_SMTP_OVER_SSL_PORT = 587;

	/**
	 * 標準のSTMPのポートを示します。
	 */
	int DEFAULT_SMTP_PORT = 25;

	/**
	 * 指定の接続プロパティを利用してメールセンダーのインスタンスを生成して返します。<br>
	 * プロパティは利用されるプロバイダによって要求されるキーと値が変わります。
	 * 
	 * @param properties
	 *            プロパティ
	 * @return メールセンダー
	 * 
	 * @throws NullPointerException
	 *             propertiesが{@code null}の場合
	 */
	MailSender getMailSender(Properties properties);

	/**
	 * 指定のホスト名をメール送信サーバとするメールセンダーのインスタンスを生成して返します。
	 * 
	 * @param host
	 *            ホスト名
	 * @return メールセンダー
	 * 
	 * @throws NullPointerException
	 *             hostが{@code null}の場合
	 */
	MailSender getMailSender(String host);

	/**
	 * 指定のホスト名をメール送信サーバとするメールセンダーのインスタンスを生成して返します。
	 * 
	 * @param host
	 *            ホスト名
	 * @param ssl
	 *            SSLを使用するなら{@code true}
	 * @return メールセンダー
	 * 
	 * @throws NullPointerException
	 *             hostが{@code null}の場合
	 */
	MailSender getMailSender(String host, boolean ssl);

	/**
	 * 指定のホスト名をメール送信サーバとするメールセンダーのインスタンスを生成して返します。
	 * 
	 * @param host
	 *            ホスト名
	 * @param port
	 *            ポート番号
	 * @return メールセンダー
	 * 
	 * @throws NullPointerException
	 *             hostが{@code null}の場合
	 */
	MailSender getMailSender(String host, int port);

	/**
	 * 指定のホスト名をメール送信サーバとするメールセンダーのインスタンスを生成して返します。
	 * 
	 * @param host
	 *            ホスト名
	 * @param ssl
	 *            SSLを使用するなら{@code true}
	 * @param port
	 *            ポート番号
	 * @return メールセンダー
	 * 
	 * @throws NullPointerException
	 *             hostが{@code null}の場合
	 */
	MailSender getMailSender(String host, int port, boolean ssl);
}
