/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

import java.util.Date;

/**
 * 受信メールを表現します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface ReceivedMail extends Mail {

	/**
	 * メールの受信日時を返します。
	 * 
	 * @return 受信日時
	 */
	Date getReceivedDate();

	/**
	 * このメールのヘッダのうち、Receivedヘッダのみを配列で返します。<br>
	 * 存在しない場合は空の配列を返します。
	 * 
	 * @return Receivedヘッダの配列
	 */
	ReceivedHeader[] getRecievedHeaders();

	/**
	 * メールの目安となる容量を返します。<br>
	 * 正確な容量ではありません。
	 * 
	 * @return 容量
	 */
	long getSize();
}
