﻿$spilt_size = 1024 * 512;	//分割するサイズ
$reset_password_diff = 1000 * 60 * 60;	//ルームパスワードをリセットする間隔
$gc_time_interval = 1000 * 60 * 60;	//ゴミ掃除を行う間隔
$ip_ban_list_file_name = "ipbanlist.txt";	//アクセスを禁止するIPが記録されているファイル
$room_configure_file_name = "roomlist.txt";	//ルームの設定が記録されているファイル
$system_name = "system";	//システム発言を表す名前
$log_directory = "log";	//ログファイルを置くフォルダー
$log_file_name = "logfile%d.txt";	//ログファイル名(%dはそのままにしておくこと)
$splited_log_file_name = "logfile%d_%s.txt"	//分割後のファイル名(%dと%sはそのままにしておくこと)

var clients = new Array();

var IpBan = require("./ipban.js")
var ipbanlist = new IpBan();
var RoomInfomationCollection = require("./room.js");
var $rooms = new RoomInfomationCollection();

createLogDirectory();

var sessionStore;

module.exports = function(app,server,express,session){
	sessionStore = session;
	app.get("/chat", chat_proc);
	app.all("/log/*",express.basicAuth(auth_proc));
	app.get("/log/*",log_proc);
	app.all("/chat/admin",express.basicAuth(auth_proc));
	app.get("/chat/admin", admin_proc);
	app.post("/chat/admin",admin_postproc);

	var config = require("./configure.js");
	var io = require("socket.io").listen(server);
	io.configure("production", function(){
		io.set("transports", config.transports);
		io.enable("browser client minification");  // minified されたクライアントファイルを送信する
		io.enable("browser client etag");          // バージョンによって etag によるキャッシングを有効にする
		io.set("log level", 1);                    // ログレベルを設定(デフォルトより下げている)
	});

	for(var i = 0; i < config.max_room_number; i++)
	{
		clients[i] =io
		.of(GetNameFromRoomNumber(i))
		.authorization(ParseAuthorization)
		.on("connection",ParseConnect);
	}
};

function chat_proc(req, res){
	var security = require("./security.js");
	var info = new security.SessionInfomation(false);
	req.session.items = info;

	var room_number = 0;
	if(typeof(req.query.rno) != "undefined")
		room_number = req.query.rno;
	res.render("chat",{rno:room_number,token:req.session._csrf});
}

function auth_proc(user, pass) {
	var config = require("./configure.js");
	return user === config.username && pass === config.password;
}

function log_proc(req, res) {
	res.sendfile(__dirname + req.url);
}

function admin_postproc(req,res){
	if(typeof(req.body.erase) != "undefined")
	{
		removeLog(req.body.file,function(){
			res.redirect("/chat/admin");
		});
	}
	if(typeof(req.body.registor) != "undefined")
	{
		ipbanlist.Update(req.body.newbanlist,function(){
			res.redirect("/chat/admin");
		});
	}
	if(typeof(req.body.updateroom) != "undefined")
	{
		$rooms.Update(req.body,function(){
			res.redirect("/chat/admin");
		});
	}
}

function admin_proc(req,res)
{
	var security = require("./security.js");
	var info = new security.SessionInfomation(true);
	req.session.items = info;
	var iplist = ipbanlist.GetText();
	var fs = require("fs");

	fs.readdir($log_directory,function(err,list){
		res.setHeader("X-FRAME-OPTIONS","DENY");
		res.render("admin", {
			files: list,
			log_directory:$log_directory,
			ipbanlist:iplist,
			token:req.session._csrf,
			roomlist:$rooms.GetMessage()
		});
	});
}

function removeLog(files,callback)
{
	if(typeof(files) == "undefined")
	{
		if(typeof(callback) == "function")
			callback();
		return;
	}
	var async = require("async");
	async.map(files,
	function(item,callback){
		var fs = require("fs");
		fs.unlink($log_directory + "/" + item,callback);
	},
	function(err,results){
		if(typeof(callback) == "function")
			callback();
	});
}

function createLogDirectory()
{
	var fs = require("fs");
	fs.exists($log_directory,function(exists){
		if(exists == false)
			fs.mkdirSync($log_directory);
	});
}

function ParseConnect(socket)
{
	var ip = GetClientIPAdress(socket);
	console.log("connected from %s",ip);

	var rno = GetRoomNumberFromName(socket.namespace.name);

	var room = $rooms.Get(rno);

	room.AddRom(ip);

	var roomconfig = room.GetConfig();
	socket.json.emit("send roominfo",roomconfig);

	var romcount = room.GetRomCount();
	socket.json.emit("send romcount",romcount);
	socket.json.broadcast.emit("send romcount",romcount);

	socket.on("get pastLog", function (msg) {
		ParseGetPastLog(socket,msg);
	});
	socket.on("join",function(msg){
		ParseJoin(socket,msg);
	});
	socket.on("quit",function(msg){
		ParseQuit(socket,msg);
	});
	socket.on("set password",function(msg){
		ParseSetPassword(socket,msg);
	});
	socket.on("send msg", function (msg) {
		ParseSendMsg(socket,msg);
	});
	socket.on("disconnect", function (msg) {
		ParseDisconnect(socket,msg);
	});
}

function ParseAuthorization(handshakeData, callback)
{
	var connectUtils = require("express/node_modules/connect/lib/utils");
	if(handshakeData.headers.cookie) {
		var cookie = require("express/node_modules/cookie");
		var signedCookie = cookie.parse(handshakeData.headers.cookie);
		var sessionID = connectUtils.parseSignedCookies(signedCookie, $secret)["connect.sid"];
		sessionStore.get(sessionID, function (err, session) {
			var result = null;
			if (ipbanlist.IsBaned(handshakeData.address.address))
				result = "failed get from session store";
			else if(err)
				result = err;
			else if(typeof(session) == "undefined" || typeof(session._csrf) == "undefined")
				result = "session is undefined";
			else if(handshakeData.query.token != session._csrf)
				result = "invaild token";
			if(result == null)
				handshakeData.sessionID = sessionID;
			callback(result,result == null && !err);
		});
	} else {
		return callback("failed get cookie", false);
	}
}

function ParseDisconnect(socket,msg)
{
	var ip = GetClientIPAdress(socket);
	var rno = GetRoomNumberFromName(socket.namespace.name);
	$rooms.Get(rno).RemoveRom(ip);

	var romcount = $rooms.Get(rno).GetRomCount();
	socket.json.emit("send romcount",romcount);
	socket.json.broadcast.emit("send romcount",romcount);

	console.log("disconnected");
}

function ParseSetPassword(socket,msg)
{
	var rno = GetRoomNumberFromName(socket.namespace.name);
	var newMeg = {
		name:$system_name,
		message:null,
	};
	var resource = require("./resources.js");
	if($rooms.Get(rno).IsVolatile() == false && $rooms.Get(rno).SetPassword(msg.owner,msg.password))
		newMeg.message = resource.password_setted_message;
	else
		newMeg.message = resource.failed_set_password_message;
	ParseSendMsg(socket,newMeg);
}

function ParseJoin(socket,msg)
{
	var ip = GetClientIPAdress(socket);

	if(ipbanlist.IsBlockedToWrite(ip))
	{
		var resource = require("./resources.js");
		socket.emit("error",resource.block_message);
		return;
	}

	var rno = GetRoomNumberFromName(socket.namespace.name);

	$rooms.Get(rno).RemoveRom(ip);
	
	var romcount = $rooms.Get(rno).GetRomCount();
	socket.json.emit("send romcount",romcount);
	socket.json.broadcast.emit("send romcount",romcount);

	var util = require("util");
	if($rooms.Get(rno).IsVolatile() == false)
	{
		if($rooms.Get(rno).IsTimeout() ||
			$rooms.Get(rno).IsFirstAuth())
		{
			$rooms.Get(rno).Reset(msg.name);
			ParseGetPastLog(socket,util.format($log_file_name,rno));
		}
		else if($rooms.Get(rno).Auth(msg.name,msg.password))
		{
			ParseGetPastLog(socket,util.format($log_file_name,rno));
		}
		else
		{
			var resource = require("./resources.js");
			socket.emit("error",resource.unmatch_password);
			return;
		}
	}

	var newMeg = {
		name:$system_name,
		message:util.format("/enteredby %s %s %s",msg.name,msg.color,msg.mailto),
	};
	ParseSendMsg(socket,newMeg);
}

function ParseQuit(socket,msg)
{
	var ip = GetClientIPAdress(socket);

	var resource = require("./resources.js");
	if(ipbanlist.IsBlockedToWrite(ip))
	{
		socket.emit("error",resource.block_message);
		return;
	}

	var rno = GetRoomNumberFromName(socket.namespace.name);

	var newMeg = {
		name:$system_name,
		message:resource.password_resetted_message,
	};

	$rooms.Get(rno).AddRom(ip);

	var romcount = $rooms.Get(rno).GetRomCount();
	socket.json.emit("send romcount",romcount);
	socket.json.broadcast.emit("send romcount",romcount);

	if($rooms.Get(rno).IsVolatile() == false)
	{
		if($rooms.Get(rno).IsOwner(msg.name))
		{
			$rooms.Get(rno).Reset(null);
			ParseSendMsg(socket,newMeg);
		}
		if(!$rooms.Get(rno).IsFirstAuth() &&
			!$rooms.Get(rno).IsAuthed(msg.name))
			return;
		else
			$rooms.Get(rno).RemoveAuth(msg.name);
	}

	var util = require("util");
	newMeg.message = util.format("/quitedby %s",msg.name);
	ParseSendMsg(socket,newMeg);
}

//socket 接続中のソケット
//msg msgクラス
function ParseSendMsg(socket,msg)
{
	var ip = GetClientIPAdress(socket);

	if(ip in ipbanlist)
	{
		var resource = require("./resources.js");
		socket.emit("error",resource.block_message);
		return;
	}

	var rno = GetRoomNumberFromName(socket.namespace.name);

	if(msg.name != $system_name && 
		$rooms.Get(rno).IsVolatile() == false &&
		!$rooms.Get(rno).IsAuthed(msg.name) &&
		!$rooms.Get(rno).IsOwner(rno,msg.name))
	{
		return;
	}

	var date = new Date();

	var repacked_msg = CreateMessage(msg.name,date,msg.message);

	if(socket.handshake.admin)
		repacked_msg.ip = ip;

	socket.json.emit("req msg", repacked_msg);

	socket.json.broadcast.emit("req msg", repacked_msg);

	var util = require("util");
	var path = $log_directory + "/" + util.format($log_file_name,rno);
	var log = new ChatLog(path);
	log.Save(repacked_msg,ip,rno);
}

function GetNameFromRoomNumber(number)
{
	return "/" + number;
}

function GetRoomNumberFromName(name)
{
	if(name.charAt(0) == "/")
		return parseInt(name.substr(1));
	throw "GetRoomNumberFromName error";
}

function ParseGetPastLog(socket,file)
{
	if(file == "")
		return;
	var path = $log_directory + "/" + file;
	var log = new ChatLog(path);
	var config = require("./configure.js");
	log.ToArray(config.showip,function(array){
		socket.json.emit("req pastlog",array);
	});
}

function ChatLog(path)
{
	this.ToArray = function(hasIp,callback)
	{
		var fs = require("fs");
		var state = fs.stat(path,function(err,state){
			if(err)
				return;
			var array = new Array();
			var stream = fs.createReadStream(path);
			var lazy = require("lazy");
			new lazy(stream)
				.lines
				.forEach(function(line){
					var msg = CreateMessageFromText(line.toString());
					if(hasIp == false)
						msg.ip = "";
					array.push(msg);
				})
				.join(function(){
					callback(array);
				});
		});
	}

	this.Save = function(msg,ip,rno){
		var text = GetTextFromMessage(msg,ip);

		SplitLog(rno,function(){
			WritePastLog(path,text);
		});
	};

	function GetTextFromMessage(msg,ip)
	{
		var text = msg.name + "<>" +
				msg.date + "<>" +
				ip + "<>" +
				msg.message +
				"\n";
		return text;
	}

	function SplitLog(rno,callback)
	{
		var util = require("util");
		var fs = require("fs");
		var state = fs.stat(path,function(err,state){
			if(err && typeof(callback) == "function")
			{
				callback();
				return;
			}
			if(state.size > $spilt_size)
			{
				var date = new Date();
				var dateString = ""+date.getFullYear()+date.getMonth()+date.getDate()+date.getHours()+date.getMinutes()+date.getSeconds();

				var newpath = $log_directory + "/" +
					util.format($splited_log_file_name,rno,dateString);
				fs.rename(path,newpath,callback);
			}else{
				if(typeof(callback) == "function")
					callback();
			}
		});
	}

	function WritePastLog(path,text)
	{
		var fs = require("fs");
		var async = require("async");
		async.waterfall([
			function(callback){
				fs.open(path,"a",callback);
			},
			function(fd,callback){
				var buf = new Buffer(text);
				fs.write(fd,buf,0,Buffer.byteLength(text),null,function(){
					callback(null,fd);
				});
			},
			function(fd){
				fs.close(fd);
			}
		]);
	}
}

function GetClientIPAdress(socket)
{
	return socket.handshake.headers["x-forwarded-for"] || socket.handshake.address.address;
}

// Message クラス
function CreateMessage(name,date,message)
{
	var result = {name:name,
		date:date,
		ip:"",
		message:message};
	return result;
}
function CreateMessageFromText(text)
{
	var data = text.split("<>");
	var msg = {name:data[0],
		ip:data[2],
		date:data[1],
		message:data[3]};
	return msg;
}
