﻿var async = require("async");

module.exports = function(param)
{
	this.query = function(query,param,callback)
	{
		async.waterfall([
			function(next){
				pool.acquire(next);
			},
			function(client,next){
				client.query(query,param,function(err,result){
					next(err,result,client);
				});
			},
			function(result,client,next){
				pool.release(client);
				next(null,result);
			}
		],callback);
	}
	var generic_pool = require("generic-pool");
	var mysql = require("mysql");
	pool = generic_pool.Pool({
		name : "mysql",
		max : 10,
		create : function(cb){
			var connection = mysql.createConnection(param);
			connection.connect(function(err){
				cb(err,connection);
			});
		},
		destroy : function(db){
			db.end();
		}
	});
}
