﻿$expires = 30;	//クッキーの保持日数
$afk_time = 1000 * 60 * 60;	//AFKと判定する時間（ミリ秒で指定すること）
$log_file_name = "logfile%d.txt";	//ログファイル名(%dはそのままにしておくこと)
$pastlogfile_pattern = "logfile%d(_+.*)?\.txt";	//過去ログと判定する正規表現
$system_name = "system";	//システム発言を表す名前(chat.phpと同じにすること)
$entered_message = "%sが入室しました";
$quited_message = "%sが退室しました";
$system_msg_color ="#000000";
$profile_link = "/profile/detail?name=%n"	//プロフィールシステムへのリンク先（%nで名前を表す）
$fanble_message = "[color=blue]%s ファンブル![/color]";
$critical_message = "[color=red]%s クリティカル![/color]";
$send_message = "%sからの送信　%s";
$failed_connect_message = "接続に失敗しました";
$invaild_name_message = "名前を空欄にすることはできません";
$free_password1 = "最初に入室する人が自由にパスワードを設定できます";	//自由パスワードメッセージ１
$free_password2 = "この部屋は使用されています。パスワードを入力してください";	//自由パスワードメッセージ２
$fixed_password = "この部屋にはパスワードが設定されています";	//固定パスワードルーム
$hidden_log_to_rom = "この部屋ではROMできないようになっています";	//ROM禁止ルーム
$romcount_msg = "ROM(%d人)"	//ROMカウント

//ここから先は変更しないでください
$prefix_filelist = "!";
$socket = new Object();
$names = {};
$roominfo = {};
$romcount = 0;
//ここまで

$(document).ready(function(){
	CreateColorList();

	//クッキーからフォームに読み込む
	var temp = $.cookie("name");
	if(temp)	document.enter_form.name.value = temp;
	temp = $.cookie("color_index");
	if(temp)	document.enter_form.color.selectedIndex = temp;

	$("input[name=sid]").click(sidEventListener);
	$("input[name=enter]").click(enterEventListener);
	$("input[name=quit]").click(quitEventListener);
	$("input[name=help]").click(function(e){
		$("#help_frame").css("display","block");
	});
	$("input[name=close]").click(function(e){
		$("#help_frame").css("display","none");
	});
	$("#whisper_list_view").click(function(e){
		$("#whisper_list").toggle();
	});
	$("#decoration_list_view").click(function(e){
		$("#decoration_list").toggle();
	});
	document.chat_form.onsubmit = function(){return false;};
	document.enter_form.onsubmit = function(){return false;};

	$socket = io.connect(location.hostname  + "/" + document.chat_form.rno.value + "?token="+ encodeURIComponent(document.chat_form._csrf.value));
	$socket.on("error",getErrorMessage);
	$socket.on("send roominfo",sendRoomInfoListerner);
	$socket.on("send romcount",sendRomCountListerner);
	$socket.on("connect",function(){
		$socket.on("req pastlog",pastLogEventListerner);
		$socket.on("req msg",getMessageEventListerner);
	});
});

function sendRomCountListerner(count)
{
	$romcount = count;
	createNameList();
}

function sendRoomInfoListerner(info)
{
	$roominfo = info;
	var logflag = true;
	var msg = "";
	if(info.type == 1){
		if(info.IsOwned)
			msg = $free_password2;
		else
			msg = $free_password1;
		logflag = false;
	}else if(info.type == 2){
		msg = $fixed_password;
		logflag = false;
	}else if(info.type == 3){
		msg = $hidden_log_to_rom;
		logflag = false;
	}
	if(msg != "")
		$("#enter_message").append(msg);
	if(logflag)
	{
		getCurretLog();
	}
}

function CreateColorList()
{
	var c = new Array("00","33","66","99","CC","FF");
	for(var r = 0; r < c.length; r++){
		for(var g = 0; g < c.length; g++){
			for(var b = 0; b < c.length; b++){
				var t = document.createElement("option");
				t.value = "#"+c[r]+c[g]+c[b];
				t.style.backgroundColor = "#"+c[r]+c[g]+c[b];
				t.appendChild(document.createTextNode("#"+c[r]+c[g]+c[b]));
				$("#enter_frame form select[name=color]").append(t);
			}
		}
	}
}

function getCurretLog()
{
	var rno = document.chat_form.rno.value;
	var url = sprintf($log_file_name,rno);
	$socket.emit("get pastLog",url);
}

function pastLogEventListerner(msg)
{
	if(IsRomMode() && $roominfo.type != 0 && $roominfo.admin == false)
		return;
	for(var i = 0; i < msg.length; i++)
		ParseMessage(msg[i]);
	createNameList();
}

function getMessageEventListerner(msg)
{
	if(IsRomMode() && $roominfo.type != 0)
		return;
	ParseMessage(msg);
	createNameList();
	if( document.getElementById("bell").checked == true && msg.name != document.enter_form.name.value)
		document.getElementById("NoticeSound").play();
}

var $messageTag = null;
function ParseMessage(msg)
{
	var util = new Util();
	msg.message = util.htmlspecialchars(msg.message);
	var childtag = $GetCommandParser.parse(msg);

	if(childtag == null)
		return;
	if(typeof(childtag) == "string")
		childtag = $("<span/>").append(childtag);

	var trtag = $("<tr/>");
	var namepart,msgpart;

	var color = $system_msg_color;

	var mailto = "";
	var date = new Date(Date.parse(msg.date));
	var name = util.htmlspecialchars(msg.name);
	if(name != $system_name && name in $names)
	{
		color = $names[name].color;
		$names[name].time = date.getTime();
		namepart = $("<a/>")
			.attr("href",GetNameLink(name))
			.attr("target","_blank")
			.css("color",color)
			.text(name);
	}else{
		namepart = $("<span/>").append(name);
	}
	if(msg.ip != "")
		namepart.append("@" + msg.ip);
	trtag.append($("<td/>").append(namepart));

	msgpart = childtag
		.append("(" + date.toFormat("YYYY/MM/DD HH:MI:SS") +")")
		.css("color",color);
	trtag.append($("<td/>").append(msgpart));

	if($messageTag == null)
		$messageTag = $("#message");

	$messageTag.prepend(trtag);
}

function GetNameLink(name)
{
	var util = new Util();
	if($names[name].mailto == "")
		return $profile_link.replace("%n",encodeURIComponent(name));
	return "mailto:" + util.htmlspecialchars($names[name].mailto);
}

function createNameList()
{
	var date = new Date();
	$("#whisper_list").empty();
	$("#whisper_list").append("<ul></ul>");

	$("#namelist").empty();
	$("#namelist").append("<ul></ul>");
	$("#namelist > ul").append($("<li/>").append(sprintf($romcount_msg,$romcount)));

	for(var name in $names)
	{
		var diff = date.getTime() - $names[name].time;
		if(diff >= $afk_time)
			continue;
		if(name != $system_name)
		{
			var atag = $("<a/>")
				.attr("href",GetNameLink(name))
				.attr("target","_blank")
				.css("color",$names[name].color)
				.text(name);
			var spantag = $("<span/>")
				.click(clickNameEventListener)
				.text(name);
			$("#whisper_list > ul").append($("<li/>").append(spantag));
			$("#namelist > ul").append($("<li/>").append(atag));
		}
	}
}

function clickNameEventListener(e)
{
	document.chat_form.message.value = "/tell " + $(this).text();
	document.chat_form.message.focus();
}

function AddBold()
{
	var text = GetSelection(document.chat_form.message);
	ReplaceSelection(document.chat_form.message,sprintf("[b]%s[/b]",text));
}

function AddItalic()
{
	var text = GetSelection(document.chat_form.message);
	ReplaceSelection(document.chat_form.message,sprintf("[i]%s[/i]",text));
}

function AddStrike()
{
	var text = GetSelection(document.chat_form.message);
	ReplaceSelection(document.chat_form.message,sprintf("[s]%s[/s]",text));
}

function AddFontSize(size)
{
	var text = GetSelection(document.chat_form.message);
	ReplaceSelection(document.chat_form.message,sprintf("[size=%f]%s[/size]",size,text));
}

function GetSelection(element)
{
    if (document.selection) {
        element.focus();
        var sel = document.selection.createRange();
        return sel.text;
    } else if (element.selectionStart || element.selectionStart === 0) {
        var startPos = element.selectionStart;
        var endPos = element.selectionEnd;
        var scrollTop = element.scrollTop;
        return element.value.substring(startPos,endPos);
    }else{
        return "";
    }
}

function ReplaceSelection(element,text)
{
    if (document.selection) {
        element.focus();
        var sel = document.selection.createRange();
        sel.text = text;
    } else if (element.selectionStart || element.selectionStart === 0) {
        var startPos = element.selectionStart;
        var endPos = element.selectionEnd;
        element.value = element.value.substring(0, startPos) + text + element.value.substring(endPos, element.value.length);
    } else{
       element.value = text;
    }
}

function enterEventListener()
{
	if(document.enter_form.name.value == "")
	{
		alert($invaild_name_message);
		return;
	}

	$("#enter_frame").css("display","none");
	$("#chat_frame").css("display","block");

	var color = document.enter_form.color.options[document.enter_form.color.selectedIndex].value;

	$.cookie("name",document.enter_form.name.value,{ expires: $expires });
	$.cookie("color_index",document.enter_form.color.selectedIndex,{ expires: $expires });

	$socket.json.emit("join",{name:document.enter_form.name.value,color:color,mailto:document.enter_form.mailto.value,password:document.enter_form.password.value});
}

function quitEventListener(){
	$socket.json.emit("quit",{name:document.enter_form.name.value});

	$("#enter_frame").css("display","block");
	$("#chat_frame").css("display","none");

	if($roominfo.type != 0 && $roominfo.admin == false)
	{
		$("#message").empty();
		$("#namelist").empty();
		$names = {};
		createNameList();
	}
	else
		$socket.json.emit("get pastLogList",{rno:document.chat_form.rno.value});
}

function sidEventListener(){
	var msg = {
		name:document.enter_form.name.value,
		message:document.chat_form.message.value
	};	
	msg.message = $PostCommandParser.parse(msg);

	if(msg.message != null && msg.message != "")
		$socket.json.emit("send msg",msg);

	document.chat_form.message.value ="";
}

function ReflushChatMessage(flag)
{
	if(flag)	$("#message").empty();
}

function getErrorMessage(text)
{
	if(text == "")
		alert($failed_connect_message);
	else
		alert(text);
}

function IsRomMode()
{
	return $("#chat_frame").css("display") == "none";
}

//NameCollectionクラス
function GetNameCollection(text)
{
	var output = new Array();
	var list = text.split("\n");
	for(var i = 0; i < list.length; i++)
	{
		if(list[i] == "")
			continue;
		output.push(new NameElement(list[i]));
	}
	return output;
}

//
// NamesElementsクラス
//
function NameElement(s)
{
	this.data = s.split("<>");
	this.getName = function()
	{
		return this.data[0];
	}
}

// NameInfoクラス
function CreateNameInfo(time,color,mailto)
{
	var result = { time:time,color:color,mailto:""};
	if(typeof(mailto) != "undifined")
		result.mailto = mailto;
	return result;
}

//
// Utilクラス
//
function Util()
{
	this.get_random_number = function (a,b)
	{
		return Math.floor(a + Math.random() * b);
	}

	this.htmlspecialchars = function (ch) {
		ch = ch.replace(/&/g,"&amp;") ;
		ch = ch.replace(/"/g,"&quot;") ;
		ch = ch.replace(/'/g,"&#039;") ;
		ch = ch.replace(/</g,"&lt;") ;
		ch = ch.replace(/>/g,"&gt;") ;
	  return ch ;
	}

}
