package tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

import lib.log.logWriter;

import http.HttpConstValue;

/**
 * TcpʐM𐧌䂷NX
 * @author tak
 */
public class TcpServer extends Thread{
    int port_num = 80;

    public TcpServer(int num) {
        port_num = num;
    }
    public TcpServer() {}

    /** uEŨNGXgi[ */
    public ArrayList<String> requestHeader = null;

    /** uEUւ̃X|X(oCg) */
    public ArrayList<byte[]> responseBytes = null;

    public boolean isGotReq = false;
    public boolean continuos = false;
    public boolean isKeepAive = true;

    ServerSocket serverSocket = null;
    Socket socket = null;

    OutputStream ops = null;
    InputStream ips = null;

    /**
     * Xbhs
     */

    public void run() {
        logWriter log = new logWriter("./logs/TcpServer.log");
        continuos = true;
        while(continuos) {
            try {
                // ڑ܂őҋ@
                serverSocket = new ServerSocket(port_num);
                socket = serverSocket.accept();
                socket.setSoTimeout(1000);
            } catch (IOException e) {
        		StringWriter sw = new StringWriter();
        		PrintWriter pw = new PrintWriter(sw);
        	    e.printStackTrace(pw);
        	    String trace = sw.toString();
            	log.logWriteStr(trace);
                System.out.println(e.getMessage());
                continuos = false;
                continue;
            }
            // ڑmXg[쐬
            try{
                //o̓Xg[擾
                ops = socket.getOutputStream();

                // ̓Xg[擾
                ips = socket.getInputStream();
            }
            catch(IOException e){
                e.printStackTrace();
                break;
            }
            while(isKeepAive){

                // uEU烊NGXg̎M
                try {
                    int recvLength = 0;
                    requestHeader = new ArrayList<String>();
                    byte[] recvByte = new byte[HttpConstValue.TCP_RECV_BYTE];
                    recvLength = ips.read(recvByte);
                    if(recvLength < 0) {
                        break;
                    }
                    byte[] setByte = new byte[recvLength];
                    for(int i = 0;i < recvLength;i++) {
                        setByte[i] = recvByte[i];
                    }
                    requestHeader.add(new String(setByte));

                } catch (IOException e1) {
                    System.out.println(e1.getMessage());
                    break;
                }

//                for(String str:requestHeader){
//                    System.out.println(str);
//                }
                // NGXgM̂ŉ͂̂҂
                isGotReq = true;
                while(true) {
                    try{
                        Thread.sleep(1);
                    } catch(InterruptedException e) {
                        isGotReq = false;
                        break;
                    }
                }
                requestHeader = null;

                // X|XuEUɏo͂
                try{
                    int length = 0;
                    for(byte[] bytes:responseBytes) {
                        length += bytes.length;
                    }
                    byte[] sendBytes = new byte[length];
                    length = 0;
                    for(byte[] bytes:responseBytes) {
                        for(int i = 0;i < bytes.length;i++,length++) {
                            sendBytes[length] = bytes[i];
                        }
                    }
//                    System.out.println(new String(sendBytes));
                    ops.write(sendBytes);
                } catch (IOException e) {
                    System.out.println(e.getMessage());
                    break;
                }
            }
            socketClose();
        }
        log.close();
        continuos = false;
    }
    /**
     * SocketN[Y\bh.
     */
    public void socketClose() {
        try{
            if(ips != null){
                ips.close();
                ips = null;
            }
            if(socket != null && !socket.isClosed()){
                socket.close();
                socket = null;
            }
            if(serverSocket != null && !serverSocket.isClosed()){
                serverSocket.close();
                serverSocket = null;
            }
            if(ops != null){
                ops.close();
                ops = null;
            }
        }
        catch(IOException e){
            e.printStackTrace();
        }
    }
}
