﻿#pragma once
/*
  ==============================================================================

   This file is part of the async
   Copyright 2005-10 by Satoshi Fujiwara.

   async can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   async is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with async; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/
#include "singleton.h"
#include "exception.h"
#include "ring_buffer.h"
#include "wasapi.h"
#include "async_reader.h"
#include "sf_memory.h"
#include "toplevel_window.h"
#include "reader_thread.h"
#include "output_thread.h"
#include "input_thread.h"
#include "mixer_thread.h"

namespace sf {
class application : public singleton<application>
{
  static const size_t Q_SIZE = 8;
public:
  struct exception
    : public sf::win32_error_exception 
  {
    exception(uint32_t hr) : win32_error_exception(hr) {};
    exception() : win32_error_exception() {} ;
  };

 
  application();
  ~application();
  
  int execute(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow);
  

  std::wstring& app_id(){return app_id_;};
  HINSTANCE instance_handle() {return instance_handle_;};
  
  // アプリケーションのカレントディレクトリを返す
  const std::wstring& base_directory() const { return base_directory_; }

 
// ----------------------------------------
private:
// ----------------------------------------

  //void wasapi_setup();
  HINSTANCE instance_handle_;
  int return_code_;
  
//---------------------------------------
// ファイル読取り関係
//---------------------------------------
public:

  void reader_setup(const std::wstring& file_path);
  void reader_read_file();
  void reader_pause();
  void reader_stop();
  void reader_end();
  uint64_t reader_position() {return reader_thread_.position();}
  void reader_position(uint64_t pos){reader_thread_.position(pos);}
  uint64_t reader_data_size(){return reader_thread_.size();}
  void reader_repeat_mode(bool v){ reader_thread_.repeat_mode(v);}
  bool reader_repeat_mode(){ return reader_thread_.repeat_mode();}
  int reader_status(boost::memory_order o = boost::memory_order_seq_cst) {return reader_thread_.status(o);}
  ringbuffer_t& reader_ringbuffer() {return reader_thread_.ringbuffer();}
private:
  reader_thread_t reader_thread_;

// ----------------------------
// WASAPI出力関係
// ----------------------------
// 出力デバイスの設定・変更
public:
  void apply_output_device_config(int device_index,wasapi_device_manager::device_info::params_t& params);
  audio_base& output_device() {return output_thread_.device();}
  ringbuffer_t& output_ringbuffer() {return output_thread_.ringbuffer();}
  output_thread_t& output_thread(){return output_thread_;}
private:
  output_thread_t output_thread_;
// -----------------------------  
// WASAPI入力関係
// -----------------------------  
public:
  void apply_input_device_config(int device_index,wasapi_device_manager::device_info::params_t& params)
  {
      input_thread_.apply_config(device_index,params);
  };
  audio_base& input_device() {return input_thread_.device();}
  ringbuffer_t& input_ringbuffer() {return input_thread_.ringbuffer();}
  input_thread_t& input_thread(){return input_thread_;}
private:
  input_thread_t input_thread_;

// -----------------------------  
// ミキサー関係
// -----------------------------  
public:
  ringbuffer_t& mixer_ringbuffer(){return mixer_thread_.ringbuffer();}
  mixer_thread_t& mixer_thread(){return mixer_thread_;}
private:
  mixer_thread_t mixer_thread_;

// -----------------------------  
// その他
// -----------------------------  

  std::wstring base_directory_;
  sf::toplevel_window_ptr window_;
  static std::wstring app_id_;
  static const int WAIT_TIMEOUT_DEFAULT = 100; 

};
}

