﻿#pragma once
/** @file
*  @brief MIDI Messageのヘッダーファイル
*/
#include "seq_message.h"
#include "midi_input.h"
#include "midi_output.h"

namespace sf {
    namespace MIDIメッセージ 
    {

    struct ID 
    {
        enum {
        ノートオン = 0x90,
        ノートオフ = 0x80,
        ポリフォニックキープレッシャ = 0xa0,
        コントロールチェンジ = 0xb0,
        プログラムチェンジ = 0xc0,
        チャンネルプレッシャ = 0xd0,
        ピッチベンド = 0xe0,
        システムエクスクルーシブ = 0xf0,
        クォータフレーム = 0xf1,
        ソングポジションポインタ = 0xf2,
        ソングセレクト = 0xf3,
        チューンリクエスト = 0xf6,
        エンドオブエクスクルーシブ = 0xf7,
        タイミングクロック = 0xf8,
        MIDIクロックスタート = 0xfa,
        MIDIクロックコンティニュー = 0xfb,
        MIDIクロックストップ = 0xfc,
        アクティブセンシング = 0xfe,
        システムリセット = 0xff
        };
      };

    /*
    0 00 32 20 バンクセレクト（音色バンクの切替） 
    1 01 33 21 モジュレーション・デプス 
    2 02 34 22 ブレスコントロール（息を吹き込む強さによるコントロール） 
    3 03 35 23 （未定義） 
    4 04 36 24 フットコントロール（フットペダルによるコントロール） 
    5 05 37 25 ポルタメントタイム 
    6 06 38 26 データエントリ（ＲＰＮ／ＮＲＰＮで指定したパラメータの値を設定） 
    7 07 39 27 メインボリューム(チャンネルの音量を設定） 
    8 08 40 28 バランスコントロール（上の音域と下の音域のバランス） 
    9 09 41 29 （未定義） 
    10 0A 42 2A パンポット（定位－左右のバランス） 
    11 0B 43 2B エクスプレッション（音量の抑揚をつける） 
    12 0C 44 2C （未定義） 
    13 0D 45 2D （未定義） 
    14 0E 46 2E （未定義） 
    15 0F 47 2F （未定義） 
    16 10 48 30 汎用操作子1 
    17 11 49 31 汎用操作子2 
    18 12 50 32 汎用操作子3 
    19 13 51 33 汎用操作子4 

    ７ビット連続可変
    No. Hex 機能 
    64 40 ホールド１（ダンパメダル） 
    65 41 ポルタメント 
    66 42 ソステヌート（コードホールド） 
    67 43 ソフトペダル 
    68 44 （未定義） 
    69 45 ホールド２（フリーズ） 
    70 46 メモリバッチセレクト 
    71-79 47-4F （未定義） 
    80 50 汎用操作子５ 
    81 51 汎用操作子６ 
    82 52 汎用操作子７ 
    83 53 汎用操作子８ 
    84-90 54-5A （未定義） 
    91 5B 汎用エフェクト１（リバーブ） 
    92 5C 汎用エフェクト２（トレモロ） 
    93 5D 汎用エフェクト３（コーラス） 
    94 5E 汎用エフェクト４（セレステ） 
    95 5F 汎用エフェクト５（フェイザ） 



    RPN-NRPN
    No. Hex 機能 
    96 60 データインクリメント 
    97 61 データデクリメント 
    LSB MSB 
    No. Hex No. Hex 機能 
    98 62 99 63 NRPN 
    100 64 101 65 RPN 

    */
    struct コントロールID 
    {
      enum {
      バンクセレクト = 0x0,
      モジュレーションデプス = 0x1,
      ブレスコントロール =0x2,
      フットコントロール = 0x4,
      ポルタメントタイム =0x5,
      データエントリー = 0x6,
      メインボリューム = 0x7,
      バランスコントロール = 0x8,
      パンポット = 0xa,
      エクスプレッション = 0xb,
      ホールド = 0x40,
      ポルタメント = 0x41,
      コードホールド = 0x42,
      ソフトペダル = 0x43,
      ホールド２ = 0x45,
      メモリーバッチセレクト = 0x46,
      リバーブ = 0x5b,
      トレモロ = 0x5c,
      コーラス = 0x5d,
      セレステ = 0x5e,
      フェーザー = 0x5f,
      オールサウンドオフ = 0x78,
      リセットオールコントローラー = 0x79,
      ローカルコントロール = 0x7a,
      オールノートオフ = 0x7b,
      オムニオフ =0x7c,
      オムニオン = 0x7d,
      モノモードオン = 0x7e,
      ポリモードオン = 0x7f
      };
    };

      template <boost::uint16_t Tag>
      struct tag 
      {
        static const boost::uint16_t type = Tag;
      };

      /** ノート・オン */
      struct ノートオン
      {
          boost::uint8_t ノート;
          boost::uint8_t ベロシティ;
          static const boost::uint16_t ID = ID::ノートオン;
      };

      /** ノート・オフ */
      struct ノートオフ
      {
          boost::uint8_t ノート;
          boost::uint8_t ベロシティ;
          static const boost::uint16_t ID = ID::ノートオフ;
      };

      /** コントロールチェンジ */
      struct コントロールチェンジ
      {
          boost::uint8_t 番号;
          boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
      };

      /** バンクセレクト(音色バンクの切り替え) */
      struct バンクセレクト 
      {
          boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
      };

      /** モジュレーションデプス  */
      struct モジュレーションデプス
      {
          boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
      };

      /** ブレスコントロール  */
      struct ブレスコントロール
      {
          boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
      };

      /** フットコントロール  */
      struct フットコントロール
      {
          boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
      };

      /** ポルタメントタイム */
      struct ポルタメントタイム
      {
         boost::int16_t 値;
         static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

     /** データエントリ */
      struct データエントリ
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** メインボリューム */
      struct メインボリューム
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** バランスコントロール */
      struct バランスコントロール
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** パンポット */
      struct パンポット
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** エクスプレッション */
      struct エクスプレッション
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用操作子１ */
      struct 汎用操作子１
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用操作子２*/
      struct 汎用操作子２
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用操作子３ */
      struct 汎用操作子３
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用操作子４ */
      struct 汎用操作子４
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };


      /** ホールド１ */
      struct ホールド１
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** ポルタメント */
      struct ポルタメント
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** ソステヌート（コードホールド） */
      struct ソステヌート
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** ソフトペダル */
      struct ソフトペダル
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** ホールド２（フリーズ） */
      struct ホールド２
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** メモリバッチセレクト */
      struct メモリバッチセレクト
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用操作子５ */
      struct 汎用操作子５
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用操作子６ */
      struct 汎用操作子６
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用操作子７ */
      struct 汎用操作子７
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用操作子８ */
      struct 汎用操作子８
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用エフェクト１（リバーブ） */
      struct 汎用エフェクト１
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用エフェクト２（トレモロ） */
      struct 汎用エフェクト２
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用エフェクト3      （コーラス） */
      struct 汎用エフェクト３
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用エフェクト４（セレステ） */
      struct 汎用エフェクト４
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** 汎用エフェクト５（フェーザ） */
      struct 汎用エフェクト５
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** データインクリメント */
      struct データインクリメント
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** データデクリメント */
      struct データデクリメント
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** データデクリメント */
      struct NRPN
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** データデクリメント */
      struct RPN
      {
         boost::int16_t 値;
          static const boost::uint16_t ID = ID::コントロールチェンジ;
       };

      /** ピッチベンド */
      struct ピッチベンド
      {
          boost::int16_t 値;
          static const boost::uint16_t ID = ID::ピッチベンド;
      };

      /** ポリフォニックキープレッシャ */
      struct ポリフォニックキープレッシャ
      {
          boost::uint8_t ノート;
          boost::uint8_t 値;
          static const boost::uint16_t ID = ID::ポリフォニックキープレッシャ;
      };

      /** チャンネルプレッシャー */
      struct チャンネルプレッシャ
      {
          boost::uint8_t 値;
          static const boost::uint16_t ID = ID::チャンネルプレッシャ;
      };

      /** プログラムチェンジ */
      struct プログラムチェンジ
      {
          boost::uint8_t 値;
          static const boost::uint16_t ID = ID::プログラムチェンジ;

      };

      /** システムエクスクルーシブ */
      struct システムエクスクルーシブ
      {
          boost::uint16_t マニファクチャラーズID;
          std::vector<boost::uint8_t> データ;
          static const boost::uint16_t ID = ID::システムエクスクルーシブ;
      };

      /** エンドオブエクスクルーシブ */
      struct エンドオブエクスクルーシブ
      {
          static const boost::uint16_t ID = ID::エンドオブエクスクルーシブ;
      };

      template <typename T_MIDI出力, typename T_MIDIメッセージ>
      inline void midi出力送信(T_MIDI出力& MIDI出力,T_MIDIメッセージ& MIDIメッセージ)
      {
          DWORD 出力メッセージ = MIDIメッセージ.値 << 8 + MIDIメッセージ.ID;
          ::midiOutShortMsg(T_MIDI出力.ハンドル(),出力メッセージ);
      };

      /** ノートオンメッセージの出力 */
      inline void midi出力送信(midi出力& 出力,ノートオン& データ)
      {
        ::midiOutShortMsg(出力.ハンドル(),(データ.ID) | (データ.ノート << 8) | (データ.ベロシティ << 16));
      };
      

    }
}