﻿/** @file
*  @brief MIDI Output 実装クラス
*/
#include "stdafx.h"
#include "midi_output.h"

namespace sf {
  
  midi出力::デバイス情報コンテナ型 midi出力::デバイス情報コンテナ_;

  const std::wstring midi出力エラー::get_error_string(boost::uint32_t id)
  {
    wchar_t buf[MAXCHAR] = {};

    ::midiOutGetErrorTextW(id,buf,MAXCHAR);
    return std::wstring(buf);
  }



  void midi出力::デバイスの列挙()
  {
    const boost::uint32_t num_devs_ = midiOutGetNumDevs();
    if(num_devs_ > 0)
    {
      デバイス情報コンテナ_.clear();
      for( boost::uint32_t dev_id_ = 0;dev_id_ < num_devs_;++dev_id_)
      {
        MIDIOUTCAPS2 デバイス情報2_;
        boost::uint32_t 結果 = midiOutGetDevCaps(dev_id_,reinterpret_cast<LPMIDIOUTCAPS>(&デバイス情報2_),sizeof(MIDIOUTCAPS2));
        if(結果 != MMSYSERR_NOERROR)
        {
           throw midi出力エラー(結果);
        } else {
          midi出力::デバイス情報コンテナ_
            .push_back(new midi出力::デバイス情報(デバイス情報2_,dev_id_));
        }
      }
    }

  }
  midi出力::midi出力(boost::uint32_t id) 
    : dev_id_(id),hmidiout_(NULL)
  {
    オープン();
  }

  midi出力::~midi出力()
  {
    クローズ();
  }
 }
