﻿#pragma once
/*
*/
// Windows Header Files:
#include "exception.h"
#include "base_window.h"
#include "dpi.h"
#define XBYAK64
#include "xbyak.h"
#include "windows.h"
#include "windowsx.h"
#include "CommCtrl.h"
#include <type_traits>
#include "timer.h"
//#include <boost/type_traits/is_same.hpp>
// DLLのリンク
#pragma comment(lib,"d2d1.lib")
#pragma comment(lib,"winmm.lib")
#pragma comment(lib,"dwrite.lib")
#pragma comment(lib,"dwmapi.lib")

//#include "input.h"

// Direct Write

_COM_SMARTPTR_TYPEDEF(IDWriteFactory , __uuidof(IDWriteFactory));
_COM_SMARTPTR_TYPEDEF(IDWriteGdiInterop , __uuidof(IDWriteGdiInterop));
_COM_SMARTPTR_TYPEDEF(IDWriteFontFace , __uuidof(IDWriteFontFace));
_COM_SMARTPTR_TYPEDEF(IDWriteFont , __uuidof(IDWriteFont));
_COM_SMARTPTR_TYPEDEF(IDWriteFontFamily , __uuidof(IDWriteFontFamily));
_COM_SMARTPTR_TYPEDEF(IDWriteFontCollection , __uuidof(IDWriteFontCollection));
_COM_SMARTPTR_TYPEDEF(IDWriteLocalizedStrings , __uuidof(IDWriteLocalizedStrings));
_COM_SMARTPTR_TYPEDEF(IDWriteTextFormat, __uuidof(IDWriteTextFormat));
_COM_SMARTPTR_TYPEDEF(IDWriteTextLayout, __uuidof(IDWriteTextLayout));
_COM_SMARTPTR_TYPEDEF(IDWriteFontFile,__uuidof(IDWriteTextLayout));
//_COM_SMARTPTR_TYPEDEF(IDWriteFontFile,__uuidof(IDWriteTextLayout));

// Direct2D

_COM_SMARTPTR_TYPEDEF(ID2D1Factory,__uuidof(ID2D1Factory));
_COM_SMARTPTR_TYPEDEF(ID2D1HwndRenderTarget , __uuidof(ID2D1HwndRenderTarget));
_COM_SMARTPTR_TYPEDEF(ID2D1BitmapRenderTarget , __uuidof(ID2D1BitmapRenderTarget));
_COM_SMARTPTR_TYPEDEF(ID2D1GdiInteropRenderTarget , __uuidof(ID2D1GdiInteropRenderTarget));
_COM_SMARTPTR_TYPEDEF(ID2D1DCRenderTarget , __uuidof(ID2D1DCRenderTarget));
_COM_SMARTPTR_TYPEDEF(ID2D1PathGeometry , __uuidof(ID2D1PathGeometry));
_COM_SMARTPTR_TYPEDEF(ID2D1LinearGradientBrush , __uuidof(ID2D1LinearGradientBrush));
_COM_SMARTPTR_TYPEDEF(ID2D1GradientStopCollection , __uuidof(ID2D1GradientStopCollection));
_COM_SMARTPTR_TYPEDEF(ID2D1SolidColorBrush , __uuidof(ID2D1SolidColorBrush));
_COM_SMARTPTR_TYPEDEF(ID2D1BitmapBrush , __uuidof(ID2D1BitmapBrush));
_COM_SMARTPTR_TYPEDEF(ID2D1Bitmap , __uuidof(ID2D1Bitmap));

// WIC

_COM_SMARTPTR_TYPEDEF(IWICImagingFactory, __uuidof(IWICImagingFactory));
_COM_SMARTPTR_TYPEDEF(IWICBitmapDecoder,__uuidof(IWICBitmapDecoder));
_COM_SMARTPTR_TYPEDEF(IWICBitmapFrameDecode,__uuidof(IWICBitmapFrameDecode));
_COM_SMARTPTR_TYPEDEF(IWICStream,__uuidof(IWICStream));
_COM_SMARTPTR_TYPEDEF(IWICFormatConverter,__uuidof(IWICFormatConverter));
_COM_SMARTPTR_TYPEDEF(IWICBitmapScaler,__uuidof(IWICBitmapScaler));
_COM_SMARTPTR_TYPEDEF(ITaskbarList3,__uuidof(ITaskbarList3));

// DXGI 

_COM_SMARTPTR_TYPEDEF(IDXGISwapChain,__uuidof(IDXGISwapChain));
_COM_SMARTPTR_TYPEDEF(IDXGIFactory1,__uuidof(IDXGIFactory1));
_COM_SMARTPTR_TYPEDEF(IDXGIAdapter1,__uuidof(IDXGIAdapter1));
_COM_SMARTPTR_TYPEDEF(IDXGIDevice1,__uuidof(IDXGIDevice1));
_COM_SMARTPTR_TYPEDEF(IDXGIKeyedMutex,__uuidof(IDXGIKeyedMutex));
_COM_SMARTPTR_TYPEDEF(IDXGIObject,__uuidof(IDXGIObject));
_COM_SMARTPTR_TYPEDEF(IDXGIDeviceSubObject,__uuidof(IDXGIDeviceSubObject));
_COM_SMARTPTR_TYPEDEF(IDXGISurface1,__uuidof(IDXGISurface1));
_COM_SMARTPTR_TYPEDEF(IDXGIOutput,__uuidof(IDXGIOutput));
//_COM_SMARTPTR_TYPEDEF(IDXGI,__uuidof(IDXGI));
//_COM_SMARTPTR_TYPEDEF(IDXGI,__uuidof(IDXGI));

// Direct3D

_COM_SMARTPTR_TYPEDEF(ID3D11Device,__uuidof(ID3D11Device));
_COM_SMARTPTR_TYPEDEF(ID3D11DeviceContext,__uuidof(ID3D11DeviceContext));
_COM_SMARTPTR_TYPEDEF(ID3D11RenderTargetView,__uuidof(ID3D11RenderTargetView));
_COM_SMARTPTR_TYPEDEF(ID3D11DepthStencilView,__uuidof(ID3D11DepthStencilView));
_COM_SMARTPTR_TYPEDEF(ID3D11VertexShader,__uuidof(ID3D11VertexShader));
_COM_SMARTPTR_TYPEDEF(ID3D11PixelShader,__uuidof(ID3D11PixelShader));
_COM_SMARTPTR_TYPEDEF(ID3D11InputLayout,__uuidof(ID3D11InputLayout));
_COM_SMARTPTR_TYPEDEF(ID3D11Buffer,__uuidof(ID3D11Buffer));
_COM_SMARTPTR_TYPEDEF(ID3D11Texture2D,__uuidof(ID3D11Texture2D));
_COM_SMARTPTR_TYPEDEF(ID3DBlob,__uuidof(ID3DBlob));
_COM_SMARTPTR_TYPEDEF(ID3D11ShaderResourceView,__uuidof(ID3D11ShaderResourceView));
_COM_SMARTPTR_TYPEDEF(ID3D11SamplerState,__uuidof(ID3D11SamplerState));



namespace sf{

  /* inline template <class Exc = win32_error_exception> void throw_if_err<>()(HRESULT hr)
  {
  if(hr != S_OK){throw Exc(hr);}
  };*/


  ID2D1BitmapPtr load_bitmap_from_file(
    ID2D1HwndRenderTargetPtr render_target,
    IWICImagingFactoryPtr wic_factory,
    std::wstring uri,
    uint32_t destination_width = 0,
    uint32_t destination_height = 0
    );

  /** WNDCLASSEXラッパクラス */
  struct window_class_ex
  {
    window_class_ex(
      const wchar_t*  menu_name ,
      const std::wstring&  class_name ,
      HINSTANCE   hInstance = NULL,
      WNDPROC     lpfnWndProc = ::DefWindowProcW,
      uint32_t        style = CS_HREDRAW | CS_VREDRAW,
      int32_t     cbClsExtra  = 0,
      int32_t     cbWndExtra = sizeof(LONG_PTR), 
      HICON       hIcon = ::LoadIcon(NULL,IDI_APPLICATION),
      HCURSOR     hCursor = ::LoadCursor(NULL, IDC_ARROW),
      HBRUSH      hbrBackground = ::CreateSolidBrush(0xff000000),
      HICON       hIconSm = NULL
      ) : is_register_(false)
    {

      if(::GetClassInfoExW(hInstance,class_name.c_str(),&wndclass_) == 0)
      {
        if(::GetLastError() == ERROR_CLASS_DOES_NOT_EXIST)
        { 
          ::ZeroMemory(&wndclass_,sizeof(wndclass_));
          wndclass_.lpszMenuName = (LPCWSTR)menu_name;
          wndclass_.lpszClassName = class_name.c_str();
          wndclass_.cbSize = sizeof(::WNDCLASSEXW);
          wndclass_.cbWndExtra = cbWndExtra;
          wndclass_.hInstance = hInstance;
          wndclass_.lpfnWndProc = lpfnWndProc;
          wndclass_.style = style;
          wndclass_.cbClsExtra = cbClsExtra;
          wndclass_.hIcon = hIcon;
          wndclass_.hCursor = hCursor;
          wndclass_.hbrBackground = hbrBackground;
          wndclass_.hIconSm = hIconSm;
          atom_ = ::RegisterClassExW(&wndclass_) ;
          BOOST_ASSERT(atom_ != 0);
          is_register_ = true;
        } else {
          throw win32_error_exception();
        }
      } else {
        is_register_ = false;
      }
    };

    ~window_class_ex()
    {
      if(is_register_){
        ::UnregisterClassW(wndclass_.lpszClassName,wndclass_.hInstance);
      }
    }

  private:
    bool is_register_;
    ATOM atom_;
    ::WNDCLASSEXW wndclass_;
  };

  struct get_dc {
    get_dc(HWND hwnd) : hwnd_(hwnd),hdc_(GetDC(hwnd)) {}
    HDC get(){return hdc_;}
    ~get_dc(){::ReleaseDC(hwnd_,hdc_);}
  private:
    HDC hdc_;
    HWND hwnd_;
  };

  struct get_window_dc {
    get_window_dc(HWND hwnd) : hwnd_(hwnd),hdc_(GetWindowDC(hwnd)) {}
    HDC get(){return hdc_;}
    ~get_window_dc(){::ReleaseDC(hwnd_,hdc_);}
  private:
    HDC hdc_;
    HWND hwnd_;
  };

  struct compatible_dc {
    compatible_dc(HDC hdc) : hdc_(::CreateCompatibleDC(hdc)){}; 
    ~compatible_dc(){::DeleteDC(hdc_);};
    HDC get() { return hdc_;};
  private:
    HDC hdc_;
  };

  struct ref_dc {
    ref_dc(HDC& hdc) : hdc_(hdc) {};
    ~ref_dc(){};
    HDC get() { return hdc_;};
  private:
    HDC& hdc_;
  };

  struct d2_dc {
    d2_dc(ID2D1GdiInteropRenderTargetPtr& ptr,D2D1_DC_INITIALIZE_MODE mode) :hdc_(0),ptr_(ptr)
    {
      hr_ = ptr->GetDC(mode,&hdc_);
    };
    ~d2_dc(){ptr_->ReleaseDC(NULL);};
    HDC get() { return hdc_;};
  private:
    HRESULT hr_;
    HDC hdc_;
    ID2D1GdiInteropRenderTargetPtr& ptr_;
  };

  template <typename Holder>
  struct device_context
  {
    explicit device_context(Holder* holder) : holder_(holder){};
    ~device_context() {}
    operator HDC(){return holder_->get();}
  private:
    std::unique_ptr<Holder> holder_;
  };

  //struct handle_holder : boost::noncopyable
  //{
  //  explicit handle_holder(HANDLE handle) : handle_(handle) {};
  //  ~handle_holder(){if(handle_) ::CloseHandle(handle_);}
  //  operator HANDLE(){return handle_;}
  //private:
  //  HANDLE handle_;
  //};


  struct HBITMAP_deleter {
    typedef HBITMAP pointer;
    void operator ()(HBITMAP handle) {
      if (handle) {
        ::DeleteObject(handle);
      }
    }
  };

  //template <typename Handle,typename Handle_Deleter>
  //struct handle_holder {
  //  typedef boost::unique_ptr<Handle,Handle_Deleter> holder_type;
  //  handle_holder(Handle handle) : holder_(handle) {}
  //  operator Handle(){return holder_->get();}
  //private:
  //  holder_type holder_;
  //};

  typedef std::unique_ptr<HBITMAP,HBITMAP_deleter> bitmap_holder;

  typedef device_context<d2_dc> d2_dc_type;

  struct paint_struct 
  {
    paint_struct(HWND hwnd) : hwnd_(hwnd)
    {
      ::BeginPaint(hwnd,&paintstruct_);
    }
    ~paint_struct() {::EndPaint(hwnd_,&paintstruct_);}
    PAINTSTRUCT* operator->(){return &paintstruct_;}
  private:
    HWND hwnd_;
    PAINTSTRUCT paintstruct_;
  };

  // GDI オブジェクト管理テンプレート
  template <class GdiObject> 
  struct gdi_object: boost::noncopyable
  {
    explicit gdi_object(GdiObject obj) : gdiobj_(obj) {}
    ~gdi_object(){::DeleteObject(gdiobj_);}
    operator GdiObject(){return gdiobj_;}
  private:
    GdiObject gdiobj_;
  };

  //
  struct select_object 
  {
    select_object(HDC dc,HGDIOBJ o) : dc_(dc),o_(::SelectObject(dc,o)) {}
    ~select_object(){::SelectObject(dc_,o_);}
  private:
    HDC dc_;
    HGDIOBJ o_;
  };

  // Direct2D BeginDrawヘルパ関数
  template <typename T >
  struct begin_draw
  {
    typedef std::function<void(HRESULT hr)> err_handler_type;

    begin_draw(T& render_target,err_handler_type& handler)
      : render_target_(render_target) ,
      is_end_(false),handler_(handler)
    {render_target->BeginDraw();}

    ~begin_draw(){ 
      HRESULT hr = S_OK;
      hr = render_target_->EndDraw();
      if( hr != S_OK)
      {
        handler_(hr);
      }
    }
  private:
    T& render_target_;
    err_handler_type handler_;
  };

  struct mouse
  {
    mouse() : x_(0.0f),y_(0.0f),left_button_(false),middle_button_(false),right_button_(false){}
  private:
    float x_,y_;
    bool left_button_,middle_button_,right_button_;
  };


  // ウィンドウプロシージャの識別用クラス
  struct wndproc 
  {
    typedef WNDPROC proc_type;
    typedef LRESULT return_type;
    static inline return_type def_wnd_proc(HWND hwnd,uint32_t message, WPARAM wParam, LPARAM lParam) 
    {
      return ::DefWindowProcW(hwnd,message,wParam,lParam);
    }
  };

  // ダイアログプロシージャの識別用クラス
  struct dlgproc
  {
    typedef DLGPROC proc_type;
    typedef INT_PTR return_type;
    static inline return_type def_wnd_proc(HWND hwnd,uint32_t message, WPARAM wParam, LPARAM lParam)
    {
      return FALSE;
    }
  };

  /** window ベースクラス */
  template <typename ProcType = wndproc>
  struct base_win32_window : public base_window 
  {
    typedef ProcType proc_t;
    typedef typename proc_t::return_type result_t;

    operator HWND() const {return hwnd_;};

    virtual void * raw_handle() const {return hwnd_;};
    //    virtual void show(uint32_t show_flag);

    virtual void show() {
      ::ShowWindow(hwnd_,SW_SHOW);
      ::GetWindowPlacement(hwnd_,&wp_);
    }

    // Window を画面から隠す
    virtual bool is_show() {
      return ( wp_.showCmd == SW_SHOWMAXIMIZED 
        || wp_.showCmd == SW_SHOWMINIMIZED
        || wp_.showCmd == SW_SHOWNORMAL );
    };

    //
    virtual void hide()
    {
      ::ShowWindow(hwnd_,SW_HIDE);
      ::GetWindowPlacement(hwnd_,&wp_);
    };

    virtual void text(std::wstring& text)
    {
      ::SetWindowTextW(*this,text.c_str());
    };

    virtual void send_message(uint32_t message,uint32_t wparam,uint32_t lparam )
    {
      ::SendNotifyMessage(hwnd_,message,wparam,lparam);
    }

    virtual void post_message(uint32_t message,uint32_t wparam,uint32_t lparam )
    {
      ::PostMessage(hwnd_,message,wparam,lparam);
    }

    virtual void message_box(const std::wstring& text,const std::wstring& caption,uint32_t type = MB_OK)
    {
      ::MessageBox(hwnd_,text.c_str(),caption.c_str(),type);
    }

    virtual void update();

    virtual void create_device_independent_resources();
    virtual void create_device();
    virtual void create_swapchain_dependent_resources();

    virtual void discard_swapchain_dependent_resources();
    virtual void discard_device();
    virtual void discard_device_independant_resources();

  protected:

    base_win32_window(
      const std::wstring& title,
      const std::wstring& name,bool fit_to_display,
      float width,float height);


    ~base_win32_window();

    void register_class (
      const wchar_t* menu_name,
      uint32_t style, 
      int32_t     cbClsExtra  = 0,
      int32_t     cbWndExtra  = sizeof(LONG_PTR),
      HICON       hIcon = ::LoadIcon(NULL,IDI_APPLICATION),
      HCURSOR     hCursor = ::LoadCursor(NULL, IDC_ARROW),
      HBRUSH      hbrBackground = ::CreateSolidBrush(0xff000000),
      HICON       hIconSm = NULL
      );		

    /** デフォルト設定 */
    void register_class();
    void create_window(HWND parent = NULL);

    void calc_client_size()
    {
      //クライアント領域の現在の幅、高さを求める
      RECT rc;
      GetClientRect( hwnd_, &rc );
      client_width_ = rc.right - rc.left;
      client_height_ = rc.bottom - rc.top;
    }
  public:
    // SetWindowLong API
    void set_long(int index,long data)
    {
      SetLastError(0);
      if(::SetWindowLongW(hwnd_,index,data) == 0)
      {
        long err = 0;
        if( (err = GetLastError()) != 0){
          SetLastError(err);
          throw sf::win32_error_exception();
        }
      };
    }

    void set_pos(
      HWND hwnd_insert_after,  // 配置順序のハンドル
      int x,                 // 横方向の位置
      int y,                 // 縦方向の位置
      int cx,                // 幅
      int cy,                // 高さ
      UINT flags            // ウィンドウ位置のオプション
      )
    {
      BOOL res = SetWindowPos(hwnd_,hwnd_insert_after,x,y,cx,cy,flags);
      if(!res)
      {
        throw win32_error_exception();
      }
    }

    bool invalidate_rect(bool erase = false,const RECT * rect_ptr = 0)
    {
      return ::InvalidateRect(*this,rect_ptr,erase) == TRUE;
    }

    void enable_control(uint32_t id,bool enable)
    {
      ::EnableWindow(GetDlgItem(hwnd_,id),enable?TRUE:FALSE);
    }

    void enable_control(HWND hwnd,uint32_t id,bool enable)
    {
      ::EnableWindow(GetDlgItem(hwnd,id),enable?TRUE:FALSE);
    };

    virtual result_t window_proc(HWND hwnd,uint32_t message, WPARAM wParam, LPARAM lParam);
    virtual result_t other_window_proc(HWND hwnd,uint32_t message, WPARAM wParam, LPARAM lParam)
    {
      return proc_t::def_wnd_proc(hwnd,message,wParam,lParam);
    };

    // デフォルトウィンドウメッセージハンドラ
    virtual result_t on_nccreate(CREATESTRUCT *p) ;//{ return std::is_same<proc_t,wndproc>::value?1:FALSE;}
    virtual result_t on_create(CREATESTRUCT *p); //{ return std::is_same<proc_t,wndproc>::value?0:FALSE;}
    virtual result_t on_init_dialog(HWND default_focus_ctrl,LPARAM data) {return TRUE;}
    virtual result_t on_size(uint32_t flag,uint32_t width,uint32_t height);//{return std::is_same<proc_t,wndproc>::value?0:FALSE;    }
    //virtual LRESULT 
    virtual result_t on_paint();
    virtual result_t on_display_change(uint32_t bpp,uint32_t h_resolution,uint32_t v_resolution) {         invalidate_rect();return std::is_same<proc_t,wndproc>::value?0:FALSE;}
    virtual result_t on_erase_backgroud(HDC dc) {return std::is_same<proc_t,wndproc>::value?1:TRUE;}
    virtual result_t on_hscroll(uint32_t state,uint32_t position,HWND ctrl_hwnd) {return std::is_same<proc_t,wndproc>::value?0:FALSE;}
    virtual result_t on_vscroll(uint32_t state,uint32_t position,HWND ctrl_hwnd) {return std::is_same<proc_t,wndproc>::value?0:FALSE;}
    virtual result_t on_left_mouse_button_down(uint32_t mouse_key,int x,int y ) { return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_left_mouse_button_up(uint32_t mouse_key,int x,int y) { return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_left_mouse_button_double_click(uint32_t mouse_key,int x,int y) { return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_mouse_move(uint32_t mouse_key,int x,int y) {return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_mouse_wheel(uint32_t mouse_key,int delta,int x,int y) {  return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    //virtual bool on_mouse_enter(uint32_t mouse_key,int x,int y) {  return false; }
    virtual result_t on_mouse_leave() {  return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_destroy(){   
      //::PostQuitMessage(0);
      return std::is_same<proc_t,wndproc>::value?0:FALSE;
    }

    virtual result_t on_close()
    {
      discard_device();
      // Windowの破棄
      BOOL ret(::DestroyWindow(hwnd_));
      BOOST_ASSERT(ret != 0);
//      return TRUE;
      return std::is_same<proc_t,wndproc>::value?1:TRUE;
    }

    virtual result_t on_set_cursor() { return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_key_down(uint32_t vkey,uint32_t ext_key,uint32_t repeat) { return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_key_up(uint32_t vkey,uint32_t ext_key,uint32_t repeat) { return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_app_command(uint32_t command,uint32_t device,uint32_t keystate) {return std::is_same<proc_t,wndproc>::value?0:FALSE;}
    virtual result_t on_command(uint32_t wparam, uint32_t lparam)  { return std::is_same<proc_t,wndproc>::value?0:FALSE; } 
    virtual result_t on_timer(uint32_t timer_id)  {
      //::InvalidateRect(hwnd_,NULL,FALSE);
      render();
      return std::is_same<proc_t,wndproc>::value?0:FALSE; 
    } 
    virtual result_t on_notify(NMHDR* nmhdr)  { return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_dwm_composition_changed();
    virtual void render();
  protected:
    void get_dxgi_information();

    // Window生成後呼ばれる関数
    // WM_NCCREATEメッセージの時にthunkに切り替える
    static result_t CALLBACK start_wnd_proc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
      if(message == WM_NCCREATE)
      {
        LPCREATESTRUCT param = reinterpret_cast<LPCREATESTRUCT>(lParam);
        base_win32_window* ptr = reinterpret_cast<base_win32_window*>(param->lpCreateParams);
        ptr->hwnd_ = hwnd;
        // ウィンドウプロシージャをインスタンスと結び付けるthunkプロシージャに入れ替える
        LONG_PTR r = SetWindowLongPtr(hwnd,GWLP_WNDPROC,reinterpret_cast<LONG_PTR>(ptr->thunk_proc_));
        assert(r == reinterpret_cast<LONG_PTR>(&start_wnd_proc));
        return ptr->window_proc(hwnd,message,wParam,lParam);
      }
      return ::DefWindowProcW(hwnd,message,wParam,lParam);
    };

    static result_t CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
      base_win32_window* ptr = reinterpret_cast<base_win32_window*>(hwnd);
      return ptr->window_proc(ptr->hwnd_,message,wParam,lParam);
    };

    // thisとhwndをつなぐthunkクラス
    struct hwnd_this_thunk : public Xbyak::CodeGenerator {
      hwnd_this_thunk(base_win32_window* impl,typename proc_t::proc_type proc)
      {
        // rcxにhwndが格納されているので、それをimpl->hwndに保存
        mov(qword[&(impl->hwnd_)],rcx);
        // 代わりにthisのアドレスをrcxに格納
        mov(rcx,(LONG_PTR)impl);
        // r10にproc(Window プロシージャ)へのアドレスを格納
        mov(r10,(LONG_PTR)proc);
        // Window プロシージャへへジャンプ
        jmp(r10);
      }
    };

    void update_window_size()
    {
      RECT r;
      GetWindowRect(hwnd_,&r);
      width_ = r.right - r.left;
      height_ = r.bottom - r.top;
    }

    HWND hwnd_;
    hwnd_this_thunk thunk_;
    std::wstring title_;
    std::wstring name_;
    float width_,height_;
    bool fit_to_display_;
    std::shared_ptr<sf::window_class_ex> wnd_class_;
    typename proc_t::proc_type thunk_proc_;
    dpi dpi_;
    WINDOWPLACEMENT wp_;
    bool init_;

    //ID2D1FactoryPtr factory_;
    //ID2D1HwndRenderTargetPtr render_target_;
    //IDWriteFactoryPtr write_factory_;
    //IWICImagingFactoryPtr wic_imaging_factory_;
    //IDWriteTextFormatPtr write_text_format_;

    IDXGIFactory1Ptr dxgi_factory_;
    IDXGIAdapter1Ptr adapter_;
    IDXGIOutputPtr output_;
    ID3D11DevicePtr d3d_device_;
    ID3D11DeviceContextPtr d3d_context_;
    ID3D11Texture2DPtr texture_;
    ID3D11RenderTargetViewPtr view_;
    ID3D11Texture2DPtr depth_texture_;
    ID3D11DepthStencilViewPtr depth_view_;
    ID3D11VertexShaderPtr v_shader_;
    ID3D11InputLayoutPtr input_layout_;
    ID3D11PixelShaderPtr p_shader_;
    ID3D11BufferPtr v_buffer_;
    ID3D11BufferPtr i_buffer_;
    ID3D11BufferPtr cb_never_changes_;
    ID3D11BufferPtr cb_change_on_resize_;
    ID3D11BufferPtr cb_changes_every_frame_;
    ID3D11ShaderResourceViewPtr shader_res_view_;
    ID3D11SamplerStatePtr sampler_state_;
    ID3D11Texture2DPtr back_buffer_;
    
    ID3D11SamplerStatePtr cube_sampler_state_;
    ID3D11Texture2DPtr cube_texture_;
    ID3D11Texture2DPtr cube_depth_texture_;
    ID3D11ShaderResourceViewPtr cube_shader_res_view_;
    ID3D11RenderTargetViewPtr cube_view_;
    ID3D11DepthStencilViewPtr cube_depth_view_;

    DXGI_MODE_DESC actual_desc_;
    //IDXGISwapChainPtr swap_chain_;
    std::wstring dxgi_info_;

    XMMATRIX                            mat_world_;
    XMMATRIX                            mat_view_;
    XMMATRIX                            mat_projection_;
    XMMATRIX                            cube_mat_projection_;
    XMFLOAT4                            mesh_color_;
    float client_width_,client_height_;

    timer timer_;

    // __declspec ( thread ) static std::queue<proc_t::proc_type> ptrs_ ;// thread local storage

  };

  typedef base_win32_window<> base_win32_window_t;
  typedef base_win32_window<DLGPROC> base_win32_dialog_t;

  /// サブクラスウィンドウ
  struct subclass_window : public base_win32_window_t
  {
    subclass_window(HWND hwnd);
    subclass_window();
    void attach(HWND hwnd);
    void detatch();
    ~subclass_window();
    virtual result_t window_proc(HWND hwnd,uint32_t message, WPARAM wParam, LPARAM lParam) 
    {
      return CallWindowProc(proc_backup_,hwnd,message,wParam,lParam);
    };
  protected:
    bool is_subclassed_;
    WNDPROC proc_backup_;
  };

  struct av_mm_thread_characteristics
  {
    av_mm_thread_characteristics(std::wstring& str) : task_name_(str)
    {
      handle_ = ::AvSetMmThreadCharacteristicsW(str.c_str(),(LPDWORD)&task_index_);
    }

    bool set_priority(AVRT_PRIORITY p){return (::AvSetMmThreadPriority(handle_,p) == TRUE);}

    ~av_mm_thread_characteristics()
    {
      ::AvRevertMmThreadCharacteristics(handle_);
    }

  private:
    std::wstring task_name_;
    uint32_t task_index_;
    HANDLE handle_;
  };

  struct widget
  {
    void draw();
    float x_,y_;
  };

  typedef sf::begin_draw<ID2D1BitmapRenderTargetPtr> begin_draw_bitmap;
  typedef sf::begin_draw<ID2D1HwndRenderTargetPtr> begin_draw_hwnd;

}