{
SSTP Bottle Surface Preview Plug-In for "SVG"
(C)2003-2004 WinBottle Project / SSTP Bottle
}

library SVG;

{$R *.res}

uses
  Windows, Classes, SysUtils, Graphics, IniFiles, Dialogs, PngImage, jpeg;

const
  SurfaceWidth  = 48;
  SurfaceHeight = 64;
  ConfigFile = 'SVG.ini';

var
  MyPath: String;
  GhostFile: String;
  Ghost2File: THashedStringList;

  Pic: TPicture;       // ǂݎ摜(*.png, *.bmp, *.jpg)
  PicFileName: String; // ̃t@C

// DLL[hADLLďɌĂ΂B
// ǂݍ܂ꂽ摜́ABottle ClientŁuT[tBXēǂݍ݁v
// IɎw肳Ȃ Bottle Client ŃLbV̂ŁA
// DLLŉ摜̃LbVȂǂlKv͊{IɂȂB
// Ƃ͂T[tBX`t@CȂǂɉ͂ĂKvȂA
// œǂݍłƗǂBPathDLL̃pXnB
procedure Load(Path: PChar); cdecl;
var Ini: TIniFile;
begin
  MyPath := Path;
  Ini := TIniFile.Create(MyPath + ConfigFile);
  try
    GhostFile := Ini.ReadString('SVG', 'GhostFile', '');
  finally
    Ini.Free;
  end;
  if not FileExists(GhostFile) then
    ShowMessage('SVG.dll Warning: Ghost file is not specified');
  Ghost2File := THashedStringList.Create;
  Pic := TPicture.Create;
  PicFileName := '';
end;

// DLLA[hɌĂ΂B
procedure Unload; cdecl;
begin
  Ghost2File.Free;
  Pic.Free;
end;

// DLL̖Oуo[WԂB
// DLLNameɂDLL̖̂ҁADLL{̂̃o[WȂǂȌɎw肷B
// NameLenoCg𒴂Ă͂ȂȂB
// versionɂ͂Ƃ肠1ԂƁBversionSSTP Bottle ClientƂ
// ʐM̃C^[tF[X̃o[WłDLL̃o[WƂł͂ȂƂ
// (Bottle ClientDLL̃o[WԍȂȂ̂)B
// CanConfiguréAConfigureĂ΂Ă邱Ƃ邩ǂԂB
function GetVersion(DLLName: PChar; NameLen: integer;
  var Version: integer; var CanConfigure: boolean): integer; cdecl;
const ThisDLL = 'SVG Surface Loader Ver. 2.6';
begin
  Version := 1;
  CanConfigure := true;
  StrLCopy(DLLName, ThisDLL, NameLen);
  Result := Length(ThisDLL) + 1;
end;

function LoadDefinitionFileVer2(Ghost: String;
  Surface: integer; Lines: TStringList; const FileName: String;
  out Pos: integer): String;
var ALine, SurfaceMap: TStringList;
    i, j, p, sur, oldpos: integer;
    posstr: String;
begin
  // ֐BS[Xg`t@C͂āA
  // ړĨS[Xg̊܂܂ꂽt@Cǂf
  ALine := TStringList.Create;
  try
    ALine.CommaText := Lines[0];
    if (ALine[0] <> 'GHOST') then
      Exit;

    Ghost2File.Values[Ghost] := FileName; // ̃V[gJbg
    if (ALine[1] <> Ghost) then
    begin
      Exit;
    end;

    // ړĨS[Xg
    oldpos := 0;
    SurfaceMap := TStringList.Create;
    try
      for i := 1 to Lines.Count-1 do
      begin
        SurfaceMap.CommaText := Lines[i];
        for j := 0 to SurfaceMap.Count-1 do
        begin
          try
            p := System.Pos(':', SurfaceMap[j]);
            if p = 0 then
              Continue;
            sur := StrToInt(Copy(SurfaceMap[j], 1, p-1));
            posstr := Copy(SurfaceMap[j], p+1, High(integer));
            if posstr = '+' then
              Pos := oldpos + 1
            else
              Pos := StrToInt(posstr);
            if sur = Surface then
            begin
              Result := ALine[4]; // BMPt@C
              Exit;
            end else
              oldpos := Pos;
          except
            on EConvertError do; // nothing. PȂRgs
          end;
        end;
      end;
    finally
      SurfaceMap.Free;
    end;

    // BASIC̏ꍇ̏
    if AnsiCompareText('BASIC', ALine[3]) = 0 then
    begin
      if (Surface >= 0) and (Surface <= 11) then
      begin
        Result := ALine[4]; // BMPt@C
        Pos := Surface; // BASIC̏ꍇ͈ʒuƃT[tBXԍΈΉĂ
        Exit;
      end;
    end;

  finally
    ALine.Free;
  end;
end;

procedure ParseKeyVal(const Line: String; out Key, Val: String);
var p: integer;
begin
  // Key=Value`̕񂩂KeyValueo
  // Value""ň͂ł悢BKey͏ɂ̒iKœ
  p := Pos('=', Line);
  if p > 0 then
  begin
    Key := AnsiLowerCase(Copy(Line, 1, p-1));
    Val := AnsiDequotedStr(Copy(Line, p+1, High(integer)), '"');
  end else begin
    Key := '';
    Val := AnsiDequotedStr(Line, '"');
  end;
end;

procedure SplitBlocks(Lines, Blocks: TStringList);
var
  Str, Block: String;
  i: integer;
  Start: integer; // ݒڂĂubN̐擪̕CfbNX
  InLead: boolean; // DBCSLeadBytesĂ邩ǂێ
begin
  // SVG̊esubNɕϊ
  // RgOA/EOFȍ~K؂ɖ
  Str := Lines.Text;
  i := 0;
  Start := 1;
  InLead := false;
  while (i < Length(Str)) do
  begin
    Inc(i);
    if InLead then
    begin
      InLead := false;
      Continue;
    end else if Str[i] in LeadBytes then
    begin
      InLead := true;
      Continue;
    end else
    begin
      if Str[i] in [',', #13, #10] then
      begin
        if Start < i then
        begin
          // ؂o
          Block := Copy(Str, Start, i-Start);
          if Block = '/EOF' then
            Break
          else if Block[1] <> '/' then // Rg͖
            Blocks.Add(Block);
        end;
        Start := i+1;
      end;
    end;
  end;
end;

function LoadDefinitionFileVer3(Ghost: String;
  Surface: integer; Lines: TStringList; const FileName: String;
  out Pos: integer): String;
var i, k, smin, smax, oldsur: integer;
    Key, Val, SurStr, PosStr, SakuraName: String;
    Blocks, Sur2Pos: TStringList;
begin
  oldsur := -1;
  Sur2Pos := TStringList.Create;
  Blocks := TStringList.Create;
  try
    Lines.Delete(0);
    SplitBlocks(Lines, Blocks);
    for i := 0 to Blocks.Count-1 do
    begin
      ParseKeyVal(Blocks[i], Key, Val);
      if Key = 'sakura' then
      begin
        SakuraName := Val;
        Ghost2File.Values[SakuraName] := FileName; //̃V[gJbg
        if SakuraName <> Ghost then //ʃS[Xg̒`t@CȂ̂ŃpX
        begin
          Result := '';
          Exit;
        end;
      end else if Key = 'surfacefile' then
      begin
        Result := Val;
      end else if (Key = 'surface') or (Length(Key) = 0) then
      begin
        // T[tBX
        if System.Pos(':', Val) <= 0 then
          Continue;
        SurStr := Copy(Val, 1, System.Pos(':', Val)-1);
        PosStr := Copy(Val, System.Pos(':', Val)+1, High(integer));
        try
          if System.Pos('-', SurStr) > 0 then
          begin
            smin := StrToInt(Copy(SurStr, 1, System.Pos('-', SurStr)-1));
            smax := StrToInt(Copy(SurStr, System.Pos('-', SurStr)+1, High(integer)));
          end else
          begin
            smin := StrToInt(SurStr);
            smax := smin;
          end;
          for k := smin to smax do
          begin
            if PosStr = '*' then
            begin
              Sur2Pos.Values[IntToStr(k)] := IntToStr(k);
              oldsur := k;
            end else if PosStr = '-2' then
            begin
              Sur2Pos.Values[IntToStr(k)] := '' // `
            end else if PosStr = '+' then
            begin
              Inc(oldsur);
              Sur2Pos.Values[IntToStr(k)] := IntToStr(oldsur);
            end else if StrToInt(PosStr) >= 0 then
            begin
              Sur2Pos.Values[IntToStr(k)] := PosStr;
              oldsur := StrToInt(PosStr);
            end;
          end;
        except
          Continue;
        end;
      end;
    end;
    // ShowMessage(SakuraName + #13#10 + Sur2Pos.Text);
    if SakuraName <> Ghost then //sakura=??̎w肪Ă`t@C̏ꍇ
      Result := ''
    else
    begin
      if Sur2Pos.Values[IntToStr(Surface)] <> '' then
        Pos := StrToInt(Sur2Pos.Values[IntToStr(Surface)])
      else
        Result := '';
    end;
  finally
    Sur2Pos.Free;
    Blocks.Free;
  end;
end;

function LoadDefinitionFile(Ghost: String;
  Surface: integer; FileName: String; out Pos: integer): String;
var Lines: TStringList;
begin
  Lines := TStringList.Create;
  Lines.LoadFromFile(FileName);
  try
    if System.Pos('SVG3', Lines[0]) > 0 then
      Result := LoadDefinitionFileVer3(Ghost, Surface, Lines, FileName, Pos)
    else
      Result := LoadDefinitionFileVer2(Ghost, Surface, Lines, FileName, Pos);
  finally
    Lines.Free;
  end;
end;

function FetchBmpFileAndPosition(Ghost: String;
  Surface: integer; out Pos: integer): String;
var Ghosts, AGhost: TStringList;
    i, dum: integer;
    Dir, DefFileName, BmpFileName: String;
begin
  Result := '';
  if Ghost2File.Values[Ghost] <> '' then // łɂ̃S[XgɂĒς
  begin
    DefFileName := Ghost2File.Values[Ghost];
    if DefFileName = '*' then // ̃S[Xg͒mȂAƋLĂ
    begin
      Exit;
    end else // ̃S[XgmĂ
    begin
      BmpFileName := LoadDefinitionFile(Ghost, Surface,
        DefFileName, dum);
      if BmpFileName <> '' then
      begin
        Result := ExtractFilePath(DefFileName) + BmpFileName;
        Pos := dum;
        Exit;
      end;
    end;
  end;

  // S[XgȂʂLB
  // ꍇɂ̓t@Cŏ㏑
  if Result = '' then
    Ghost2File.Values[Ghost] := '*';

  // ֐Bghost.txtǂݍށB
  Dir := ExtractFilePath(GhostFile);
  Ghosts := TStringList.Create;
  try
    Ghosts.LoadFromFile(GhostFile);
    AGhost := TStringList.Create;
    try
      for i := 0 to Ghosts.Count-1 do
      begin
        AGhost.Text := StringReplace(Ghosts[i], ',', #13#10, [rfReplaceAll]);
        if AGhost.Count = 0 then
          Continue;
        if AGhost[0] <> 'GHOST' then
          Continue;
        DefFileName := Dir + StringReplace(AGhost[3], '"', '', [rfReplaceAll]);
        // `t@Cǂݍ
        BmpFileName := LoadDefinitionFile(Ghost, Surface,
          DefFileName, dum);
        if BmpFileName <> '' then
        begin
          Result := ExtractFilePath(DefFileName) + BmpFileName;
          Pos := dum;
          Break;
        end;
      end;
    finally
      AGhost.Free;
    end;
  finally
    Ghosts.Free;
  end;
end;

// GhostŎw肳S[XgSurfaceԂ̃T[tBXC[WۂɓǂݏoB
// HŎw肳Ărbg}bvɏoƁB
function GetImage(Ghost: PChar; Surface: integer; H: HBITMAP): integer; cdecl;
var Bmp: TBitmap;
    BmpFile: String;
    Position, x, y, nCol: integer;
begin
  try
    BmpFile := FetchBmpFileAndPosition(Ghost, Surface, Position);
    if BmpFile = '' then // ̂悤ȃS[Xĝ̂悤ȃT[tBX͌Ȃ
    begin
      Result := 1;
      Exit;
    end;
    Bmp := TBitmap.Create;
    try
      Bmp.Handle := H;
      if PicFileName <> BmpFile then
      begin
        try
          Pic.LoadFromFile(BmpFile);
          PicFileName := BmpFile;
        except
          // 蒼
          FreeAndNil(Pic);
          Pic := TPicture.Create;
          PicFileName := '';
          raise;
        end;
      end;
      nCol := Pic.Width div SurfaceWidth;
      x := SurfaceWidth * (Position mod nCol);
      y := SurfaceHeight * (Position div nCol);
      Bmp.Canvas.Draw(-x, -y, Pic.Graphic);
    finally
      Bmp.ReleaseHandle;
      Bmp.Free;
    end;
    Result := 0;
  except
    Result := 1;
  end;
end;

// C[W̑傫ԂB
// ̏ꍇC[W̑傫͂Ƃ番ĂƎv̂ŁA
// ȂPɒ萔ԂčxȂB
// C[W̑傫S[XgT[tBXԍɂĕςȂ炻̂悤ɁB
function GetImageSize(Ghost: PChar; Surface: integer;
  var w, h: integer): integer; cdecl;
begin
  w := SurfaceWidth;
  h := SurfaceHeight;
  Result := 0;
end;


// DLLŗL̐ݒsB
//
procedure Configure; cdecl;
var OpenDialog: TOpenDialog;
    Ini: TIniFile;
begin
  try
    ShowMessage('Specify SSTP Viewer''s ghost file.');
    OpenDialog := TOpenDialog.Create(nil);
    try
      OpenDialog.Filter := 'Ghost Definition File(ghost.txt)|ghost.txt|' +
       'All Files(*.*)|*.*';
      OpenDialog.FileName := GhostFile;
      if OpenDialog.Execute then
      begin
        GhostFile := OpenDialog.FileName;
        Ini := TIniFile.Create(MyPath + ConfigFile);
        try
          Ini.WriteString('SVG', 'GhostFile', GhostFile);
        finally
          Ini.Free;
        end;
        Ghost2File.Clear;
      end;
    finally
      OpenDialog.Free;
    end;
  except
    on E: Exception do
      ShowMessage(E.Message);
  end;
end;

exports
  Load,
  Unload,
  GetVersion,
  Configure,
  GetImage,
  GetImageSize;

begin

end.
