unit BottleChainEvent;

interface

uses Classes, Windows, SysUtils, Dialogs, Contnrs, HeadValue, Logs;

type
  TBottleChainEvent = class(TObject);

  TBottleChainBottleEvent = class(TBottleChainEvent)
  private
    FData: THeadValue;
    FLogType: TLogType;
    procedure SetData(const Value: THeadValue);
    procedure SetLogType(const Value: TLogType);
  public
    constructor Create;
    destructor Destroy; override;
    property Data: THeadValue read FData write SetData;
    property LogType: TLogType read FLogType write SetLogType;
  end;

implementation

{ TBottleChainBottleEvent }

constructor TBottleChainBottleEvent.Create;
begin
  FData := THeadValue.Create;
end;

destructor TBottleChainBottleEvent.Destroy;
begin
  FData.Free;
  inherited;
end;

procedure TBottleChainBottleEvent.SetData(const Value: THeadValue);
begin
  FData.Assign(Value);
end;


procedure TBottleChainBottleEvent.SetLogType(const Value: TLogType);
begin
  FLogType := Value;
end;

end.
