unit BottleChainRule;

interface

uses Windows, Classes, SysUtils, Dialogs, Contnrs, BottleChainEvent, Forms,
  MinMaxEditor, StrListEditor, MultipleChoiceEditor, Logs,
  HeadValue, SakuraSeekerInstance, Controls, BottleDef, BRegExp,
  OpenFileEditor, RegexUtils;

{
ANV郆jbgB
[ = ̃[ÑXg + ̃[NANṼXg
|󂷂ƁA
TBottleChainRule = TBottleChainConditioñXg + TBottleChainActioñXg

ȉgbv_EɃNXTB

TBottleChainRuleList́AׂẴ[̃XgłA
rule.txtɕۑŜłB

TBottleChainRuléATBottleChainConditionTBottleChainActioñXg
i[ReiłA1̃[(܂̂Ƃ)\B

ꂼ̏́AۃNXłTBottleChainConditionpA
̏ۑׂǉp[^(FȂ蕶񃊃XgȂ)A
̏̕ɂ\(̂Ƃ)ǗB

lɁAꂼ̃ANV͒ۃNXłTBottleChainActionpB
}


type
  TBottleChainCondition = class;
  TBottleChainConditionClass = class of TBottleChainCondition;
  TBottleChainAction = class;
  TBottleChainActionClass = class of TBottleChainAction;
  TBottleChainRule = class;
  TBottleChainRuleList = class;

  // 𖞂̓
  TBottleChainAction = class(TComponent)
  private
    FRule: TBottleChainRule;
    procedure SetRule(const Value: TBottleChainRule);
  protected
    procedure SetParentComponent(AParent: TComponent); override;
    procedure ReadState(Reader: TReader); override;
  public
    procedure Assign(Source: TPersistent); override;
    destructor Destroy; override;
    function HasParent: boolean; override;
    function GetParentComponent: TComponent; override;
    class function Title: String; virtual; abstract;
    function Edit: boolean; virtual;
    function StringExpression: String; virtual;
    property Rule: TBottleChainRule read FRule write SetRule;
  end;

  // Cxg̏
  TBottleChainCondition = class(TComponent)
  private
    FRule: TBottleChainRule;
    procedure SetRule(const Value: TBottleChainRule);
  protected
    procedure SetParentComponent(AParent: TComponent); override;
    procedure ReadState(Reader: TReader); override;
  public
    procedure Assign(Source: TPersistent); override;
    destructor Destroy; override;
    function HasParent: boolean; override;
    function GetParentComponent: TComponent; override;
    class function Title: String; virtual; abstract;
    function Check(Event: TBottleChainEvent): boolean; virtual; abstract;
    function Edit: boolean; virtual;
    function StringExpression: String; virtual;
    property Rule: TBottleChainRule read FRule write SetRule;
  end;

  // ƃANVgݍ킹1̃[
  TBottleChainRule = class(TComponent)
  private
    FConditions: TObjectList;
    FActions: TObjectList;
    FRuleList: TBottleChainRuleList;
    FEnabled: boolean;
    FTitle: String;
    procedure SetActions(const Value: TObjectList);
    procedure SetConditions(const Value: TObjectList);
    procedure SetRuleList(const Value: TBottleChainRuleList);
    procedure SetEnabled(const Value: boolean);
    procedure SetTitle(const Value: String);
  protected
    procedure GetChildren(Proc: TGetChildProc; Root: TComponent); override;
    procedure SetParentComonent(AParent: TComponent);
    procedure ReadState(Reader: TReader); override;
  public
    procedure Assign(Source: TPersistent); override;
    function HasParent: boolean; override;
    function GetParentComponent: TComponent; override;
    procedure AddCondition(ACondition: TBottleChainCondition);
    procedure RemoveCondition(ACondition: TBottleChainCondition);
    procedure AddAction(AnAction: TBottleChainAction);
    procedure RemoveAction(AnAction: TBottleChainAction);
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function StringExpression: String;
    property Conditions: TObjectList read FConditions write SetConditions;
    property Actions: TObjectList read FActions write SetActions;
    property RuleList: TBottleChainRuleList read FRuleList write SetRuleList;
    function Check(Event: TBottleChainEvent): boolean;
  published
    property Enabled: boolean read FEnabled write SetEnabled;
    property Title: String read FTitle write SetTitle;
  end;

  // [̃Xg
  TBottleChainRuleList = class(TComponent)
  private
    FRules: TObjectList;
    function GetCount: integer;
    function GetRules(Index: integer): TBottleChainRule;
  protected
    //procedure DefineProperties(Filer: TFiler); override;
    procedure GetChildren(Proc: TGetChildProc; Root: TComponent); override;
  public
    procedure AddRule(ARule: TBottleChainRule);
    procedure RemoveRule(ARule: TBottleChainRule);
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Count: integer read GetCount;
    property Rules[Index: integer]: TBottleChainRule read GetRules; default;
    property List: TObjectList read FRules;
  end;

  {}
  {*****  *****}

  // `lŵ̂łƂ
  TBottleChainChannelCondition = class(TBottleChainCondition)
  private
    FChannels: TStrings;
    procedure SetChannels(const Value: TStrings);
  public
    procedure Assign(Source: TPersistent); override;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
    function Edit: boolean; override;
    function StringExpression: String; override;
  published
    property Channels: TStrings read FChannels write SetChannels;
  end;

  // `lŵ̂łȂƂ
  TBottleChainChannelNotCondition = class (TBottleChainChannelCondition)
  public
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
    function StringExpression: String; override;
  end;

  // S[Xgŵ̂łƂ
  TBottleChainGhostCondition = class (TBottleChainCondition)
  private
    FGhosts: TStrings;
    procedure SetGhosts(const Value: TStrings);
  public
    procedure Assign(Source: TPersistent); override;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
    function Edit: boolean; override;
    function StringExpression: String; override;
  published
    property Ghosts: TStrings read FGhosts write SetGhosts;
  end;

  // S[Xgŵ̂łȂƂ
  TBottleChainGhostNotCondition = class (TBottleChainGhostCondition)
  public
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
    function StringExpression: String; override;
  end;

  // XNvg̒nȏmłƂ
  TBottleChainScriptLengthCondition = class(TBottleChainCondition)
  private
    FMinLength: integer;
    FMaxLength: integer;
    procedure SetMaxLength(const Value: integer);
    procedure SetMinLength(const Value: integer);
  public
    procedure Assign(Source: TPersistent); override;
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
    function Edit: boolean; override;
    function StringExpression: String; override;
  published
    property MinLength: integer read FMinLength write SetMinLength;
    property MaxLength: integer read FMaxLength write SetMaxLength;
  end;

  // XNvg܂ނƂ
  TBottleChainScriptCondition = class(TBottleChainCondition)
  private
    FPatterns: TStrings;
    FAll: boolean;
    procedure SetPatterns(const Value: TStrings);
    procedure SetAll(const Value: boolean);
  public
    procedure Assign(Source: TPersistent); override;
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
    function Edit: boolean; override;
    function StringExpression: String; override;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Patterns: TStrings read FPatterns write SetPatterns;
    property All: boolean read FAll write SetAll default false;
  end;

  // XNvg܂܂ȂƂ
  TBottleChainScriptNotCondition = class(TBottleChainScriptCondition)
  public
    class function Title: String; override;
    function StringExpression: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
  end;

  // bZ[W̃^Cv(ʏ{gEm点)
  TBottleChainBottleTypeCondition = class(TBottleChainCondition)
  private
    FLogType: TLogType;
    procedure SetLogType(const Value: TLogType);
  public
    procedure Assign(Source: TPersistent); override;
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
    function Edit: boolean; override;
    function StringExpression: String; override;
  published
    property LogType: TLogType read FLogType write SetLogType;
  end;

  // MS[Xg݂ȂƂ
  TBottleChainTargetGhostNotExistCondition = class(TBottleChainCondition)
  public
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
  end;

  // XNvgw̐K\Ƀ}b`Ƃ
  TBottleChainScriptRegExpCondition = class(TBottleChainCondition)
  private
    FPattern: String;
    procedure SetPattern(const Value: String);
  public
    procedure Assign(Source: TPersistent); override;
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
    function Edit: boolean; override;
    function StringExpression: String; override;
    constructor Create(AOwner: TComponent); override;
  published
    property Pattern: String read FPattern write SetPattern;
  end;

  // XNvgw̐K\Ƀ}b`ȂƂ
  TBottleChainScriptNotRegExpCondition = class(TBottleChainScriptRegExpCondition)
  public
    class function Title: String; override;
    function Check(Event: TBottleChainEvent): boolean; override;
    function StringExpression: String; override;
  end;

  {***** ANV *****}

  // 炷
  TBottleChainSoundAction = class(TBottleChainAction)
  private
    FSoundFile: String;
    procedure SetSoundFile(const Value: String);
  public
    procedure Assign(Source: TPersistent); override;
    class function Title: String; override;
    function StringExpression: String; override;
    function Edit: boolean; override;
  published
    property SoundFile: String read FSoundFile write SetSoundFile;
  end;

  // ȍ~̃[̏𒆎~
  TBottleChainAbortRuleAction = class(TBottleChainAction)
  public
    class function Title: String; override;
  end;

  // ȍ~n̃[XLbv
  TBottleChainSkipRuleAction = class(TBottleChainAction)
  private
    FSkipCount: integer;
    procedure SetSkipCount(const Value: integer);
  public
    procedure Assign(Source: TPersistent); override;
    class function Title: String; override;
    function StringExpression: String; override;
    function Edit: boolean; override;
    constructor Create(AOwner: TComponent); override;
  published
    property SkipCount: integer read FSkipCount write SetSkipCount;
  end;

  // 
  TBottleChainQuitAction = class(TBottleChainAction)
  public
    class function Title: String; override;
    function Edit: boolean; override;
  end;

  // w^uɃOc
  TBottleChainLogAction = class(TBottleChainAction)
  private
    FLogNames: TStrings;
    procedure SetLogNames(const Value: TStrings);
  public
    procedure Assign(Source: TPersistent); override;
    class function Title: String; override;
    function StringExpression: String; override;
    function Edit: boolean; override;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property LogNames: TStrings read FLogNames write SetLogNames;
  end;

  // MS[XgύX
  TBottleChainOverrideGhostAction = class(TBottleChainAction)
  private
    FTargetGhost: String;
    procedure SetTargetGhost(const Value: String);
  public
    procedure Assign(Source: TPersistent); override;
    class function Title: String; override;
    function StringExpression: String; override;
    function Edit: boolean; override;
  published
    property TargetGhost: String read FTargetGhost write SetTargetGhost;
  end;

  // bZ[WSSTPT[oɑMȂ
  TBottleChainNoDispatchAction = class(TBottleChainAction)
  public
    class function Title: String; override;
  end;

  // Oc(ʓ)
  TBottleChainSaveLogAction = class(TBottleChainAction)
  private
    FFileName: String;
    procedure SetFileName(const Value: String);
  protected
    function Filter: String; virtual; abstract;
  public
    procedure Assign(Source: TPersistent); override;
    function Edit: boolean; override;
  published
    property FileName: String read FFileName write SetFileName;
  end;

  // eLXg`̃Oc
  TBottleChainSaveTextLogAction = class(TBottleChainSaveLogAction)
  protected
    function Filter: String; override;
  public
    class function Title: String; override;
    function StringExpression: String; override;
  end;

  // XML`̃Oc
  TBottleChainSaveXMLLogAction = class (TBottleChainSaveLogAction)
  protected
    function Filter: String; override;
  public
    class function Title: String; override;
    function StringExpression: String; override;
  end;

  // uT[tBXԍ
  TSurfaceReplaceBeforeItem = class(TCollectionItem)
  private
    FFromNo: integer;
    FToNo: integer;
    procedure SetFromNo(const Value: integer);
    procedure SetToNo(const Value: integer);
  public
    procedure Assign(Source: TPersistent); override;
  published
    property FromNo: integer read FFromNo write SetFromNo;
    property ToNo: integer read FToNo write SetToNo;
  end;

  // T[tBXúuOvuṽZbg
  TSurfaceReplaceItem = class (TCollectionItem)
  private
    FAfter: integer;
    FBefore: TCollection;
    procedure SetAfter(const Value: integer);
    procedure SetBefore(const Value: TCollection);
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
  published
    property Before: TCollection read FBefore write SetBefore;
    property After: integer read FAfter write SetAfter;
  end;

  // T[tBXu
  TBottleChainSurfaceReplaceAction = class(TBottleChainAction)
  private
    FParams: TCollection;
    procedure SetParams(const Value: TCollection);
  protected
    function SelfToString: String;
    function StringsToSelf(Strs: TStrings): boolean; // true if succeeds
  public
    procedure Assign(Source: TPersistent); override;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    class function Title: String; override;
    function StringExpression: String; override;
    function Edit: boolean; override;
  published
    property Params: TCollection read FParams write SetParams;
  end;

const
  BottleChainActions: array [0..9] of TBottleChainActionClass = (
    TBottleChainLogAction,
    TBottleChainSoundAction,
    TBottleChainNoDispatchAction,
    TBottleChainOverrideGhostAction,
    TBottleChainAbortRuleAction,
    TBottleChainSkipRuleAction,
    TBottleChainSaveXMLLogAction,
    TBottleChainSaveTextLogAction,
    TBottleChainSurfaceReplaceAction,
    TBottleChainQuitAction
  );
  BottleChainConditions: array [0..10] of TBottleChainConditionClass = (
    TBottleChainBottleTypeCondition,
    TBottleChainChannelCondition, TBottleChainChannelNotCondition,
    TBottleChainGhostCondition, TBottleChainGhostNotCondition,
    TBottleChainScriptCondition, TBottleChainScriptNotCondition,
    TBottleChainScriptLengthCondition,
    TBottleChainScriptRegExpCondition, TBottleChainScriptNotRegExpCondition,
    TBottleChainTargetGhostNotExistCondition
  );

var BottleChainRuleList: TBottleChainRuleList;

implementation

var classregister_counter: integer; // RegisterClassp

{ TBottleChainCondition }

procedure TBottleChainCondition.Assign(Source: TPersistent);
begin
  if not Self.ClassType.InheritsFrom(Source.ClassType) then
    inherited;
end;

destructor TBottleChainCondition.Destroy;
begin
  if Rule <> nil then Rule.RemoveCondition(self);
  inherited;
end;

function TBottleChainCondition.Edit: boolean;
begin
  Result := true;
end;

function TBottleChainCondition.GetParentComponent: TComponent;
begin
  if Rule <> nil then Result := Rule
  else Result := inherited GetParentComponent;
end;

function TBottleChainCondition.HasParent: boolean;
begin
  if Rule <> nil then Result := true
  else Result := inherited HasParent;
end;

procedure TBottleChainCondition.ReadState(Reader: TReader);
begin
  inherited;
  if Reader.Parent is TBottleChainRule then begin
    Rule := Reader.Parent as TBottleChainRule;
  end;
end;

procedure TBottleChainCondition.SetParentComponent(AParent: TComponent);
begin
  if not (csLoading in ComponentState) and (AParent is TBottleChainRule) then
    Rule := AParent as TBottleChainRule;
end;

procedure TBottleChainCondition.SetRule(const Value: TBottleChainRule);
begin
  if Value <> Rule then begin
    if Rule <> nil then Rule.RemoveCondition(self);
    if Value <> nil then Value.AddCondition(self);
    FRule := Value;
  end;
end;

function TBottleChainCondition.StringExpression: String;
begin
  Result := Title;
end;

{ TBottleChainAction }

procedure TBottleChainAction.Assign(Source: TPersistent);
begin
  // ftHg̑(̃tB[hRs[Ȃ)
  if not Self.ClassType.InheritsFrom(Source.ClassType) then
    inherited;
end;

destructor TBottleChainAction.Destroy;
begin
  if Rule <> nil then Rule.RemoveAction(self);
  inherited;
end;

function TBottleChainAction.Edit: boolean;
begin
  Result := true;
end;

function TBottleChainAction.GetParentComponent: TComponent;
begin
  if Rule <> nil then Result := Rule
  else Result := inherited GetParentComponent;
end;

function TBottleChainAction.HasParent: boolean;
begin
  if Rule <> nil then Result := true
  else Result := inherited HasParent;
end;

procedure TBottleChainAction.ReadState(Reader: TReader);
begin
  inherited;
  if Reader.Parent is TBottleChainRule then begin
    Rule := Reader.Parent as TBottleChainRule;
  end;
end;

procedure TBottleChainAction.SetParentComponent(AParent: TComponent);
begin
  if not (csLoading in ComponentState) and (AParent is TBottleChainRule) then
    Rule := AParent as TBottleChainRule;
end;

procedure TBottleChainAction.SetRule(const Value: TBottleChainRule);
begin
  if Value <> Rule then begin
    if Rule <> nil then Rule.RemoveAction(self);
    if Value <> nil then Value.AddAction(self);
    FRule := Value;
  end;
end;

function TBottleChainAction.StringExpression: String;
begin
  Result := Title;
end;

{ TBottleChainChannelCondition }

procedure TBottleChainChannelCondition.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainChannelCondition) then
    inherited
  else
    FChannels.Assign((Source as TBottleChainChannelCondition).Channels);
end;

function TBottleChainChannelCondition.Check(
  Event: TBottleChainEvent): boolean;
var i: integer;
    Dat: THeadValue;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Dat := (Event as TBottleChainBottleEvent).Data;
  for i := 0 to FChannels.Count-1 do
    if Dat['Channel'] = FChannels[i] then begin
      Result := true;
      Exit;
    end;
end;

constructor TBottleChainChannelCondition.Create;
begin
  inherited;
  FChannels := TStringList.Create;
end;

destructor TBottleChainChannelCondition.Destroy;
begin
  FChannels.Free;
  inherited;
end;

function TBottleChainChannelCondition.Edit: boolean;
var Chs: TStringList;
    i: integer;
begin
  Chs := TStringList.Create;
  try
    for i := 0 to ChannelList.Count-1 do
      Chs.Add(ChannelList.ChannelItem[i].Name);
    Result := StrListEdit(FChannels, '`l1sw', false, Chs);
  finally
    Chs.Free;
  end;
end;

procedure TBottleChainChannelCondition.SetChannels(const Value: TStrings);
begin
  FChannels.Assign(Value);
end;

function TBottleChainChannelCondition.StringExpression: String;
var i: integer;
    chs: String;
begin
  chs := '';
  for i := 0 to FChannels.Count-1 do begin
    if i > 0 then chs := chs + '  ';
    chs := Format('%su%sv', [chs, FChannels[i]]);
  end;
  Result := Format('M`l %s ̂Ƃ', [chs]);
end;

class function TBottleChainChannelCondition.Title: String;
begin
  Result := 'M`l(w)̂Ƃ';
end;

{ TBottleChainRule }

procedure TBottleChainRule.AddAction(AnAction: TBottleChainAction);
begin
  FActions.Add(AnAction);
end;

procedure TBottleChainRule.AddCondition(ACondition: TBottleChainCondition);
begin
  FConditions.Add(ACondition);
end;

constructor TBottleChainRule.Create;
begin
  inherited;
  // Do NOT own objects!!
  FConditions := TObjectList.Create(false);
  FActions := TObjectList.Create(false);
end;

destructor TBottleChainRule.Destroy;
begin
  // gƂɂ͎q
  FConditions.OwnsObjects := true;
  FConditions.Free;
  FActions.OwnsObjects := true;
  FActions.Free;
  if RuleList <> nil then RuleList.RemoveRule(Self);
  inherited;
end;

procedure TBottleChainRule.GetChildren(Proc: TGetChildProc;
  Root: TComponent);
var i: integer;
begin
  inherited;
  for i := 0 to FConditions.Count-1 do Proc(FConditions[i] as TComponent);
  for i := 0 to FActions.Count-1 do Proc(FActions[i] as TComponent);
end;

function TBottleChainRule.GetParentComponent: TComponent;
begin
  if RuleList <> nil then Result := RuleList
  else Result := inherited GetParentComponent;
end;

function TBottleChainRule.HasParent: boolean;
begin
  if FRuleList <> nil then Result := true
  else Result := inherited HasParent;
end;

procedure TBottleChainRule.ReadState(Reader: TReader);
begin
  inherited;
  if Reader.Parent is TBottleChainRuleList then begin
    RuleList := Reader.Parent as TBottleChainRuleList;
  end;
end;

procedure TBottleChainRule.RemoveCondition(
  ACondition: TBottleChainCondition);
begin
  FConditions.Remove(ACondition);
end;

procedure TBottleChainRule.RemoveAction(AnAction: TBottleChainAction);
begin
  FActions.Remove(AnAction);
end;

procedure TBottleChainRule.SetActions(const Value: TObjectList);
begin
  FActions.Assign(Value);
end;

procedure TBottleChainRule.SetConditions(const Value: TObjectList);
begin
  FConditions.Assign(Value);
end;

procedure TBottleChainRule.SetParentComonent(AParent: TComponent);
begin
  if not (csLoading in ComponentState) and (AParent is TBottleChainRuleList) then
    RuleList := AParent as TBottleChainRuleList;
end;

procedure TBottleChainRule.SetRuleList(const Value: TBottleChainRuleList);
begin
  if Value <> FRuleList then begin
    if FRuleList <> nil then FRuleList.RemoveRule(self);
    if Value <> nil then Value.AddRule(self);
    FRuleList := Value;
  end;
end;

function TBottleChainRule.StringExpression: String;
var i: integer;
begin
  Result := '';
  for i := 0 to FConditions.Count-1 do begin
    if i > 0 then Result := Result + 'A';
    Result := Result + (FConditions[i] as TBottleChainCondition).StringExpression;
  end;
  if FActions.Count = 0 then begin
    Result := Result + 'Ȃ';
  end else begin
    for i := 0 to FActions.Count-1 do begin
      if i > 0 then Result := Result + 'B';
      Result := Result + (FActions[i] as TBottleChainAction).StringExpression;
    end;
  end;
  Result := Result + 'B';
end;

procedure TBottleChainRule.SetEnabled(const Value: boolean);
begin
  FEnabled := Value;
end;

procedure TBottleChainRule.SetTitle(const Value: String);
begin
  FTitle := Value;
end;

function TBottleChainRule.Check(Event: TBottleChainEvent): boolean;
var i: integer;
    re: boolean;
    {str: String;}
begin
  Result := true;
  for i := 0 to Conditions.Count-1 do begin
    re := (Conditions[i] as TBottleChainCondition).Check(Event);
    {if re then Str := 'true' else Str := 'false';
    ShowMessage((Conditions[i] as TBottleChainCondition).StringExpression + #13#10 + str + #13#10 +
      (Event as TBottleChainBottleEvent).Data.ToStr);}
    if not re then begin
      Result := false;
      Exit;
    end;
  end;
end;

procedure TBottleChainRule.Assign(Source: TPersistent);
var
  Src: TBottleChainRule;
  SrcAction, NewAction: TBottleChainAction;
  SrcCondition, NewCondition: TBottleChainCondition;
  i: integer;
begin
  if not (Source is TBottleChainRule) then
    inherited
  else
  begin
    Src := Source as TBottleChainRule;
    while FConditions.Count > 0 do
      FConditions[0].Free;
    FConditions.Clear;
    for i := 0 to Src.Conditions.Count-1 do
    begin
      SrcCondition := Src.Conditions[i] as TBottleChainCondition;
      NewCondition := TBottleChainConditionClass(SrcCondition.ClassType).Create(Self);
      NewCondition.Assign(SrcCondition);
      NewCondition.Rule := Self; // ԐړIFConditionsɒǉ
    end;
    while FActions.Count > 0 do
      FActions[0].Free;
    FActions.Clear;
    for i := 0 to Src.Actions.Count-1 do
    begin
      SrcAction := Src.Actions[i] as TBottleChainAction;
      NewAction := TBottleChainActionClass(SrcAction.ClassType).Create(Self);
      NewAction.Assign(SrcAction);
      NewAction.Rule := Self; // ԐړIFActionsɒǉ
    end;
    FEnabled := Src.Enabled;
    FTitle := Src.Title;
  end;
end;

{ TBottleChainRuleList }

procedure TBottleChainRuleList.AddRule(ARule: TBottleChainRule);
begin
  FRules.Add(ARule);
end;

constructor TBottleChainRuleList.Create(AOwner: TComponent);
begin
  inherited;
  // Do NOT own object!!
  FRules := TObjectList.Create(false);
end;

destructor TBottleChainRuleList.Destroy;
begin
  FRules.Free;
  inherited;
end;

procedure TBottleChainRuleList.GetChildren(Proc: TGetChildProc;
  Root: TComponent);
var i: integer;
begin
  inherited;
  for i := 0 to FRules.Count-1 do begin
    Proc(FRules[i] as TComponent);
  end;
end;

function TBottleChainRuleList.GetCount: integer;
begin
  Result := FRules.Count;
end;

function TBottleChainRuleList.GetRules(Index: integer): TBottleChainRule;
begin
  Result := FRules[Index] as TBottleChainRule;
end;

procedure TBottleChainRuleList.RemoveRule(ARule: TBottleChainRule);
begin
  FRules.Remove(ARule);
end;

{ TBottleChainSoundAction }

procedure TBottleChainSoundAction.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainSoundAction) then
    inherited
  else
    FSoundFile := (Source as TBottleChainSoundAction).SoundFile;
end;

function TBottleChainSoundAction.Edit: boolean;
var FileName: String;
begin
  FileName := SoundFile;
  Result := OpenFileEdit(FileName,
    'TEht@C(*.wav)|*.wav|ׂẴt@C(*.*)|*.*',
    't@Cw(^u%ghost%vu%channel%vp)', []);
  if Result then SoundFile := FileName;
end;

procedure TBottleChainSoundAction.SetSoundFile(const Value: String);
begin
  FSoundFile := Value;
end;

function TBottleChainSoundAction.StringExpression: String;
begin
  Result := Format('TEhu%sv炷', [ExtractFileName(SoundFile)]);
end;

class function TBottleChainSoundAction.Title: String;
begin
  Result := '()炷'
end;

{ TBottleChainChannelNotCondition }

function TBottleChainChannelNotCondition.Check(Event: TBottleChainEvent): boolean;
var i: integer;
    Dat: THeadValue;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Result := true;
  Dat := (Event as TBottleChainBottleEvent).Data;
  for i := 0 to FChannels.Count-1 do
    if Dat['Channel'] = FChannels[i] then begin
      Result := false;
      Exit;
    end;
end;

function TBottleChainChannelNotCondition.StringExpression: String;
var i: integer;
    chs: String;
begin
  chs := '';
  for i := 0 to FChannels.Count-1 do begin
    if i > 0 then chs := chs + '  ';
    chs := Format('%su%sv', [chs, FChannels[i]]);
  end;
  Result := Format('M`l %s ł͂ȂƂ', [chs]);
end;

class function TBottleChainChannelNotCondition.Title: String;
begin
  Result := 'M`l(w)ł͂ȂƂ';
end;

{ TBottleChainGhostCondition }

procedure TBottleChainGhostCondition.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainGhostCondition) then
    inherited
  else
    FGhosts.Assign((Source as TBottleChainGhostCondition).Ghosts);
end;

function TBottleChainGhostCondition.Check(
  Event: TBottleChainEvent): boolean;
var i: integer;
    Dat: THeadValue;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Dat := (Event as TBottleChainBottleEvent).Data;
  for i := 0 to FGhosts.Count-1 do
    if Dat['IfGhost'] = FGhosts[i] then begin
      Result := true;
      Exit;
    end;
end;

constructor TBottleChainGhostCondition.Create(AOwner: TComponent);
begin
  inherited;
  FGhosts := TStringList.Create;
end;

destructor TBottleChainGhostCondition.Destroy;
begin
  FGhosts.Free;
  inherited;
end;

function TBottleChainGhostCondition.Edit: boolean;
var Consts: TStringList;
    i: integer;
begin
  Consts := TStringList.Create;
  try
    SakuraSeeker.BeginDetect;
    for i := 0 to SakuraSeeker.Count-1 do
      if Consts.IndexOf(SakuraSeeker[i].Name) < 0 then
        Consts.Add(SakuraSeeker[i].Name);
    Result := StrListEdit(FGhosts, 'S[Xg1sw', false, Consts);
  finally
    Consts.Free;
  end;
end;

procedure TBottleChainGhostCondition.SetGhosts(const Value: TStrings);
begin
  FGhosts.Assign(Value);
end;

function TBottleChainGhostCondition.StringExpression: String;
var i: integer;
    ghosts: String;
begin
  ghosts := '';
  for i := 0 to FGhosts.Count-1 do begin
    if i > 0 then ghosts := ghosts + '  ';
    ghosts := Format('%su%sv', [ghosts, FGhosts[i]]);
  end;
  Result := Format('S[Xg %s ̂Ƃ', [ghosts]);
end;

class function TBottleChainGhostCondition.Title: String;
begin
  Result := 'S[Xg(w)̂Ƃ';
end;

{ TBottleChainGhostNotCondition }

function TBottleChainGhostNotCondition.Check(
  Event: TBottleChainEvent): boolean;
var i: integer;
    Dat: THeadValue;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Result := true;
  Dat := (Event as TBottleChainBottleEvent).Data;
  for i := 0 to FGhosts.Count-1 do
    if Dat['IfGhost'] = FGhosts[i] then begin
      Result := false;
      Exit;
    end;
end;

function TBottleChainGhostNotCondition.StringExpression: String;
var i: integer;
    ghosts: String;
begin
  ghosts := '';
  for i := 0 to FGhosts.Count-1 do begin
    if i > 0 then ghosts := ghosts + '  ';
    ghosts := Format('%su%sv', [ghosts, FGhosts[i]]);
  end;
  Result := Format('S[Xg %s łȂƂ', [ghosts]);
end;

class function TBottleChainGhostNotCondition.Title: String;
begin
  Result := 'S[Xg(w)łȂƂ';
end;

{ TBottleChainAbortRuleAction }

class function TBottleChainAbortRuleAction.Title: String;
begin
  Result := 'ȍ~̃[̏𒆎~';
end;

{ TBottleChainScriptLengthCondition }

procedure TBottleChainScriptLengthCondition.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainScriptLengthCondition) then
    inherited
  else
  begin
    FMinLength := (Source as TBottleChainScriptLengthCondition).MinLength;
    FMaxLength := (Source as TBottleChainScriptLengthCondition).MaxLength;
  end;
end;

function TBottleChainScriptLengthCondition.Check(
  Event: TBottleChainEvent): boolean;
var Dat: THeadValue;
    len: integer;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Dat := (Event as TBottleChainBottleEvent).Data;
  len := Length(Dat['Script']);
  Result := (len >= FMinLength) and (len <= FMaxLength);
end;

function TBottleChainScriptLengthCondition.Edit: boolean;
begin
  Application.CreateForm(TfrmMinMaxEditor, frmMinMaxEditor);
  with frmMinMaxEditor do begin
    spnMin.Value := FMinLength;
    spnMax.Value := FMaxLength;
    Result := Execute;
    if Result then begin
      FMinLength := spnMin.Value;
      FMaxLength := spnMax.Value;
    end;
    Release;
  end;
end;

procedure TBottleChainScriptLengthCondition.SetMaxLength(
  const Value: integer);
begin
  if Value >= 0 then FMaxLength := Value;
end;

procedure TBottleChainScriptLengthCondition.SetMinLength(
  const Value: integer);
begin
  if Value >= 0 then FMinLength := Value;
end;

function TBottleChainScriptLengthCondition.StringExpression: String;
begin
  Result := Format('XNvg̒%doCgȏ%doCgȉ̂Ƃ', [FMinLength, FMaxLength]);
end;

class function TBottleChainScriptLengthCondition.Title: String;
begin
  Result := 'XNvg̒(w)oCgȏ(w)oCgȉ̂Ƃ';
end;

{ TBottleChainQuitAction }

function TBottleChainQuitAction.Edit: boolean;
begin
  Result := MessageDlg('{Cł?', mtWarning, mbOkCancel, 0) = mrOk;
end;

class function TBottleChainQuitAction.Title: String;
begin
  Result := '';
end;

{ TBottleChainScriptCondition }

procedure TBottleChainScriptCondition.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainScriptCondition) then
    inherited
  else
  begin
    Patterns.Assign((Source as TBottleChainScriptCondition).Patterns);
    FAll := (Source as TBottleChainScriptCondition).All;
  end;
end;

function TBottleChainScriptCondition.Check(Event: TBottleChainEvent): boolean;
var i: integer;
    Dat: THeadValue;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Dat := (Event as TBottleChainBottleEvent).Data;
  if All then
  begin
    Result := true;
    for i := 0 to FPatterns.Count-1 do
      if AnsiPos(FPatterns[i], Dat['Script']) <= 0 then
      begin
        Result := false;
        Exit;
      end;
  end else
  begin
    for i := 0 to FPatterns.Count-1 do
      if AnsiPos(FPatterns[i], Dat['Script']) > 0 then
      begin
        Result := true;
        Exit;
      end;
  end;
end;

constructor TBottleChainScriptCondition.Create(AOwner: TComponent);
begin
  inherited;
  FPatterns := TStringList.Create;
end;

destructor TBottleChainScriptCondition.Destroy;
begin
  FPatterns.Free;
  inherited;
end;

function TBottleChainScriptCondition.Edit: boolean;
var Index: integer;
    SavedPattern: TStringList;
begin
  SavedPattern := TStringList.Create;
  try
    SavedPattern.Assign(FPatterns);
    Result := StrListEdit(FPatterns, 'p^[1sw');
    if FAll then
      Index := 1
    else
      Index := 0;
    if not Result then
      Exit;
    if FPatterns.Count > 1 then
    begin
      Result := MultipleChoiceEdit('IvV', ['ꂩ', 'ׂ'], Index);
      if Result then
        FAll := Index = 1
      else
        FPatterns.Assign(SavedPattern);
    end;
  finally
    SavedPattern.Free;
  end;
end;

procedure TBottleChainScriptCondition.SetAll(const Value: boolean);
begin
  FAll := Value;
end;

procedure TBottleChainScriptCondition.SetPatterns(const Value: TStrings);
begin
  FPatterns.Assign(Value);
end;

function TBottleChainScriptCondition.StringExpression: String;
var i: integer;
    patterns: String;
begin
  patterns := '';
  for i := 0 to FPatterns.Count-1 do begin
    if i > 0 then
    begin
      if All then
        patterns := patterns + '  '
      else
        patterns := patterns + '  ';
    end;
    patterns := Format('%su%sv', [patterns, FPatterns[i]]);
  end;
  Result := Format('XNvg %s ܂܂ĂƂ', [patterns]);
end;

class function TBottleChainScriptCondition.Title: String;
begin
  Result := 'XNvg(w)܂܂ĂƂ';
end;

{ TBottleChainScriptNotCondition }

function TBottleChainScriptNotCondition.Check(
  Event: TBottleChainEvent): boolean;
var i: integer;
    Dat: THeadValue;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Result := true;
  Dat := (Event as TBottleChainBottleEvent).Data;
  for i := 0 to FPatterns.Count-1 do
    if AnsiPos(FPatterns[i], Dat['Script']) > 0 then begin
      Result := false;
      Exit;
    end;
end;

function TBottleChainScriptNotCondition.StringExpression: String;
var i: integer;
    patterns: String;
begin
  patterns := '';
  for i := 0 to FPatterns.Count-1 do begin
    if i > 0 then patterns := patterns + '  ';
    patterns := Format('%su%sv', [patterns, FPatterns[i]]);
  end;
  Result := Format('XNvg %s ܂܂ĂȂƂ', [patterns]);
end;

class function TBottleChainScriptNotCondition.Title: String;
begin
  Result := 'XNvg(w)܂܂ĂȂƂ';
end;

{ TBottleChainLogAction }

procedure TBottleChainLogAction.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainLogAction) then
    inherited
  else
    LogNames.Assign((Source as TBottleChainLogAction).LogNames);
end;

constructor TBottleChainLogAction.Create(AOwner: TComponent);
begin
  inherited;
  FLogNames := TStringList.Create;
end;

destructor TBottleChainLogAction.Destroy;
begin
  FLogNames.Free;
  inherited;
end;

function TBottleChainLogAction.Edit: boolean;
var Consts: TStringList;
begin
  Consts := TStringList.Create;
  try
    with Consts do begin
      Add('%channel%');
      Add('%ghost%');
      Add('%date%');
      Add('%year%');
      Add('%yy%');
      Add('%month%');
      Add('%day%');
      Add('%hour%');
      Add('%minute');
    end;
    Result := StrListEdit(FLogNames, '^uw(^gp\)', false, Consts);
  finally
    Consts.Free;
  end;
end;

procedure TBottleChainLogAction.SetLogNames(const Value: TStrings);
begin
  FLogNames.Assign(Value);
end;

function TBottleChainLogAction.StringExpression: String;
var i: integer;
    logs: String;
begin
  logs := '';
  for i := 0 to FLogNames.Count-1 do begin
    if i > 0 then logs := logs + '  ';
    logs := Format('%su%sv', [logs, FLogNames[i]]);
  end;
  Result := Format('%s^uɃOc', [logs]);
end;

class function TBottleChainLogAction.Title: String;
begin
  Result := '(w)^uɃOc';
end;

{ TBottleChainBottleTypeCondition }

procedure TBottleChainBottleTypeCondition.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainBottleTypeCondition) then
    inherited
  else
    FLogType := (Source as TBottleChainBottleTypeCondition).LogType;
end;

function TBottleChainBottleTypeCondition.Check(
  Event: TBottleChainEvent): boolean;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Result := ((Event as TBottleChainBottleEvent).LogType = FLogType);
end;

function TBottleChainBottleTypeCondition.Edit: boolean;
var Index: integer;
begin
  Index := Ord(FLogType);
  Result := MultipleChoiceEdit('^Cv', ['ʏ{g', 'm点'], Index);
  if Result then FLogType := TLogType(Index);
end;

procedure TBottleChainBottleTypeCondition.SetLogType(
  const Value: TLogType);
begin
  FLogType := Value;
end;

function TBottleChainBottleTypeCondition.StringExpression: String;
const
  Mes: array[TLogType] of String = ('ʏ{g', 'm点');
begin
  Result := Format('bZ[W̃^Cv%ŝƂ', [Mes[FLogType]]);
end;

class function TBottleChainBottleTypeCondition.Title: String;
begin
  Result := 'bZ[W̃^Cv(w)̂Ƃ';
end;

{ TBottleChainNoDispatchAction }

class function TBottleChainNoDispatchAction.Title: String;
begin
  Result := '̃bZ[WSSTPT[oɓ]Ȃ';
end;

{ TBottleChainTargetGhostNotExistCondition }

function TBottleChainTargetGhostNotExistCondition.Check(
  Event: TBottleChainEvent): boolean;
var Dat: THeadValue;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Dat := (Event as TBottleChainBottleEvent).Data;
  SakuraSeeker.BeginDetect;
  Result := SakuraSeeker.ProcessByName[Dat['TargetGhost']] = nil;
end;

class function TBottleChainTargetGhostNotExistCondition.Title: String;
begin
  Result := 'wS[XgNĂȂƂ';
end;

{ TBottleChainOverrideGhostAction }

procedure TBottleChainOverrideGhostAction.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainOverrideGhostAction) then
    inherited
  else
    FTargetGhost := (Source as TBottleChainOverrideGhostAction).TargetGhost;
end;

function TBottleChainOverrideGhostAction.Edit: boolean;
var Ans: String;
begin
  Ans := FTargetGhost;
  Result := InputQuery('S[Xgw', 'MS[Xg', Ans);
  if Ans = '' then Result := false;
  if Result then FTargetGhost := Ans;
end;

procedure TBottleChainOverrideGhostAction.SetTargetGhost(
  const Value: String);
begin
  FTargetGhost := Value;
end;

function TBottleChainOverrideGhostAction.StringExpression: String;
begin
  Result := Format('zS[Xgu%svɕύX', [FTargetGhost]);
end;

class function TBottleChainOverrideGhostAction.Title: String;
begin
  Result := 'zS[Xg(w)ɕύX';
end;

{ TBottleChainScriptRegExpCondition }

procedure TBottleChainScriptRegExpCondition.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainScriptRegExpCondition) then
    inherited
  else
    FPattern := (Source as TBottleChainScriptRegExpCondition).Pattern;
end;

function TBottleChainScriptRegExpCondition.Check(
  Event: TBottleChainEvent): boolean;
var Dat: THeadValue;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Dat := (Event as TBottleChainBottleEvent).Data;
  try
    if Dat['Script'] <> '' then
      Result := RegExp.Match(Pattern, Dat['Script'])
    else
      Result := false;
  except
    on E: EBRegExpError do begin
      ShowMessage('K\G['#13#10#13#10 + E.Message);
      Result := false;
    end;
  end;
end;

constructor TBottleChainScriptRegExpCondition.Create(AOwner: TComponent);
begin
  inherited;
  FPattern := '';
end;

function TBottleChainScriptRegExpCondition.Edit: boolean;
var Str: String;
var ErrorMsg: String;
begin
  Str := FilterAutoRegExp(Pattern);

  Result := InputQuery('K\', 'p^[', Str);
  if Result then begin
    if Str = '' then Result := false else begin
      ErrorMsg := SafeAndCheckRegExp(Str);
      if ErrorMsg = '' then
        Pattern := Str;
    end;
  end;
end;

procedure TBottleChainScriptRegExpCondition.SetPattern(const Value: String);
begin
  FPattern := Value;
end;

function TBottleChainScriptRegExpCondition.StringExpression: String;
begin
  Result := Format('XNvgK\u%svɃ}b`Ƃ', [FilterAutoRegExp(Pattern)]);
end;

class function TBottleChainScriptRegExpCondition.Title: String;
begin
  Result := 'XNvgK\(w)Ƀ}b`Ƃ';
end;

{ TBottleChainSkipRuleAction }

procedure TBottleChainSkipRuleAction.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainSkipRuleAction) then
    inherited
  else
    FSkipCount := (Source as TBottleChainSkipRuleAction).SkipCount;
end;

constructor TBottleChainSkipRuleAction.Create(AOwner: TComponent);
begin
  inherited;
  FSkipCount := 1;
end;

function TBottleChainSkipRuleAction.Edit: boolean;
var Str: String;
begin
  Str := IntToStr(FSkipCount);
  Result := InputQuery('l', 'XLbv郋[̐', Str);
  if Result then begin
    try
      FSkipCount := StrToInt(Str);
    except
      on EConvertError do begin
        Beep;
        Result := false;
      end;
    end;
  end;
end;

procedure TBottleChainSkipRuleAction.SetSkipCount(const Value: integer);
begin
  if FSkipCount >= 0 then FSkipCount := Value;
end;

function TBottleChainSkipRuleAction.StringExpression: String;
begin
  Result := Format('ȍ~%d̃[̏XLbv', [SkipCount]);
end;

class function TBottleChainSkipRuleAction.Title: String;
begin
  Result := 'ȍ~(w)̃[̏XLbv';
end;

{ TBottleChainSaveLogAction }

procedure TBottleChainSaveLogAction.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainSaveLogAction) then
    inherited
  else
    FileName := (Source as TBottleChainSaveLogAction).FileName;
end;

function TBottleChainSaveLogAction.Edit: boolean;
var LogFileName: String;
begin
  LogFileName := FileName;
  Result := SaveFileEdit(LogFileName, Self.Filter,
    't@Cw(^p)', []);
  if Result and (LogFileName <> '') then
    FileName := LogFileName;
  Result := true;
end;

procedure TBottleChainSaveLogAction.SetFileName(const Value: String);
begin
  FFileName := Value;
end;

{ TBottleChainSaveTextLogAction }

function TBottleChainSaveTextLogAction.Filter: String;
begin
  Result := 'eLXgt@C(*.txt)|*.txt|ׂẴt@C(*.*)|*.*'
end;

function TBottleChainSaveTextLogAction.StringExpression: String;
begin
  Result := Format('eLXgt@C"%s"ɋL^', [FileName]);
end;

class function TBottleChainSaveTextLogAction.Title: String;
begin
  Result := 'eLXgt@C(w)ɋL^'
end;

{ TBottleChainSaveXMLLogAction }

function TBottleChainSaveXMLLogAction.Filter: String;
begin
  Result := 'XMLt@C(*.xml;*.xbl)|*.xml;*.xbl|ׂẴt@C(*.*)|*.*';
end;

function TBottleChainSaveXMLLogAction.StringExpression: String;
begin
  Result := Format('XMLt@C"%s"ɋL^', [FileName]);
end;

class function TBottleChainSaveXMLLogAction.Title: String;
begin
  Result := 'XMLt@C(w)ɋL^'
end;

{ TSurfaceReplaceBeforeItem }

procedure TSurfaceReplaceBeforeItem.Assign(Source: TPersistent);
begin
  if not (Source is TSurfaceReplaceBeforeItem) then
    inherited
  else
  begin
    FromNo := (Source as TSurfaceReplaceBeforeItem).FromNo;
    ToNo   := (Source as TSurfaceReplaceBeforeItem).ToNo;
  end;
end;

procedure TSurfaceReplaceBeforeItem.SetFromNo(const Value: integer);
begin
  FFromNo := Value;
end;

procedure TSurfaceReplaceBeforeItem.SetToNo(const Value: integer);
begin
  FToNo := Value;
end;

{ TSurfaceReplaceItem }

procedure TSurfaceReplaceItem.Assign(Source: TPersistent);
begin
  if not (Source is TSurfaceReplaceItem) then
    inherited
  else
  begin
    Before := (Source as TSurfaceReplaceItem).Before;
    After := (Source as TSurfaceReplaceItem).After;
  end;
end;

constructor TSurfaceReplaceItem.Create(Collection: TCollection);
begin
  inherited Create(Collection);
  FBefore := TCollection.Create(TSurfaceReplaceBeforeItem);
end;

destructor TSurfaceReplaceItem.Destroy;
begin
  FBefore.Free;
  inherited;
end;

procedure TSurfaceReplaceItem.SetAfter(const Value: integer);
begin
  FAfter := Value;
end;

procedure TSurfaceReplaceItem.SetBefore(const Value: TCollection);
begin
  FBefore.Assign(Value);
end;

{ TBottleChainSurfaceReplaceAction }

procedure TBottleChainSurfaceReplaceAction.Assign(Source: TPersistent);
begin
  if not (Source is TBottleChainSurfaceReplaceAction) then
    inherited
  else
    Params := (Source as TBottleChainSurfaceReplaceAction).Params; // Assign
end;

constructor TBottleChainSurfaceReplaceAction.Create(AOwner: TComponent);
begin
  inherited;
  FParams := TCollection.Create(TSurfaceReplaceItem);
end;

destructor TBottleChainSurfaceReplaceAction.Destroy;
begin
  FParams.Free;
  inherited;
end;

function TBottleChainSurfaceReplaceAction.Edit: boolean;
var
  Strs, Consts: TStringList;
  OK: boolean;
begin
  Strs := TStringList.Create;
  try
    Strs.Text := SelfToString;
    Consts := TStringList.Create;
    try
      Consts.Add('100=1');
      Consts.Add('100-110,120-130=1');
      OK := false;
      repeat
        if StrListEdit(Strs, 'ϊ[L(1-2,3-4=5)', false, Consts) then
          OK := StringsToSelf(Strs)
        else
          Break;
      until OK;
    finally
      Consts.Free;
    end;
  finally
    Strs.Free;
  end;
  Result := Params.Count > 0;
end;

function TBottleChainSurfaceReplaceAction.SelfToString: String;
var
  i, j: integer;
  Param: TSurfaceReplaceItem;
  Before: TSurfaceReplaceBeforeItem;
begin
  Result := '';
  for i := 0 to Params.Count-1 do
  begin
    if i <> 0 then
      Result := Result + #13#10;
    Param := (Params.Items[i] as TSurfaceReplaceitem);
    for j := 0 to Param.Before.Count-1 do
    begin
      if j <> 0 then
        Result := Result + ',';
      Before := Param.Before.Items[j] as TSurfaceReplaceBeforeItem;
      if Before.FromNo <> Before.ToNo then
        Result := Result + Format('%d-%d', [Before.FromNo, Before.ToNo])
      else
        Result := Result + IntToStr(Before.FromNo);
    end;
    Result := Result + '=' + IntToStr(Param.After);
  end;
end;

procedure TBottleChainSurfaceReplaceAction.SetParams(
  const Value: TCollection);
begin
  FParams.Assign(Value);
end;

function TBottleChainSurfaceReplaceAction.StringExpression: String;
var
  i, j: integer;
  Param: TSurfaceReplaceItem;
  Before: TSurfaceReplaceBeforeItem;
begin
  Result := '';
  for i := 0 to Params.Count-1 do
  begin
    if i <> 0 then
      Result := Format('%sA', [Result]);
    Param := (Params.Items[i] as TSurfaceReplaceItem);
    for j := 0 to Param.Before.Count-1 do
    begin
      if j <> 0 then
        Result := Format('%s', [Result]);
      Before := Param.Before.Items[j] as TSurfaceReplaceBeforeItem;
      if Before.FromNo <> Before.ToNo then
        Result := Format('%s%d`%d', [Result, Before.FromNo, Before.ToNo])
      else
        Result := Format('%s%d', [Result, Before.FromNo]);
    end;
    Result := Format('%s%d', [Result, Param.After]);
  end;
  Result := Format('T[tBX%sϊ', [Result]);
end;

function TBottleChainSurfaceReplaceAction.StringsToSelf(Strs: TStrings): boolean;
var
  i, P, B1, B2, A: integer;
  New: TCollection;
  Item: TSurfaceReplaceItem;
  Before: TSurfaceReplaceBeforeItem;
  Line, Str: String;
begin
  Result := false;
  New := TCollection.Create(TSurfaceReplaceItem);
  try
    for i := 0 to Strs.Count-1 do
    begin
      try
        Line := Strs[i];
        Line := StringReplace(Trim(Line), ' ', '', [rfReplaceAll]);
        if Line = '' then
          Continue;
        P := 1;
        Item := New.Add as TSurfaceReplaceItem;
        while true do
        begin
          Str := '';
          while Line[p] in ['0'..'9'] do
          begin
            Str := Str + Line[p];
            Inc(p);
          end;
          B1 := StrToInt(Str);
          B2 := B1;
          if Line[p] = '-' then
          begin
            Inc(p);
            Str := '';
            while Line[p] in ['0'..'9'] do
            begin
              Str := Str + Line[p];
              Inc(p);
            end;
            B2 := StrToInt(Str);
          end;
          if B1 > B2 then
          begin
            A := B2; B2 := B1; B1 := A;
          end;
          Before := Item.Before.Add as TSurfaceReplaceBeforeItem;
          Before.FromNo := B1;
          Before.ToNo := B2;
          if Line[p] <> ',' then
            Break
          else
            Inc(p);
        end;
        if Line[p] = '=' then
        begin
          Inc(p);
          Str := '';
          while Line[p] in ['-', '0'..'9'] do
          begin
            Str := Str + Line[p];
            Inc(p);
          end;
          A := StrToInt(Str);
          Item.After := A;
        end else
          raise Exception.Create('ʒuɃCR[(=)܂');
      except
        on E: Exception do
        begin
          ShowMessage(Format('eɃG[܂B'#13#10'%ds: %s',
            [i+1, E.Message]));
          Exit;
        end;
      end;
    end;
    Params := New; // This calls TCollection.Assign
    Result := true;
  finally
    New.Free;
  end;
end;

class function TBottleChainSurfaceReplaceAction.Title: String;
begin
  Result := 'T[tBX(w)(w)ɕϊ';
end;

{ TBottleChainScriptNotRegExpCondition }

function TBottleChainScriptNotRegExpCondition.Check(
  Event: TBottleChainEvent): boolean;
var Dat: THeadValue;
begin
  Result := false;
  if not (Event is TBottleChainBottleEvent) then Exit;
  Dat := (Event as TBottleChainBottleEvent).Data;
  try
    if Dat['Script'] <> '' then
      Result := not RegExp.Match(Pattern, Dat['Script'])
    else
      Result := false;
  except
    on E: EBRegExpError do begin
      ShowMessage('K\G['#13#10#13#10 + E.Message);
      Result := false;
    end;
  end;
end;

function TBottleChainScriptNotRegExpCondition.StringExpression: String;
begin
  Result := Format('XNvgK\u%svɃ}b`ȂƂ', [FilterAutoRegExp(Pattern)]);
end;

class function TBottleChainScriptNotRegExpCondition.Title: String;
begin
  Result := 'XNvgK\(w)Ƀ}b`ȂƂ';
end;

initialization

RegisterClasses([TBottleChainRule, TBottleChainRuleList]);
for classregister_counter := 0 to High(BottleChainConditions) do
  Classes.RegisterClass(BottleChainConditions[classregister_counter]);
for classregister_counter := 0 to High(BottleChainActions) do
  Classes.RegisterClass(BottleChainActions[classregister_counter]);

end.
