unit BottleChainRuleEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CheckLst, ComCtrls, BottleChainRule;

type
  TfrmBottleChainRuleEditor = class(TForm)
    PageControl: TPageControl;
    tstGeneral: TTabSheet;
    tstCondition: TTabSheet;
    tstAction: TTabSheet;
    cbxRuleEnabled: TCheckBox;
    lblTitle: TLabel;
    edtTitle: TEdit;
    btnOK: TButton;
    memStringExpression: TMemo;
    lstCondition: TCheckListBox;
    lstAction: TCheckListBox;
    Button1: TButton;
    procedure btnOKClick(Sender: TObject);
    procedure lstConditionClickCheck(Sender: TObject);
    procedure lstActionClickCheck(Sender: TObject);
    procedure lstConditionDblClick(Sender: TObject);
    procedure lstActionDblClick(Sender: TObject);
    procedure edtTitleChange(Sender: TObject);
    procedure cbxRuleEnabledClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private 錾 }
    FRule: TBottleChainRule;
    FConditionsCheckStatus: array [0..High(BottleChainConditions)] of boolean;
    FActionsCheckStatus: array [0..High(BottleChainActions)] of boolean;
    procedure lstConditionChecked(Index: integer; Checked: boolean);
    procedure lstActionChecked(Index: integer; Checked: boolean);
  public
    { Public 錾 }
    procedure InitializeDisplay;
    procedure UpdateDisplay;
    function Execute(EditRule: TBottleChainRule): boolean;
  end;

var
  frmBottleChainRuleEditor: TfrmBottleChainRuleEditor;

implementation

{$R *.dfm}

{ TfrmBottleChainListEditor }

function TfrmBottleChainRuleEditor.Execute(EditRule: TBottleChainRule): boolean;
begin
  if EditRule = nil then raise Exception.Create('EditRule is null');
  FRule := EditRule;
  InitializeDisplay;
  UpdateDisplay;
  Result := ShowModal = mrOk;
end;

procedure TfrmBottleChainRuleEditor.UpdateDisplay;
var i, j: integer;
    f: boolean;
begin
  memStringExpression.Text := FRule.StringExpression;
  edtTitle.Text := FRule.Title;
  cbxRuleEnabled.Checked := FRule.Enabled;

  for i := 0 to High(BottleChainConditions) do begin
    f := false;
    for j := 0 to FRule.Conditions.Count-1 do
      if FRule.Conditions[j].ClassType = BottleChainConditions[i] then begin
        f := true;
        lstCondition.Items[i] := (FRule.Conditions[j] as TBottleChainCondition).StringExpression;
        Break;
      end;
    lstCondition.Checked[i] := f;
    FConditionsCheckStatus[i] := f;
    if not f then
      lstCondition.Items[i] := BottleChainConditions[i].Title;
  end;

  for i := 0 to High(BottleChainActions) do begin
    f := false;
    for j := 0 to FRule.Actions.Count-1 do
      if FRule.Actions[j].ClassType = BottleChainActions[i] then begin
        f := true;
        lstAction.Items[i] := (FRule.Actions[j] as TBottleChainAction).StringExpression;
        Break;
      end;
    lstAction.Checked[i] := f;
    FActionsCheckStatus[i] := f;
    if not f then
      lstAction.Items[i] := BottleChainActions[i].Title;
  end;
end;

procedure TfrmBottleChainRuleEditor.btnOKClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrmBottleChainRuleEditor.InitializeDisplay;
var i: integer;
    ConditionClass: TBottleChainConditionClass;
    ActionClass: TBottleChainActionClass;
begin
  lstCondition.Items.Clear;
  for i := 0 to High(BottleChainConditions) do begin
    ConditionClass := BottleChainConditions[i];
    lstCondition.Items.Add(ConditionClass.Title);
  end;
  lstAction.Items.Clear;
  for i := 0 to High(BottleChainActions) do begin
    ActionClass := BottleChainActions[i];
    lstAction.Items.Add(ActionClass.Title);
  end;
end;

procedure TfrmBottleChainRuleEditor.lstConditionClickCheck(
  Sender: TObject);
var i: integer;
begin
  // ̂܂܂ƕsւȂ̂ŏ
  for i := 0 to High(BottleChainConditions) do begin
    if lstCondition.Checked[i] <> FConditionsCheckStatus[i] then
      lstConditionChecked(i, lstCondition.Checked[i]);
  end;
end;

procedure TfrmBottleChainRuleEditor.lstActionClickCheck(Sender: TObject);
var i: integer;
begin
  // ̂܂܂ƕsւȂ̂ŏ
  for i := 0 to High(BottleChainActions) do begin
    if lstAction.Checked[i] <> FActionsCheckStatus[i] then
      lstActionChecked(i, lstAction.Checked[i]);
  end;
end;

procedure TfrmBottleChainRuleEditor.lstActionChecked(Index: integer;
  Checked: boolean);
var Action: TBottleChainAction;
    i: integer;
begin
  if Checked then begin
    Action := BottleChainActions[Index].Create(BottleChainRuleList);
    Action.Rule := FRule;
    if Action.Edit then begin
    end else begin
      Action.Free;
      lstAction.Checked[Index] := false;
    end;
  end else begin
    for i := FRule.Actions.Count-1 downto 0 do begin
      if FRule.Actions[i].ClassType = BottleChainActions[Index] then
        FRule.Actions[i].Free;
    end;
  end;
  UpdateDisplay;
end;

procedure TfrmBottleChainRuleEditor.lstConditionChecked(Index: integer;
  Checked: boolean);
var Condition: TBottleChainCondition;
    i: integer;
begin
  if Checked then begin
    Condition := BottleChainConditions[Index].Create(BottleChainRuleList);
    Condition.Rule := FRule;
    if Condition.Edit then begin
    end else begin
      Condition.Free;
      lstCondition.Checked[Index] := false;
    end;
  end else begin
    for i := FRule.Conditions.Count-1 downto 0 do begin
      if FRule.Conditions[i].ClassType = BottleChainConditions[Index] then
        FRule.Conditions[i].Free;
    end;
  end;
  UpdateDisplay;
end;


procedure TfrmBottleChainRuleEditor.lstConditionDblClick(Sender: TObject);
var index, i: integer;
begin
  index := lstCondition.ItemIndex;
  if Index < 0 then Exit;
  if lstCondition.Checked[Index] then begin
    for i := 0 to FRule.Conditions.Count-1 do
      if FRule.Conditions[i].ClassType = BottleChainConditions[Index] then begin
        (FRule.Conditions[i] as TBottleChainCondition).Edit;
        Break;
      end;
  end else begin
    lstCondition.Checked[Index] := true;
    lstConditionChecked(Index, true);
  end;
  UpdateDisplay;
end;

procedure TfrmBottleChainRuleEditor.lstActionDblClick(Sender: TObject);
var index, i: integer;
begin
  index := lstAction.ItemIndex;
  if Index < 0 then Exit;
  if lstAction.Checked[Index] then begin
    for i := 0 to FRule.Actions.Count-1 do
      if FRule.Actions[i].ClassType = BottleChainActions[Index] then begin
        (FRule.Actions[i] as TBottleChainAction).Edit;
        Break;
      end;
  end else begin
    lstAction.Checked[Index] := true;
    lstActionChecked(Index, true);
  end;
  UpdateDisplay;
end;

procedure TfrmBottleChainRuleEditor.edtTitleChange(Sender: TObject);
begin
  FRule.Title := edtTitle.Text;
end;

procedure TfrmBottleChainRuleEditor.cbxRuleEnabledClick(Sender: TObject);
begin
  FRule.Enabled := cbxRuleEnabled.Checked;
end;

procedure TfrmBottleChainRuleEditor.Button1Click(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

end.
