unit BottleDef;

(*
  AvP[VŜŎg܂܂ȃf[^`
*)

interface

uses Windows, IniFiles, BRegExp, Graphics, SysUtils, Forms, Dialogs, Classes,
  ComCtrls, Contnrs, SsPlayTime, StrReplace;

type
  TReturnKeyFunction = (kfYenN, kfReturn, kfYenNReturn, kfConstText);
  TSoundArrived = (saFalse, saTrue, saParent);
  TLogWindowPreviewStyle = (psConversation, psImageConversation,
    psScript, psScriptWithLineBreak);
  TLogListPreviewStyle = (psNoColor, psNormal, psTagStripped);
  TSurfacePreviewOnScriptPointPosition = (spspMainWindowLeft, spspMainWindowRight);

  //SSTP Bottle̐ݒ
  TBottlePrefs = class(TObject)
  private
    FIni: TIniFile;
    //
    FIgnoreTimeCritical: boolean;
    FStayOnTop: boolean;
    FShowConstBar: boolean;
    FNoConfirm: boolean;
    FDblClkInsert: boolean;
    FShowToolBar: boolean;
    FDefaultScript: TStringList;
    FTalkColorH: TColor;
    FMetaWordColor: TColor;
    FTalkColorU: TColor;
    FMarkErrorColor: TColor;
    FMarkUpColor: TColor;
    FAutoStart: boolean;
    FCgiName: string;
    FHomePage: string;
    FWhenCtrlReturn: TReturnKeyFunction;
    FWhenShiftReturn: TReturnKeyFunction;
    FWhenReturn: TReturnKeyFunction;
    FNoTranslate: boolean;
    FNoDescript: boolean;
    FBgColor: TColor;
    FTextColor: TColor;
    FServerPort: integer;
    FSilentWhenHidden: boolean;
    FLUID: String;
    FSenderWindowPosition: TRect;
    FTabPosition: TTabPosition;
    FLogWindowPosition: TRect;
    FNoTransUrl: boolean;
    FIgnoreFrequentYenS: boolean;
    FWaitScriptEnd: integer;
    FMinScriptLength: integer;
    FCgiNameGhost: String;
    FGLogPage: String;
    FVotePage: String;
    FLogWindowDividerPos: integer;
    FHelpPage: String;
    FUseHttpProxy: boolean;
    FAskUseHttpProxy: boolean;
    FProxyPort: integer;
    FProxyAddress: String;
    FProxyNeedAuthentication: boolean;
    FProxyUser: String;
    FProxyPass: String;
    FConfirmOnExit: boolean;
    FFixMessySurface: boolean;
    FResetIfGhostAfterSend: boolean;
    FGhostDropDownCount: integer;
    FLogWindowPreviewStyle: TLogWindowPreviewStyle;
    FCgiFetchLog: String;
    FTalkColorS: TColor;
    FLogWindowColumnWidth: String;
    FClearAfterSend: boolean;
    FAutoJoinChannels: TStrings;
    FFMOName: TStrings;
    FHUTagTo01Tag: boolean;
    FWarnYenTNotExist: boolean;
    FWarnScopeChangeInSynchronize: boolean;
    FNeedConfirmBeforeSend: boolean;
    FShowRuler: boolean;
    FHideGhosts: boolean;
    FVisibleGhostsList: TStringList;
    FSurfacePreviewOnHint: boolean;
    FSurfacePreviewOnScriptPoint: boolean;
    FSurfacePreviewOnScriptPointPosition: TSurfacePreviewOnScriptPointPosition;
    FNoExtraSSTPHeaders: boolean;
    FLogListPreviewStyle: TLogListPreviewStyle;
    FEditorPreviewWindowPosition: TRect;
    FAutoClip: boolean;
    FConfirmOnTabClose: boolean;
    FReconnectWait: integer;
    FPartialConfirmFormat: String;
    FAutoPartialConfirm: boolean;
    FPlayTimeParams: TSsPlayTimeParams;
    FBottleServerPort: integer;
    FBottleServer: String;
    FTabWidth: integer;
    FBrowserExeName: string;
    FReplacePresets: TReplacePresets;
    FNoWarnOfEmptyFMO: Boolean;
    FShowEditorPreviewWindow: Boolean;
    FLogItemDragDrop: Boolean;

    procedure SetDblClkInsert(const Value: boolean);
    procedure SetDefaultScript(const Value: String);
    procedure SetIgnoreTimeCritical(const Value: boolean);
    procedure SetMarkErrorColor(const Value: TColor);
    procedure SetMarkUpColor(const Value: TColor);
    procedure SetMetaWordColor(const Value: TColor);
    procedure SetTextColor(const Value: TColor);
    procedure SetNoConfirm(const Value: boolean);
    procedure SetShowConstBar(const Value: boolean);
    procedure SetShowToolBar(const Value: boolean);
    procedure SetStayOnTop(const Value: boolean);
    procedure SetTalkColorH(const Value: TColor);
    procedure SetTalkColorU(const Value: TColor);
    procedure SetAutoStart(const Value: boolean);
    procedure SetWhenCtrlReturn(const Value: TReturnKeyFunction);
    procedure SetWhenReturn(const Value: TReturnKeyFunction);
    procedure SetWhenShiftReturn(const Value: TReturnKeyFunction);
    procedure SetNoTranslate(const Value: boolean);
    procedure SetNoDescript(const Value: boolean);
    procedure SetBgColor(const Value: TColor);
    procedure SetServerPort(const Value: integer);
    procedure SetSilentWhenHidden(const Value: boolean);
    procedure SetLUID(const Value: String);
    procedure SetSenderWindowPosition(const Value: TRect);
    procedure SetTabPosition(const Value: TTabPosition);
    procedure SetLogWindowPosition(const Value: TRect);
    procedure SetIgnoreFrequentYenS(const Value: boolean);
    procedure SetNoTransUrl(const Value: boolean);
    procedure SetWaitScriptEnd(const Value: integer);
    procedure SetMinScriptLength(const Value: integer);
    procedure SetLogWindowDividerPos(const Value: integer);
    procedure SetProxyAddress(const Value: String);
    procedure SetProxyPort(const Value: integer);
    procedure SetProxyUser(const Value: String);
    procedure SetProxyPass(const Value: String);
    procedure SetProxyNeedAuthentication(const Value: boolean);
    procedure SetUseHttpProxy(const Value: boolean);
    procedure SetAskUseHttpProxy(const Value: boolean);
    procedure SetConfirmOnExit(const Value: boolean);
    procedure SetFixMessySurface(const Value: boolean);
    procedure SetResetIfGhostAfterSend(const Value: boolean);
    procedure SetGhostDropDownCount(const Value: integer);
    procedure SetLogWindowPreviewStyle(const Value: TLogWindowPreviewStyle);
    procedure SetTalkColorS(const Value: TColor);
    procedure SetLogWindowColumnWidth(const Value: String);
    procedure SetClearAfterSend(const Value: boolean);
    procedure SetAutoJoinChannels(const Value: TStrings);
    procedure SetFMOName(const Value: TStrings);
    function GetDefaultScript: String;
    procedure SetHUTagTo01Tag(const Value: boolean);
    procedure SetWarnScopeChangeInSynchronize(const Value: boolean);
    procedure SetWarnYenTNotExist(const Value: boolean);
    procedure SetNeedConfirmBeforeSend(const Value: boolean);
    procedure SetShowRuler(const Value: boolean);
    procedure SetHideGhosts(const Value: boolean);
    procedure SetVisibleGhostsList(const Value: TStringList);
    procedure SetSurfacePreviewOnHint(const Value: boolean);
    procedure SetSurfacePreviewOnScriptPoint(const Value: boolean);
    procedure SetSurfacePreviewOnScriptPointPosition(
      const Value: TSurfacePreviewOnScriptPointPosition);
    procedure SetNoExtraSSTPHeaders(const Value: boolean);
    procedure SetLogListPreviewStyle(const Value: TLogListPreviewStyle);
    procedure SetEditorPreviewWindowPosition(const Value: TRect);
    procedure SetAutoClip(const Value: boolean);
    procedure SetConfirmOnTabClose(const Value: boolean);
    procedure SetReconnectWait(const Value: integer);
    procedure SetPartialConfirmFormat(const Value: String);
    procedure SetAutoPartialConfirm(const Value: boolean);
    procedure SetPlayTimeParams(const Value: TSsPlayTimeParams);
    procedure SetTabWidth(const Value: integer);
    procedure SetBrowserExeName(const Value: string);
  protected
    function InScreen(ARect: TRect): boolean;
  public
    property BottleServer: String read FBottleServer;
    property BottleServerPort: integer read FBottleServerPort;
    property PartialConfirmFormat: String read FPartialConfirmFormat write SetPartialConfirmFormat;
    property AutoPartialConfirm: boolean read FAutoPartialConfirm write SetAutoPartialConfirm;
    property ConfirmOnExit: boolean read FConfirmOnExit write SetConfirmOnExit;
    property ConfirmOnTabClose: boolean read FConfirmOnTabClose write SetConfirmOnTabClose;
    property AutoClip: boolean read FAutoClip write SetAutoClip;
    property AutoStart: boolean read FAutoStart write SetAutoStart;
    property TabPosition: TTabPosition read FTabPosition write SetTabPosition;
    property TabWidth: integer read FTabWidth write SetTabWidth;
    property GhostDropDownCount: integer read FGhostDropDownCount write SetGhostDropDownCount;
    property NoTranslate: boolean read FNoTranslate write SetNoTranslate;
    property NoDescript: boolean read FNoDescript write SetNoDescript;
    property NoTransUrl: boolean read FNoTransUrl write SetNoTransUrl;
    property SilentWhenHidden: boolean read FSilentWhenHidden write SetSilentWhenHidden;
    property FixMessySurface: boolean read FFixMessySurface write SetFixMessySurface;
    property HUTagTo01Tag: boolean read FHUTagTo01Tag write SetHUTagTo01Tag;
    property ResetIfGhostAfterSend: boolean read FResetIfGhostAfterSend write SetResetIfGhostAfterSend;
    property ClearAfterSend: boolean read FClearAfterSend write SetClearAfterSend;
    property NeedConfirmBeforeSend: boolean read FNeedConfirmBeforeSend write SetNeedConfirmBeforeSend;
    property IgnoreFrequentYenS: boolean read FIgnoreFrequentYenS write SetIgnoreFrequentYenS;
    property WarnYenTNotExist: boolean read FWarnYenTNotExist write SetWarnYenTNotExist;
    property WarnScopeChangeInSynchronize: boolean read FWarnScopeChangeInSynchronize write SetWarnScopeChangeInSynchronize;
    property WaitScriptEnd: integer read FWaitScriptEnd write SetWaitScriptEnd;
    property MinScriptLength: integer read FMinScriptLength write SetMinScriptLength;
    property StayOnTop: boolean read FStayOnTop write SetStayOnTop;
    property IgnoreTimeCritical: boolean read FIgnoreTimeCritical write SetIgnoreTimeCritical;
    property TalkColorH: TColor read FTalkColorH write SetTalkColorH;
    property TalkColorU: TColor read FTalkColorU write SetTalkColorU;
    property TalkColorS: TColor read FTalkColorS write SetTalkColorS;
    property MarkUpColor: TColor read FMarkUpColor write SetMarkUpColor;
    property MetaWordColor: TColor read FMetaWordColor write SetMetaWordColor;
    property MarkErrorColor: TColor read FMarkErrorColor write SetMarkErrorColor;
    property BgColor: TColor read FBgColor write SetBgColor;
    property TextColor: TColor read FTextColor write SetTextColor;
    property DefaultScript: String read GetDefaultScript write SetDefaultScript;
    property ShowRuler: boolean read FShowRuler write SetShowRuler;
    property DblClkInsert: boolean read FDblClkInsert write SetDblClkInsert;
    property ShowToolBar: boolean read FShowToolBar write SetShowToolBar;
    property ShowConstBar: boolean read FShowConstBar write SetShowConstBar;
    property NoConfirm: boolean read FNoConfirm write SetNoConfirm;
    property HomePage: string read FHomePage;
    property WhenReturn: TReturnKeyFunction read FWhenReturn write SetWhenReturn;
    property WhenShiftReturn: TReturnKeyFunction read FWhenShiftReturn write SetWhenShiftReturn;
    property WhenCtrlReturn: TReturnKeyFunction read FWhenCtrlReturn write SetWhenCtrlReturn;
    property ServerPort: integer read FServerPort write SetServerPort;
    //URL֌W
    property CgiName: string read FCgiName;
    property CgiNameGhost: String read FCgiNameGhost;
    property CgiFetchLog: String read FCgiFetchLog;
    property GLogPage: String read FGLogPage;
    property VotePage: String read FVotePage;
    property HelpPage: String read FHelpPage;

    //`l֌W
    property AutoJoinChannels: TStrings read FAutoJoinChannels write SetAutoJoinChannels;

    property LUID: String read FLUID write SetLUID;

    //EBhEʒu
    property SenderWindowPosition: TRect
      read FSenderWindowPosition write SetSenderWindowPosition;
    property LogWindowPosition: TRect read FLogWindowPosition write SetLogWindowPosition;
    property LogWindowDividerPos: integer
      read FLogWindowDividerPos write SetLogWindowDividerPos;
    property LogWindowColumnWidth: String
      read FLogWindowColumnWidth write SetLogWindowColumnWidth;
    property EditorPreviewWindowPosition: TRect read FEditorPreviewWindowPosition write SetEditorPreviewWindowPosition;
    //vLV֌W
    property UseHttpProxy: boolean read FUseHttpProxy write SetUseHttpProxy;
    property AskUseHttpProxy: boolean read FAskUseHttpProxy write SetAskUseHttpProxy;
    property ProxyAddress: String read FProxyAddress write SetProxyAddress;
    property ProxyPort: integer read FProxyPort write SetProxyPort;
    property ProxyUser: String read FProxyUser write SetProxyUser;
    property ProxyPass: String read FProxyPass write SetProxyPass;
    property ProxyNeedAuthentication: boolean read FProxyNeedAuthentication write SetProxyNeedAuthentication;
    //Đڑ
    property ReconnectWait: integer read FReconnectWait write SetReconnectWait;
    //OEBhE֌W
    property LogWindowPreviewStyle: TLogWindowPreviewStyle
      read FLogWindowPreviewStyle write SetLogWindowPreviewStyle;
    property LogListPreviewStyle: TLogListPreviewStyle
      read FLogListPreviewStyle write SetLogListPreviewStyle;
    //ڍאݒ
    property FMOName: TStrings read FFMOName write SetFMOName;
    property HideGhosts: boolean read FHideGhosts write SetHideGhosts;
    property VisibleGhostsList: TStringList read FVisibleGhostsList write SetVisibleGhostsList;
    property NoExtraSSTPHeaders: boolean read FNoExtraSSTPHeaders write SetNoExtraSSTPHeaders;
    //T[tBXvr[
    property SurfacePreviewOnHint: boolean
      read FSurfacePreviewOnHint write SetSurfacePreviewOnHint;
    property SurfacePreviewOnScriptPoint: boolean
      read FSurfacePreviewOnScriptPoint write SetSurfacePreviewOnScriptPoint;
    property SurfacePreviewOnScriptPointPosition: TSurfacePreviewOnScriptPointPosition
      read FSurfacePreviewOnScriptPointPosition write SetSurfacePreviewOnScriptPointPosition;
    //Đԗ\
    property PlayTimeParams: TSsPlayTimeParams read FPlayTimeParams write SetPlayTimeParams;
    //URLI[vɎguEU̎st@C
    property BrowserExeName: string read FBrowserExeName write SetBrowserExeName;
    //uvZbg
    property ReplacePresets: TReplacePresets read FReplacePresets;
    //SSTPT[o񑶍݌x̃Jbg邩
    property NoWarnOfEmptyFMO: Boolean
      read FNoWarnOfEmptyFMO write FNoWarnOfEmptyFMO;
    //GfB^vr[EChȄԕۑp
    property ShowEditorPreviewWindow: Boolean
      read FShowEditorPreviewWindow write FShowEditorPreviewWindow;
    //OhbOhbvL
    property LogItemDragDrop: Boolean
      read FLogItemDragDrop write FLogItemDragDrop;

    //RXgN^EfXgN^Eۑ
    constructor Create;
    destructor Destroy; override;
    procedure SaveSettings;
  end;

  TChannelListItem = class(TObject)
  private
    FMembers: integer;
    FGhost: String;
    FInfo: String;
    FName: String;
    FNoPost: boolean;
    FWarnPost: boolean;
    procedure SetGhost(const Value: String);
    procedure SetInfo(const Value: String);
    procedure SetMembers(const Value: integer);
    procedure SetName(const Value: String);
    procedure SetNoPost(const Value: boolean);
    procedure SetWarnPost(const Value: boolean);
  public
    property Name: String read FName write SetName;
    property Info: String read FInfo write SetInfo;
    property Ghost: String read FGhost write SetGhost;
    property Members: integer read FMembers write SetMembers;
    property NoPost: boolean read FNoPost write SetNoPost;
    property WarnPost: boolean read FWarnPost write SetWarnPost;
  end;

  TChannelList = class(TList)
  private
    function GetChannel(Name: String): TChannelListItem;
    function GetChannelItem(Index: integer): TChannelListItem;
  public
    procedure Clear; override;
    property Channel[Name: String]: TChannelListItem read GetChannel;
    property ChannelItem[Index: integer]: TChannelListItem read GetChannelItem;
  end;

  TScriptTransOption = (
    toIgnoreTimeCritical,
    toConvertURL,
    toNoChoice,
    toIgnoreFrequentYenS,
    toWaitScriptEnd,
    toFixMessySurface,
    toWarnMessySurface,
    toHUTagTo01Tag,
    toWarnCheck
  );

  TScriptTransOptions = set of TScriptTransOption;

var
  Pref: TBottlePrefs;
  ChannelList: TChannelList; //`lXgێ
  JoinChannels: TStringList; // ݎQĂ`l

const
  DefaultBottleServer    = 'bottle.mikage.to';
  DefaultBottleServerPort = 9871;
  DefaultCGI      = '/bottle2.cgi';
  DefaultCGIGhost = '/glog/bottleglog.cgi';
  DefaultCGIFetchLog = '/fetchlog.cgi';


  DefaultHomePage = 'http://bottle.mikage.to/';
  DefaultGLogPage = 'http://bottle.mikage.to/glog/glogview.cgi';
  DefaultVotePage = 'http://bottle.mikage.to/viewvotes.cgi';
  DefaultHelpPage = 'http://bottle.mikage.to/clihelp/index.html';

  DefaultMinScriptLength = 20;

  Version = '2.75';

  {$IFDEF NOMUTEX}
  VersionString = 'SSTP Bottle Client ver ' + Version + 'a NO MUTEX VERSION';
  {$ELSE}
  VersionString = 'SSTP Bottle Client ver ' + Version;
  {$ENDIF}

  SentLogFile     = 'sent.log';

  BottleDisclaimer = '(C)2001-2006 WinBottle Project'#13#10 +
    'naru, C.Ponapalt, Yune Kotomi, yese, Mikage Sawatari, E01'#13#10 +
    DefaultHomePage;

  ChannelDefault = '(CH)';
  ClipChannel    = '(Nbv)'; 

function ParamsEncode(const ASrc: string): string;
function XMLEntity(From: String): String;
function SafeFileName(From: String; ChangePathDelimiters: boolean = true): String;
function ComponentToString(Component: TComponent): string;
function StringToComponent(Value: string): TComponent;

function ReplacePresetFileName: string;

procedure BuildShortCutList(Target: TStrings);

implementation

function ParamsEncode(const ASrc: string): string;
var
  i: Integer;
const
  UnsafeChars = ['*', '#', '%', '<', '>', ' ', '[', ']', '+'];
begin
  Result := '';    {Do not Localize}
  for i := 1 to Length(ASrc) do
  begin
    if (ASrc[i] in UnsafeChars) or (not (ord(ASrc[i])in [33..128])) then
    begin {do not localize}
      Result := Result + '%' + IntToHex(Ord(ASrc[i]), 2);  {do not localize}
    end
    else
    begin
      Result := Result + ASrc[i];
    end;
  end;
end;

// XML̎QƂɒu
function XMLEntity(From: String): String;
var
  i: integer;
  InLead: boolean;
begin
  InLead := false;
  Result := '';
  for i := 1 to Length(From) do
  begin
    if InLead then
    begin
      InLead := false;
      Result := Result + From[i];
    end else if From[i] in LeadBytes then
    begin
      InLead := true;
      Result := Result + From[i];
    end else
    begin
      case Ord(From[i]) of
        60: Result := Result + '&lt;'; // Less than
        62: Result := Result + '&gt;'; // Greater than
        38: Result := Result + '&amp;'; // Ampersand
        39: Result := Result + '&#39;'; // Single quote
        34: Result := Result + '&quot;'; // Double quote
        else
          Result := Result + From[i];
      end;
    end;
  end;
end;

// Escape characters which can not be used as a filename
function SafeFileName(From: String; ChangePathDelimiters: boolean = true): String;
begin
  Result := StringReplace(From, '*', '', [rfReplaceAll]);
  Result := StringReplace(Result, '|', 'b', [rfReplaceAll]);
  Result := StringReplace(Result, '"', '''''', [rfReplaceAll]);
  Result := StringReplace(Result, '<', '', [rfReplaceAll]);
  Result := StringReplace(Result, '>', '', [rfReplaceAll]);
  Result := StringReplace(Result, '?', 'H', [rfReplaceAll]);
  if ChangePathDelimiters then
  begin
    Result := StringReplace(Result, '\', '', [rfReplaceAll]);
    Result := StringReplace(Result, ':', 'F', [rfReplaceAll]);
    Result := StringReplace(Result, '/', '^', [rfReplaceAll]);
  end;
end;

function ComponentToString(Component: TComponent): string;
var
  BinStream:TMemoryStream;
  StrStream: TStringStream;
  s: string;
begin
  BinStream := TMemoryStream.Create;
  try
    StrStream := TStringStream.Create(s);
    try
      BinStream.WriteComponent(Component);
      BinStream.Seek(0, soFromBeginning);
      ObjectBinaryToText(BinStream, StrStream);
      StrStream.Seek(0, soFromBeginning);
      Result:= StrStream.DataString;
    finally
      StrStream.Free;
    end;
  finally
    BinStream.Free
  end;
end;

function StringToComponent(Value: string): TComponent;
var
  StrStream:TStringStream;
  BinStream: TMemoryStream;
begin
  StrStream := TStringStream.Create(Value);
  try
    BinStream := TMemoryStream.Create;
    try
      ObjectTextToBinary(StrStream, BinStream);
      BinStream.Seek(0, soFromBeginning);
      Result := BinStream.ReadComponent(nil);
    finally
      BinStream.Free;
    end;
  finally
    StrStream.Free;
  end;
end;

function ReplacePresetFileName: string;
begin
  Result := ExtractFilePath(Application.ExeName) + 'replace.txt';
end;

procedure BuildShortCutList(Target: TStrings);
var
  c: Char;
  i: Integer;
begin
  // V[gJbgXg̑I쐬
  with Target do
  begin
    BeginUpdate;
    try
      for c := 'A' to 'Z' do
        Add('Ctrl+' + c);
      for c := 'A' to 'Z' do
        Add('Shift+Ctrl+' + c);
      for c := 'A' to 'Z' do
        Add('Alt+Ctrl+' + c);
      for i := 1 to 12 do
        Add('F' + IntToStr(i));
      for i := 1 to 12 do
        Add('Shift+F' + IntToStr(i));
    finally
      EndUpdate;
    end;
  end;
end;

{ TBottlePrefs }

constructor TBottlePrefs.Create;
var ARect: TRect;
    Strs: TStringList;
begin
  FAutoJoinChannels := TStringList.Create;
  FDefaultScript := TStringList.Create;
  FFMOName := TStringList.Create;
  FVisibleGhostsList := TStringList.Create;
  try
    FIni := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
    //
    PartialConfirmFormat := FIni.ReadString('System', 'PartialConfirmFormat', '\t|\e');
    AutoPartialConfirm := FIni.ReadBool('System', 'AutoPartialConfirm', false);
    ConfirmOnExit := FIni.ReadBool('System', 'ConfirmOnExit', false);
    ConfirmOnTabClose := FIni.ReadBool('System', 'ConfirmOnTabClose', false);
    NoWarnOfEmptyFMO := FIni.ReadBool('System', 'NoWarnOfEmptyFMO', False);
    ShowEditorPreviewWindow := FIni.ReadBool('System', 'ShowEditorPreviewWindow', False);
    LogItemDragDrop := FIni.ReadBool('System', 'LogItemDragDrop', True);

    AutoClip := FIni.ReadBool('System', 'AutoClip', false);
    AutoStart := FIni.ReadBool('System', 'AutoStart', false);
    TabPosition := TTabPosition(FIni.ReadInteger('System', 'TabPosition', 0));
    TabWidth := FIni.ReadInteger('System', 'TabWidth', 0);
    GhostDropDownCount := FIni.ReadInteger('System', 'GhostDropDownCount', 30);

    NoTranslate := FIni.ReadBool('System', 'NoTranslate', true);
    NoDescript := FIni.ReadBool('System', 'NoDescript', false);
    NoTransUrl := FIni.ReadBool('System', 'NoTransUrl', false);
    SilentWhenHidden:= FIni.ReadBool('System', 'SilentWhenHidden', true);
    FixMessySurface := FIni.ReadBool('System', 'FixMessySurface', false);
    HUTagTo01Tag := FIni.ReadBool('System', 'HUTagTo01Tag', false);
    ResetIfGhostAfterSend := FIni.ReadBool('System', 'ResetIfGhostAfterSend', false);
    ClearAfterSend := FIni.ReadBool('System', 'ClearAfterSend', true);
    NeedConfirmBeforeSend := FIni.ReadBool('System', 'NeedConfirmBeforeSend', true);
    WarnYenTNotExist := FIni.ReadBool('System', 'WarnYenTNotExist', false);
    WarnScopeChangeInSynchronize := FIni.ReadBool('System', 'WarnScopeChangeInSynchronize', false);

    IgnoreFrequentYenS := FIni.ReadBool('System', 'IgnoreFrequentYenS', false);
    WaitScriptEnd := FIni.ReadInteger('System', 'WaitScriptEnd', 0);
    MinScriptLength := FIni.ReadInteger('System', 'MinScriptLength', DefaultMinScriptLength);
    StayOnTop := FIni.ReadBool('System', 'StayOnTop', false);
    ShowConstBar := FIni.ReadBool('System', 'ShowConstBar', true);
    ShowToolBar := FIni.ReadBool('System', 'ShowToolBar', true);
    NoConfirm := FIni.ReadBool('System', 'NoConfirm', false);
    IgnoreTimeCritical := FIni.ReadBool('System', 'IgnoreTimeCritical', false);
    FDefaultScript.CommaText := FIni.ReadString('System', 'DefaultScript', '\t\u\s[10]\h\s[0]|\e');
    ShowRuler := FIni.ReadBool('System', 'ShowRuler', false);
    //
    try
      TalkColorH := StringToColor(FIni.ReadString('System', 'TalkColorH', 'clBlack'));
      TalkColorU := StringToColor(FIni.ReadString('System', 'TalkColorU', 'clMaroon'));
      TalkColorS := StringToColor(FIni.ReadString('System', 'TalkColorS', 'clPurple'));
      MarkUpColor := StringToColor(FIni.ReadString('System', 'MarkUpColor', 'clGreen'));
      MetaWordColor := StringToColor(FIni.ReadString('System', 'MetaWordColor', 'clBlue'));
      MarkErrorColor := StringToColor(FIni.ReadString('System', 'MarkErrorColor', 'clRed'));
      TextColor := StringToColor(FIni.ReadString('System', 'TextColor', ColorToString(TalkColorH)));
      BgColor := StringToColor(FIni.ReadString('System', 'BgColor', 'clWhite'));
    except
      on EConvertError do begin
        ShowMessage('J[̐ݒǂݍ݃G[');
        FTalkColorH := clBlack;
        FTalkColorU := clMaroon;
        FMarkUpColor := clGreen;
        FMetaWordColor := clBlue;
        FMarkErrorColor := clRed;
        FTextColor := clBlack;
      end;
    end;

    try
      if FIni.ReadString('System', 'PlayTimeParams', '') = '' then
      begin
        FPlayTimeParams := TSsPlayTimeParams.Create(nil);
        FPlayTimeParams.ProfileName := 'ftHg';
      end else
      begin
        Strs := TStringList.Create;
        try
          Strs.CommaText := FIni.ReadString('System', 'PlayTimeParams', '');
          FPlayTimeParams := StringToComponent(Strs.Text) as TSsPlayTimeParams;
        finally
          Strs.Free;
        end;
      end;
    except
      on E: Exception do
      begin
        ShowMessage('Đԗ\ݒ̓ǂݍ݃G[' + E.Message);
        if FPlayTimeParams = nil then
          FPlayTimeParams := TSsPlayTimeParams.Create(nil);
      end;
    end;

    WhenReturn      := TReturnKeyFunction(FIni.ReadInteger('System', 'WhenReturn', 0));
    WhenShiftReturn := TReturnKeyFunction(FIni.ReadInteger('System', 'WhenShiftReturn', 0));
    WhenCtrlReturn  := TReturnKeyFunction(FIni.ReadInteger('System', 'WhenCtrlReturn', 0));
    //\Pbg{gzSSTPʐMɎgpꍇ̐ݒ
    ServerPort      := FIni.ReadInteger('System', 'ServerPort', 11000);

    FBottleServer := FIni.ReadString('System', 'BottleServer', DefaultBottleServer);
    FBottleServerPort := FIni.ReadInteger('System', 'BottleServerPort', DefaultBottleServerPort);
    FCgiName  := FIni.ReadString('System', 'CgiName', DefaultCGI);
    FCgiFetchLog := FIni.ReadString('System', 'CgiFetchLog', DefaultCGIFetchLog);
    FHomePage := FIni.ReadString('System', 'HomePage', DefaultHomePage);
    FGLogPage := FIni.ReadString('System', 'GLogPage', DefaultGLogPage);
    FVotePage := FIni.ReadString('System', 'VotePage', DefaultVotePage);
    FHelpPage := FIni.ReadString('System', 'HelpPage', DefaultHelpPage);
    FCgiNameGhost := FIni.ReadString('System', 'GHOST', DefaultCGIGhost);
    FLUID     := FIni.ReadString('System', 'LUID', '');
    FAutoJoinChannels.CommaText := FIni.ReadString('System', 'AutoJoinChannels', '');
    //
    ARect.Top    := FIni.ReadInteger('System', 'SenderWindowPositionTop', 100);
    ARect.Left   := FIni.ReadInteger('System', 'SenderWindowPositionLeft', 100);
    ARect.Bottom := FIni.ReadInteger('System', 'SenderWindowPositionBottom', 500);
    ARect.Right  := FIni.ReadInteger('System', 'SenderWindowPositionRight', 500);
    if not InScreen(ARect) then
      ARect := Rect(100, 100, 500, 500);
    SenderWindowPosition := ARect;
    ARect.Top    := FIni.ReadInteger('System', 'LogWindowPositionTop', 200);
    ARect.Left   := FIni.ReadInteger('System', 'LogWindowPositionLeft', 200);
    ARect.Bottom := FIni.ReadInteger('System', 'LogWindowPositionBottom', 600);
    ARect.Right  := FIni.ReadInteger('System', 'LogWindowPositionRight', 400);
    LogWindowDividerPos := FIni.ReadInteger('System', 'LogWindowDividerPos', 150);
    LogWindowColumnWidth := FIni.ReadString('System', 'LogWindowColumnWidth', '');
    if not InScreen(ARect) then begin
      ARect := Rect(200, 200, 600, 400);
      LogWindowDividerPos := 150;
    end;
    LogWindowPosition := ARect;
    Strs := TStringList.Create;
    try
      Strs.CommaText := FIni.ReadString('System', 'EditorPreviewWindowPosition', '500,100,800,500');
      try
        ARect.Left   := StrToInt(Strs[0]);
        ARect.Top    := StrToInt(Strs[1]);
        ARect.Right  := StrToInt(Strs[2]);
        ARect.Bottom := StrToInt(Strs[3]);
      except
        ARect := Rect(500, 100, 800, 500);
      end;
      EditorPreviewWindowPosition := ARect;
    finally
      Strs.Free;
    end;
    //
    UseHttpProxy := FIni.ReadBool('System', 'UseHttpProxy', false);
    AskUseHttpProxy := FIni.ReadBool('System', 'AskUseHttpProxy', false);
    ProxyAddress := FIni.ReadString('System', 'ProxyAddress', '');
    ProxyPort    := FIni.ReadInteger('System', 'ProxyPort', 0);
    ProxyUser    := FIni.ReadString('System', 'ProxyUser', '');
    ProxyPass    := FIni.ReadString('System', 'ProxyPass', '');
    ProxyNeedAuthentication := FIni.ReadBool('System', 'ProxyNeedAuthentication', false);
    //
    ReconnectWait := FIni.ReadInteger('System', 'ReconnectWait', 6);
    //OEBhE֌W
    LogWindowPreviewStyle := TLogWindowPreviewStyle(
      FIni.ReadInteger('System', 'LogWindowPreviewStyle', 0));
    LogListPreviewStyle := TLogListPreviewStyle(
      FIni.ReadInteger('System', 'LogListPreviewStyle', 0));
    //ڍ
    FMOName.CommaText := FIni.ReadString('System', 'FMOName', 'Sakura');
    HideGhosts := FIni.ReadBool('System', 'HideGhosts', false);
    VisibleGhostsList.CommaText := FIni.ReadString('System', 'VisibleGhostsList', '');
    NoExtraSSTPHeaders := FIni.ReadBool('System', 'NoExtraSSTPHeaders', false);
    //T[tBXvr[
    SurfacePreviewOnHint := FIni.ReadBool('System', 'SurfacePreviewOnHint', false);
    SurfacePreviewOnScriptPoint := FIni.ReadBool('System', 'SurfacePreviewOnScriptPoint', false);
    SurfacePreviewOnScriptPointPosition :=
      TSurfacePreviewOnScriptPointPosition(FIni.ReadInteger('System', 'SurfacePreviewOnScriptPointPosition', 0));

    //URLJuEU
    FBrowserExeName:= FIni.ReadString('System', 'BrowserExeName', '');

    //uvZbg
    if FileExists(ReplacePresetFileName) then
    begin
      try
        Strs := TStringList.Create;
        try
          Strs.LoadFromFile(ReplacePresetFileName);
          FReplacePresets := StringToComponent(Strs.Text) as TReplacePresets;
        finally
          Strs.Free;
        end;
      except
        ShowMessage('Replace.txtǂݍݒ̃G[B'#13#10+
          't@CjĂꍇ́Ãt@C폜čċNĂ');
        raise;
      end;
    end else
      FReplacePresets := TReplacePresets.Create(nil);
  except
    on E: Exception do
    begin
      ShowMessage('ݒǂݍ݃G['#13#10 + E.Message);
      Application.Terminate;
    end;
  end;
end;

destructor TBottlePrefs.Destroy;
begin
  inherited;
  SaveSettings;
  if FReplacePresets <> nil then
    FReplacePresets.Free;
  if FIni <> nil then
    FIni.Free;
  if FAutoJoinChannels <> nil then
    FAutoJoinChannels.Free;
  if FDefaultScript <> nil then
    FDefaultScript.Free;
  if FFMOName <> nil then
    FFMOName.Free;
  if FVisibleGhostsList <> nil then
    FVisibleGhostsList.Free;
  if FPlayTimeParams <> nil then
    FPlayTimeParams.Free;
end;

procedure TBottlePrefs.SetAutoStart(const Value: boolean);
begin
  FAutoStart := Value;
end;

procedure TBottlePrefs.SetBgColor(const Value: TColor);
begin
  FBgColor := Value;
end;

procedure TBottlePrefs.SetConfirmOnExit(const Value: boolean);
begin
  FConfirmOnExit := Value;
end;

procedure TBottlePrefs.SetDblClkInsert(const Value: boolean);
begin
  FDblClkInsert := Value;
end;

procedure TBottlePrefs.SetDefaultScript(const Value: String);
begin
  FDefaultScript.Text := Value;
end;

procedure TBottlePrefs.SetFixMessySurface(const Value: boolean);
begin
  FFixMessySurface := Value;
end;

procedure TBottlePrefs.SetGhostDropDownCount(const Value: integer);
begin
  FGhostDropDownCount := Value;
end;

procedure TBottlePrefs.SetIgnoreFrequentYenS(const Value: boolean);
begin
  FIgnoreFrequentYenS := Value;
end;

procedure TBottlePrefs.SetIgnoreTimeCritical(const Value: boolean);
begin
  FIgnoreTimeCritical := Value;
end;

procedure TBottlePrefs.SetLogWindowDividerPos(const Value: integer);
begin
  FLogWindowDividerPos := Value;
end;

procedure TBottlePrefs.SetLogWindowPosition(const Value: TRect);
begin
  FLogWindowPosition := Value;
end;

procedure TBottlePrefs.SetLUID(const Value: String);
begin
  FLUID := Value;
end;

procedure TBottlePrefs.SetMarkErrorColor(const Value: TColor);
begin
  FMarkErrorColor := Value;
end;

procedure TBottlePrefs.SetTextColor(const Value: TColor);
begin
  FTextColor := Value;
end;

procedure TBottlePrefs.SetMarkUpColor(const Value: TColor);
begin
  FMarkUpColor := Value;
end;

procedure TBottlePrefs.SetMetaWordColor(const Value: TColor);
begin
  FMetaWordColor := Value;
end;

procedure TBottlePrefs.SetNoConfirm(const Value: boolean);
begin
  FNoConfirm := Value;
end;

procedure TBottlePrefs.SetNoDescript(const Value: boolean);
begin
  FNoDescript := Value;
end;

procedure TBottlePrefs.SetNoTranslate(const Value: boolean);
begin
  FNoTranslate := Value;
end;

procedure TBottlePrefs.SetNoTransUrl(const Value: boolean);
begin
  FNoTransUrl := Value;
end;

procedure TBottlePrefs.SetLogWindowPreviewStyle(
  const Value: TLogWindowPreviewStyle);
begin
  FLogWindowPreviewStyle := Value;
end;

procedure TBottlePrefs.SetProxyAddress(const Value: String);
begin
  FProxyAddress := Value;
end;

procedure TBottlePrefs.SetProxyPort(const Value: integer);
begin
  FProxyPort := Value;
end;

procedure TBottlePrefs.SetProxyNeedAuthentication(const Value: boolean);
begin
  FProxyNeedAuthentication := Value;
end;

procedure TBottlePrefs.SetProxyPass(const Value: String);
begin
  FProxyPass := Value;
end;

procedure TBottlePrefs.SetProxyUser(const Value: String);
begin
  FProxyUser := Value;
end;

procedure TBottlePrefs.SetResetIfGhostAfterSend(const Value: boolean);
begin
  FResetIfGhostAfterSend := Value;
end;

procedure TBottlePrefs.SetSenderWindowPosition(const Value: TRect);
begin
  FSenderWindowPosition := Value;
end;

procedure TBottlePrefs.SetServerPort(const Value: integer);
begin
  if Value > 0 then FServerPort := Value;
end;

procedure TBottlePrefs.SetShowConstBar(const Value: boolean);
begin
  FShowConstBar := Value;
end;

procedure TBottlePrefs.SetShowToolBar(const Value: boolean);
begin
  FShowToolBar := Value;
end;

procedure TBottlePrefs.SetSilentWhenHidden(const Value: boolean);
begin
  FSilentWhenHidden := Value;
end;

procedure TBottlePrefs.SetStayOnTop(const Value: boolean);
begin
  FStayOnTop := Value;
end;

procedure TBottlePrefs.SetTabPosition(const Value: TTabPosition);
begin
  FTabPosition := Value;
end;

procedure TBottlePrefs.SetTalkColorH(const Value: TColor);
begin
  FTalkColorH := Value;
end;

procedure TBottlePrefs.SetTalkColorU(const Value: TColor);
begin
  FTalkColorU := Value;
end;

procedure TBottlePrefs.SetUseHttpProxy(const Value: boolean);
begin
  FUseHttpProxy := Value;
end;

procedure TBottlePrefs.SetAskUseHttpProxy(const Value: boolean);
begin
  FAskUseHttpProxy := Value;
end;

procedure TBottlePrefs.SetWaitScriptEnd(const Value: integer);
begin
  if Value > 0 then FWaitScriptEnd := Value;
end;

procedure TBottlePrefs.SetMinScriptLength(const Value: integer);
begin
  if Value >= DefaultMinScriptLength then FMinScriptLength := Value;
end;

procedure TBottlePrefs.SetWhenCtrlReturn(const Value: TReturnKeyFunction);
begin
  FWhenCtrlReturn := Value;
end;

procedure TBottlePrefs.SetWhenReturn(const Value: TReturnKeyFunction);
begin
  FWhenReturn := Value;
end;

procedure TBottlePrefs.SetWhenShiftReturn(const Value: TReturnKeyFunction);
begin
  FWhenShiftReturn := Value;
end;

procedure TBottlePrefs.SetTalkColorS(const Value: TColor);
begin
  FTalkColorS := Value;
end;

procedure TBottlePrefs.SetLogWindowColumnWidth(const Value: String);
begin
  FLogWindowColumnWidth := Value;
end;

procedure TBottlePrefs.SetClearAfterSend(const Value: boolean);
begin
  FClearAfterSend := Value;
end;

procedure TBottlePrefs.SetAutoJoinChannels(const Value: TStrings);
begin
  FAutoJoinChannels.Assign(Value);
end;

procedure TBottlePrefs.SetFMOName(const Value: TStrings);
begin
  FFMOName.Assign(Value);
end;

procedure TBottlePrefs.SaveSettings;
var
  Strs: TStringList;
begin
  FIni.WriteString('System', 'PartialConfirmFormat', PartialConfirmFormat);
  FIni.WriteBool('System', 'AutoPartialConfirm', AutoPartialConfirm);
  FIni.WriteBool('System', 'ConfirmOnExit', ConfirmOnExit);
  FIni.WriteBool('System', 'ConfirmOnTabClose', ConfirmOnTabClose);
  FIni.WriteBool('System', 'AutoClip', AutoClip);
  FIni.WriteBool('System', 'AutoStart', AutoStart);
  FIni.WriteInteger('System', 'TabPosition', Ord(TabPosition));
  FIni.WriteInteger('System', 'TabWidth', TabWidth);
  FIni.WriteInteger('System', 'GhostDropDownCount', GhostDropDownCount);

  FIni.WriteBool('System', 'NoTranslate', NoTranslate);
  FIni.WriteBool('System', 'NoDescript', NoDescript);
  FIni.WriteBool('System', 'NoTransUrl', NoTransUrl);
  FIni.WriteBool('System', 'SilentWhenHidden', SilentWhenHidden);
  FIni.WriteBool('System', 'FixMessySurface', FixMessySurface);
  FIni.WriteBool('System', 'HUTagTo01Tag', HUTagTo01Tag);
  FIni.WriteBool('System', 'ResetIfGhostAfterSend', ResetIfGhostAfterSend);
  FIni.WriteBool('System', 'ClearAfterSend', ClearAfterSend);
  FIni.WriteBool('System', 'NeedConfirmBeforeSend', NeedConfirmBeforeSend);
  FIni.WriteBool('System', 'WarnYenTNotExist', WarnYenTNotExist);
  FIni.WriteBool('System', 'WarnScopeChangeInSynchronize', WarnScopeChangeInSynchronize);

  FIni.WriteBool('System', 'IgnoreFrequentYenS', IgnoreFrequentYenS);
  FIni.WriteInteger('System', 'WaitScriptEnd', WaitScriptEnd);
  FIni.WriteInteger('System', 'MinScriptLength', MinScriptLength);
  FIni.WriteBool('System', 'StayOnTop', StayOnTop);
  FIni.WriteBool('System', 'NoConfirm', NoConfirm);
  FIni.WriteBool('System', 'IgnoreTimeCritical', IgnoreTimeCritical);
  FIni.WriteString('System', 'TalkColorH',     ColorToString(TalkColorH));
  FIni.WriteString('System', 'TalkColorU',     ColorToString(TalkColorU));
  FIni.WriteString('System', 'TalkColorS',     ColorToString(TalkColorS));
  FIni.WriteString('System', 'MarkUpColor',    ColorToString(MarkUpColor));
  FIni.WriteString('System', 'MetaWordColor',  ColorToString(MetaWordColor));
  FIni.WriteString('System', 'MarkErrorColor', ColorToString(MarkErrorColor));
  FIni.WriteString('System', 'TextColor', ColorToString(TextColor));

  Strs := TStringList.Create;
  try
    Strs.Text := ComponentToString(FPlayTimeParams);
    FIni.WriteString('System', 'PlayTimeParams', Strs.CommaText);
  finally
    Strs.Free;
  end;

  FIni.WriteString('System', 'BgColor', ColorToString(BgColor));
  FIni.WriteBool('System', 'ShowToolBar', ShowToolBar);
  FIni.WriteBool('System', 'ShowConstBar', ShowConstBar);
  FIni.WriteString('System', 'DefaultScript', FDefaultScript.CommaText);
  FIni.WriteBool('System', 'ShowRuler', ShowRuler);
  FIni.WriteInteger('System', 'WhenReturn', Ord(WhenReturn));
  FIni.WriteInteger('System', 'WhenShiftReturn', Ord(WhenShiftReturn));
  FIni.WriteInteger('System', 'WhenCtrlReturn', Ord(WhenCtrlReturn));
  FIni.WriteInteger('System', 'ServerPort', ServerPort);
  FIni.WriteString('System', 'LUID', LUID);
  FIni.WriteString('System', 'AutoJoinChannels', FAutoJoinChannels.CommaText);
  //
  FIni.WriteInteger('System', 'SenderWindowPositionLeft', SenderWindowPosition.Left);
  FIni.WriteInteger('System', 'SenderWindowPositionTop', SenderWindowPosition.Top);
  FIni.WriteInteger('System', 'SenderWindowPositionRight', SenderWindowPosition.Right);
  FIni.WriteInteger('System', 'SenderWindowPositionBottom', SenderWindowPosition.Bottom);
  FIni.WriteInteger('System', 'LogWindowPositionLeft', LogWindowPosition.Left);
  FIni.WriteInteger('System', 'LogWindowPositionTop', LogWindowPosition.Top);
  FIni.WriteInteger('System', 'LogWindowPositionRight', LogWindowPosition.Right);
  FIni.WriteInteger('System', 'LogWindowPositionBottom', LogWindowPosition.Bottom);
  FIni.WriteInteger('System', 'LogWindowDividerPos', LogWindowDividerPos);
  FIni.WriteString('System', 'LogWindowColumnWidth', LogWindowColumnWidth);
  with EditorPreviewWindowPosition do
    FIni.WriteString('System', 'EditorPreviewWindowPosition',
      Format('%d,%d,%d,%d', [Left, Top, Right, Bottom]));
  //
  FIni.WriteBool('System', 'UseHttpProxy', UseHttpProxy);
  FIni.WriteBool('System', 'AskUseHttpProxy', AskUseHttpProxy);
  FIni.WriteString('System', 'ProxyAddress', ProxyAddress);
  FIni.WriteInteger('System', 'ProxyPort', ProxyPort);
  FIni.WriteBool('System', 'ProxyNeedAuthentication', ProxyNeedAuthentication);
  FIni.WriteString('System', 'ProxyUser', ProxyUser);
  FIni.WriteString('System', 'ProxyPass', ProxyPass);
  //
  FIni.WriteInteger('System', 'ReconnectWait', ReconnectWait);
  //
  FIni.WriteInteger('System', 'LogWindowPreviewStyle', Ord(LogWindowPreviewStyle));
  FIni.WriteInteger('System', 'LogListPreviewStyle', Ord(LogListPreviewStyle));
  FIni.WriteString('System', 'FMOName', FFMOName.CommaText);
  FIni.WriteBool('System', 'HideGhosts', HideGhosts);
  FIni.WriteString('System', 'VisibleGhostsList', VisibleGhostsList.CommaText);
  FIni.WriteBool('System', 'NoExtraSSTPHeaders', NoExtraSSTPHeaders);
  //
  FIni.WriteBool('System', 'SurfacePreviewOnHint', SurfacePreviewOnHint);
  FIni.WriteBool('System', 'SurfacePreviewOnScriptPoint', SurfacePreviewOnScriptPoint);
  FIni.WriteInteger('System', 'SurfacePreviewOnScriptPointPosition', Ord(SurfacePreviewOnScriptPointPosition));

  FIni.WriteString('System', 'BrowserExeName', BrowserExeName);
  FIni.WriteBool('System', 'NoWarnOfEmptyFMO', NoWarnOfEmptyFMO);
  FIni.WriteBool('System', 'ShowEditorPreviewWindow', ShowEditorPreviewWindow);
  FIni.WriteBool('System', 'LogItemDragDrop', LogItemDragDrop);

  Strs := TStringList.Create;
  try
    Strs.Text := ComponentToString(FReplacePresets);
    Strs.SaveToFile(ReplacePresetFileName);
  finally
    Strs.Free;
  end;
end;

function TBottlePrefs.GetDefaultScript: String;
begin
  Result := FDefaultScript.Text;
end;

procedure TBottlePrefs.SetHUTagTo01Tag(const Value: boolean);
begin
  FHUTagTo01Tag := Value;
end;

procedure TBottlePrefs.SetWarnScopeChangeInSynchronize(
  const Value: boolean);
begin
  FWarnScopeChangeInSynchronize := Value;
end;

procedure TBottlePrefs.SetWarnYenTNotExist(const Value: boolean);
begin
  FWarnYenTNotExist := Value;
end;

procedure TBottlePrefs.SetNeedConfirmBeforeSend(const Value: boolean);
begin
  FNeedConfirmBeforeSend := Value;
end;

procedure TBottlePrefs.SetShowRuler(const Value: boolean);
begin
  FShowRuler := Value;
end;

procedure TBottlePrefs.SetHideGhosts(const Value: boolean);
begin
  FHideGhosts := Value;
end;

procedure TBottlePrefs.SetVisibleGhostsList(const Value: TStringList);
begin
  FVisibleGhostsList.Assign(Value);
end;

procedure TBottlePrefs.SetSurfacePreviewOnHint(const Value: boolean);
begin
  FSurfacePreviewOnHint := Value;
end;

procedure TBottlePrefs.SetSurfacePreviewOnScriptPoint(
  const Value: boolean);
begin
  FSurfacePreviewOnScriptPoint := Value;
end;

procedure TBottlePrefs.SetSurfacePreviewOnScriptPointPosition(
  const Value: TSurfacePreviewOnScriptPointPosition);
begin
  FSurfacePreviewOnScriptPointPosition := Value;
end;

procedure TBottlePrefs.SetNoExtraSSTPHeaders(const Value: boolean);
begin
  FNoExtraSSTPHeaders := Value;
end;

procedure TBottlePrefs.SetLogListPreviewStyle(
  const Value: TLogListPreviewStyle);
begin
  FLogListPreviewStyle := Value;
end;

procedure TBottlePrefs.SetEditorPreviewWindowPosition(const Value: TRect);
begin
  FEditorPreviewWindowPosition := Value;
end;

function TBottlePrefs.InScreen(ARect: TRect): boolean;
var i: integer;
    dum: TRect;
begin
  Result := false;
  for i := 0 to Screen.MonitorCount-1 do
  begin
    if IntersectRect(dum, ARect, Screen.Monitors[i].WorkareaRect) then
    begin
      Result := true;
      Exit;
    end;
  end;
end;

procedure TBottlePrefs.SetAutoClip(const Value: boolean);
begin
  FAutoClip := Value;
end;

procedure TBottlePrefs.SetConfirmOnTabClose(const Value: boolean);
begin
  FConfirmOnTabClose := Value;
end;

procedure TBottlePrefs.SetReconnectWait(const Value: integer);
begin
  FReconnectWait := Value;
  if Value < 6 then
    raise Exception.Create('Reconnect wait must be >=6');
end;

procedure TBottlePrefs.SetPartialConfirmFormat(const Value: String);
begin
  FPartialConfirmFormat := Value;
end;

procedure TBottlePrefs.SetAutoPartialConfirm(const Value: boolean);
begin
  FAutoPartialConfirm := Value;
end;

procedure TBottlePrefs.SetPlayTimeParams(const Value: TSsPlayTimeParams);
begin
  FPlayTimeParams.Assign(Value);
end;

procedure TBottlePrefs.SetTabWidth(const Value: integer);
begin
  FTabWidth := Value;
end;

procedure TBottlePrefs.SetBrowserExeName(const Value: string);
begin
  FBrowserExeName := Value;
end;

{ TChannelListItem }

procedure TChannelListItem.SetGhost(const Value: String);
begin
  FGhost := Value;
end;

procedure TChannelListItem.SetInfo(const Value: String);
begin
  FInfo := Value;
end;

procedure TChannelListItem.SetMembers(const Value: integer);
begin
  FMembers := Value;
end;

procedure TChannelListItem.SetName(const Value: String);
begin
  FName := Value;
end;

procedure TChannelListItem.SetNoPost(const Value: boolean);
begin
  FNoPost := Value;
end;

procedure TChannelListItem.SetWarnPost(const Value: boolean);
begin
  FWarnPost := Value;
end;

{ TChannelList }

procedure TChannelList.Clear;
var i: integer;
begin
  for i := Self.Count-1 downto 0 do begin
    TChannelListItem(Self[i]).Free;
  end;
  inherited;
end;

function TChannelList.GetChannel(Name: String): TChannelListItem;
var i: integer;
begin
  Result := nil;
  for i := 0 to Count-1 do
    if TChannelListItem(Self[i]).Name = Name then begin
      Result := TChannelListItem(Self[i]);
      Exit;
    end;
end;

function TChannelList.GetChannelItem(Index: integer): TChannelListItem;
begin
  Result := TChannelListItem(Self[Index]);
end;

initialization

Classes.RegisterClass(TSsPlayTimeParams);

Pref := TBottlePrefs.Create;
ChannelList := TChannelList.Create;
JoinChannels := TStringList.Create;

finalization

Pref.Free;
ChannelList.Clear;
JoinChannels.Free;
ChannelList.Free;

end.
