unit BottleSstp;

(* ʃXbhSSTPT[oDirectSSTPʂĒʐM *)

interface

uses Classes, Contnrs, SyncObjs, Windows, Logs, SysUtils, Controls, Forms,
  Messages, BottleDef, SakuraSeekerInstance, Dialogs;

type
  TBottleSstpResult = (
    srOk,
    srNoContent,                                                          
    srBreak,
    srBadRequest,
    srRequestTimeout,
    srConflict,
    srRefuse,
    srNotImplemented,
    srServiceUnavailable,
    srNotLocalIP,
    srInBlackList,
    srInvisible,
    srUnknownError
  );

  TBottleSstpResendEvent = procedure(Sender: TObject; MID: String) of object;

  TBottleSstp = class(TThread)
  private
    FTargetHwnd: HWND;
    FTargetSetName: String;
    FProcessBottle: TLogItem;
    FDirectSstpResult: String;
    FSentLog: TStringList;
    FRecvLog: TStringList;
    FCueLock: TCriticalSection;
    FCue: TObjectList; // XbhZ[tɂȂ悤ɒ
    FWindowHandle: HWND;
    FOnResendCountChange: TNotifyEvent;
    FOnResendTrying: TBottleSstpResendEvent;
    FOnResendEnd: TBottleSstpResendEvent;
    FLastTickCount: Int64;
    FResendSleep: boolean;
    FUrgent: boolean; // UnshiftŃ{gꍇ́A
                      // đԊuƂ҂ɑUĐ邽߂̃tO
    FUrgentCount: integer; // ĐX[vԂłĐ{g̐
    function GetCueCount: integer;
    procedure SetOnResendCountChange(const Value: TNotifyEvent);
    procedure SetOnResendEnd(const Value: TBottleSstpResendEvent);
    procedure SetOnResendTrying(const Value: TBottleSstpResendEvent);
    procedure SetResendSleep(const Value: boolean);
  protected
    function ConnectSstp(Source: TStrings): TBottleSstpResult;
    procedure WndProc(var Msg: TMessage);
    function ExtractCode(const CodeStr: String): integer;
    function CodeToStatus(const Code: integer): TBottleSstpResult;
    procedure DetectTargetHWND;
    procedure DoOnResendCountChange;
    procedure DoOnResendTrying;
    procedure DoOnResendEnd;
  public
    constructor Create(CreateSuspended: boolean);
    destructor Destroy; override;
    procedure Execute; override;
    procedure Push(Bottle: TLogItem); //đobt@̍Ōɒǉ()
    procedure Unshift(Bottle: TLogItem); //đobt@̐擪ɒǉ
    procedure Clear; //đobt@NA
    property ResendSleep: boolean read FResendSleep write SetResendSleep;
    property CueCount: integer read GetCueCount;
    property OnResendCountChange: TNotifyEvent read FOnResendCountChange write SetOnResendCountChange;
    property OnResendEnd: TBottleSstpResendEvent read FOnResendEnd write SetOnResendEnd;
    property OnResendTrying: TBottleSstpResendEvent read FOnResendTrying write SetOnResendTrying;
  end;

implementation

const
  //̃G[́ASSTPT[oXe[^XԂɐؒfƂȂǂɕԂ
  UnknownError = -1000;

{ TBottleSstp }

procedure TBottleSstp.Clear;
begin
  FCueLock.Enter;
  try
    FCue.Clear;
    FUrgent := false;
    FUrgentCount := 0;
  finally
    FCueLock.Leave;
  end;
  Synchronize(DoOnResendCountChange);
end;

function TBottleSstp.CodeToStatus(const Code: integer): TBottleSstpResult;
begin
  case Code of
    200: Result := srOk;
    204: Result := srNoContent;
    210: Result := srBreak;
    400: Result := srBadRequest;
    408: Result := srRequestTimeout;
    409: Result := srConflict;
    420: Result := srRefuse;
    501: Result := srNotImplemented;
    503: Result := srServiceUnavailable;
    504: Result := srNotLocalIP;
    541: Result := srInBlackList;
    512: Result := srInvisible;
  else
    Result := srUnknownError;
  end;
end;

function TBottleSstp.ConnectSstp(Source: TStrings): TBottleSstpResult;
var Mes: TCopyDataStruct;
    MesStr: String;
    Dummy: DWORD; //SendMessageTimeoutp
    StatusCode: integer;
begin
  Result := srUnknownError;

  if FTargetHWnd <> 0 then begin
    MesStr := Source.Text;
    Mes.dwData := 9801;
    Mes.cbData := Length(MesStr);
    Mes.lpData := PChar(MesStr);
    FDirectSstpResult := '';
    //FSentLog.Text := MesStr;
    SendMessageTimeout(FTargetHWnd, WM_COPYDATA, FWindowHandle, LPARAM(@Mes),
                       SMTO_ABORTIFHUNG or SMTO_NORMAL, 50000, Dummy);
    FRecvLog.Text := FDirectSstpResult;
    if FRecvLog.Count > 0 then
      StatusCode := ExtractCode(FRecvLog[0])
    else
      StatusCode := UnknownError;
    Result := CodeToStatus(StatusCode);
  end;
end;

constructor TBottleSstp.Create(CreateSuspended: boolean);
begin
  inherited;
  FCueLock := TCriticalSection.Create;
  FCue := TObjectList.Create(true);
  FWindowHandle := AllocateHWnd(WndProc);
  FSentLog := TStringList.Create;
  FRecvLog := TStringList.Create;
end;

destructor TBottleSstp.Destroy;
begin
  inherited; // Xbh̏Î挈
  // XbhIĂ炶L[Ȃǂ
  FCue.Free;
  FRecvLog.Free;
  FSentLog.Free;
  FCueLock.Free;
  DeallocateHWnd(FWindowHandle);
end;

procedure TBottleSstp.DetectTargetHWND;
var Ghost: String;
begin
  // ڕWS[Xgw
  if ChannelList.Channel[FProcessBottle.Channel] <> nil then
    Ghost := ChannelList.Channel[FProcessBottle.Channel].Ghost;
  if FProcessBottle.Ghost <> '' then Ghost := FProcessBottle.Ghost;

  SakuraSeeker.BeginDetect; //ŐVFMO擾
  if SakuraSeeker.ProcessByName[Ghost] <> nil then begin
    FTargetHWnd := SakuraSeeker.ProcessByName[Ghost].HWnd;
    FTargetSetName := SakuraSeeker.ProcessByName[Ghost].SetName;
  end else if SakuraSeeker.Count > 0 then begin
    FTargetHWnd := SakuraSeeker[0].HWnd;
    FTargetSetName := SakuraSeeker[0].SetName;
  end else begin
    FTargetHwnd := 0;
    FTargetSetName := '';
  end;
end;

procedure TBottleSstp.DoOnResendCountChange;
begin
  if Assigned(FOnResendCountChange) then
    FOnResendCountChange(self);
end;

procedure TBottleSstp.DoOnResendEnd;
begin
  if Assigned(FOnResendEnd) then
    FOnResendEnd(self, FProcessBottle.MID);
end;

procedure TBottleSstp.DoOnResendTrying;
begin
  if Assigned(FOnResendTrying) then
    FOnResendTrying(self, FProcessBottle.MID);
end;

procedure TBottleSstp.Execute;
var Source: TStringList;
    Opt: String;
    Res: TBottleSstpResult;
    BottleRef: TLogItem;
begin
  inherited;
  BottleRef := nil;
  while not Terminated do begin
    sleep(100);
    if ResendSleep and (FUrgentCount <= 0) then
      Continue;
    if (GetTickCount - FLastTickCount < 2000) and
      (GetTickCount > FLastTickCount) and not FUrgent then
      Continue;
    FUrgent := false;
    FLastTickCount := GetTickCount;

    try
      FCueLock.Enter; // NeBJZNVɓ
      try
        if FCue.Count = 0 then Continue;
        BottleRef := FCue.Items[0] as TLogItem;
        if BottleRef.LogType <> ltBottle then
        begin
          FCue.Delete(0);
          Continue;
        end;
        // Rs[ĂȂƁANeBJZNVo
        // BottleRef̎̂ʃXbhɂĉĂ܂\
        FProcessBottle := TLogItem.Create(BottleRef);
      finally
        FCueLock.Leave;
      end;

      try
        // SakuraSeeker̓XbhAZ[tȂ̂
        // SynchronizeŌĂяo
        Synchronize(DetectTargetHWND);
        if FTargetHWnd = 0 then
          Continue; // łvZX܂ł͑҂

        Synchronize(DoOnResendTrying);

        // ł͑Mv܂傤
        Source := TStringList.Create;
        try
          Opt := '';
          if Pref.NoTranslate then begin
           Opt := 'notranslate';
          end;
          if Pref.NoDescript then begin
            if Opt <> '' then Opt := Opt + ',';
            Opt := Opt + 'nodescript';
          end;
          Source.Add('SEND SSTP/1.4');
          Source.Add('Charset: Shift_JIS');
          if FProcessBottle.Ghost <> '' then
            Source.Add('Sender: SSTP Bottle / ' + FProcessBottle.Channel + '/' + FProcessBottle.Ghost)
          else
            Source.Add('Sender: SSTP Bottle / ' + FProcessBottle.Channel);
          if FProcessBottle.Ghost <> '' then begin
            Source.Add('IfGhost: ' + FTargetSetName);
          end;
          Source.Add('Script: ' + FProcessBottle.Script);
          Source.Add('Option: ' + Opt);
          Source.Add('HWnd: ' + IntToStr(FWindowHandle));
          if not Pref.NoExtraSSTPHeaders then
            Source.Add('X-Bottle-IfGhost: ' + FProcessBottle.Ghost);
          Source.Add(''); //sI
          // ۂ̑MBʂɂ̕ʃXbhȂ炢łǁB
          // Source.SaveToFile(ChangeFileExt(Application.ExeName, '.debug'));
          Res := ConnectSstp(Source);
        finally
          Source.Free;
        end;

        // M̏BMȂĂ炢܂傤
        if Res in [srOk] then begin
          Synchronize(DoOnResendEnd);
          FCueLock.Enter;
          try
            // Delete(0)ƁAÕNeBJZNV̌ɁA
            // ʃXbhɂďĂ\̂ŁA
            // ܂ABottleRefŎ擾IuWFNg܂
            // ݂Ăꍇ̂݉B
            BottleRef := FCue.Extract(BottleRef) as TLogItem;
            if BottleRef <> nil then
              BottleRef.Free;
            if FUrgentCount > 0 then
              Dec(FUrgentCount);
          finally
            FCueLock.Leave;
          end;
          Synchronize(DoOnResendCountChange);
        end;
      finally
        FProcessBottle.Free;
      end;
    except
      on E: Exception do begin
        ShowMessage('Exception occured in SSTP dispatcher class:'#13#10#13#10 + E.Message);
      end;
    end;
  //[vI
  end;
end;

function TBottleSstp.ExtractCode(const CodeStr: String): integer;
var i, l: integer;
    s, p: String;
begin
  if CodeStr = '' then begin
    Result := UnknownError;
    Exit;
  end;
  i := 1;
  l := length(CodeStr);
  while (CodeStr[i] <> ' ') and (i<=l) do begin
    p := p + CodeStr[i];
    Inc(i);
  end;
  Inc(i);
  while (CodeStr[i] in ['0'..'9']) and (i<=l) do begin
    s := s + CodeStr[i];
    Inc(i);
  end;
  try
    Result := StrToInt(s);
  except
    on EConvertError do Result := UnknownError;
  end;
end;


function TBottleSstp.GetCueCount: integer;
begin
  Result := FCue.Count;
end;

procedure TBottleSstp.Push(Bottle: TLogItem);
begin
  FCueLock.Enter;
  try
    FCue.Add(Bottle);
  finally
    FCueLock.Leave;
  end;
  Synchronize(DoOnResendCountChange);
end;

procedure TBottleSstp.SetOnResendCountChange(const Value: TNotifyEvent);
begin
  FOnResendCountChange := Value;
end;

procedure TBottleSstp.SetOnResendEnd(const Value: TBottleSstpResendEvent);
begin
  FOnResendEnd := Value;
end;

procedure TBottleSstp.SetOnResendTrying(
  const Value: TBottleSstpResendEvent);
begin
  FOnResendTrying := Value;
end;

procedure TBottleSstp.SetResendSleep(const Value: boolean);
begin
  FResendSleep := Value;
end;

procedure TBottleSstp.Unshift(Bottle: TLogItem);
begin
  FCueLock.Enter;
  try
    FCue.Insert(0, Bottle);
    FUrgent := true;
    Inc(FUrgentCount);
  finally
    FCueLock.Leave;
  end;
  Synchronize(DoOnResendCountChange);
end;

procedure TBottleSstp.WndProc(var Msg: TMessage);
var Dat: TWMCopyData;
begin
  //Xbh֐
  if Msg.Msg = WM_COPYDATA then begin
    Dat := TWMCopyData(Msg);
    FDirectSstpResult := PChar(Dat.CopyDataStruct^.lpData);
  end else begin
    Msg.Result := DefWindowProc(FWindowHandle, Msg.Msg, Msg.wParam, Msg.lParam);
  end;
end;

end.
