unit ChannelListForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, BottleDef;

type
  TfrmChannelList = class(TForm)
    lvwChannels: TListView;
    pnlTop: TPanel;
    pnlBottom: TPanel;
    btnOk: TButton;
    btnSelectAll: TButton;
    btnCancel: TButton;
    btnSelectNone: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure btnSelectAllClick(Sender: TObject);
    procedure btnSelectNoneClick(Sender: TObject);
    procedure lvwChannelsColumnClick(Sender: TObject; Column: TListColumn);
    procedure lvwChannelsCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
  private
    { Private 錾 }
    FTempJoinList: TStringList;
    SortColumn: integer;  //NbN\[gp
    SortDesc: boolean;    //NbN\[gp
  public
    { Public 錾 }
    function Execute(List: TChannelList; Join: TStringList): boolean;
    property JoinList: TStringList read FTempJoinList;
  end;

var
  frmChannelList: TfrmChannelList;

implementation

{$R *.DFM}

{ TfrmChannelList }

function TfrmChannelList.Execute(List: TChannelList; Join: TStringList): boolean;
var i, count: integer;
    Item: TListItem;
begin
  lvwChannels.Items.Clear;
  count := 0;
  for i := 0 to List.Count-1 do begin
    Item := lvwChannels.Items.Add;
    Item.Caption := List.ChannelItem[i].Name;
    Item.SubItems.Add(IntToStr(List.ChannelItem[i].Members));
    Item.SubItems.Add(List.ChannelItem[i].Info);
    Item.SubItems.Add(List.ChannelItem[i].Ghost);
    if List.ChannelItem[i].NoPost then
      Item.SubItems.Add('Mp')
    else
      Item.SubItems.Add('ʏ');
    if Join.IndexOf(Item.Caption) >= 0 then begin
      Item.Checked := true;
      Inc(count);
    end;
  end;

  // `l1QĂȂԂȂSQftHgɂ
  if count = 0 then
    for i := 0 to lvwChannels.Items.Count-1 do
      lvwChannels.Items[i].Checked := true;
  Result := (ShowModal = mrOk);
end;

procedure TfrmChannelList.FormCreate(Sender: TObject);
begin
  FTempJoinList := TStringList.Create;
end;

procedure TfrmChannelList.FormDestroy(Sender: TObject);
begin
  FTempJoinList.Free;
end;

procedure TfrmChannelList.btnOkClick(Sender: TObject);
var i: integer;
begin
  FTempJoinList.Clear;
  for i := 0 to lvwChannels.Items.Count-1 do begin
    if lvwChannels.Items[i].Checked then
      FTempJoinList.Add(lvwChannels.Items[i].Caption);
  end;
end;

procedure TfrmChannelList.btnSelectAllClick(Sender: TObject);
var i: integer;
begin
  for i := 0 to lvwChannels.Items.Count-1 do begin
    lvwChannels.Items[i].Checked := true;
  end;
end;

procedure TfrmChannelList.btnSelectNoneClick(Sender: TObject);
var i: integer;
begin
  for i := 0 to lvwChannels.Items.Count-1 do begin
    lvwChannels.Items[i].Checked := false;
  end;
end;

procedure TfrmChannelList.lvwChannelsColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  if SortColumn = Column.Index then
    SortDesc := not SortDesc
  else begin
    SortColumn := Column.Index;
    SortDesc := false;
  end;
  lvwChannels.AlphaSort;
end;

procedure TfrmChannelList.lvwChannelsCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
var
  ix: Integer;
begin
  if SortColumn = 0 then
    Compare := CompareText(Item1.Caption,Item2.Caption)
  else begin
   ix := SortColumn - 1;
   Compare := AnsiCompareStr(Item1.SubItems[ix],Item2.SubItems[ix]);
  end;
  if SortDesc then Compare := -Compare; //
end;

end.
