unit ConstEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ImgList, ComCtrls, Menus, BottleDef,
  ActnList, ToolWin, ExtCtrls, ScriptConsts;

type
  TfrmConstEditor = class(TForm)
    tvwConst: TTreeView;
    imgIcon: TImageList;
    ToolBar1: TToolBar;
    tbtnNewGroup: TToolButton;
    tbtnAddConst: TToolButton;
    tbtnDelete: TToolButton;
    btbnUp: TToolButton;
    tbtnDown: TToolButton;
    ActionList1: TActionList;
    actNewGroup: TAction;
    actNewConst: TAction;
    actDelete: TAction;
    actMoveUp: TAction;
    actMoveDown: TAction;
    PopUpMenu: TPopupMenu;
    mnNewGroup: TMenuItem;
    mnAddConst: TMenuItem;
    mnUp: TMenuItem;
    mnDown: TMenuItem;
    pnlConstText: TPanel;
    pageConstText: TPageControl;
    tstMenu: TTabSheet;
    tstConst: TTabSheet;
    Label1: TLabel;
    edtMenuCaption: TEdit;
    Label2: TLabel;
    edtMenuIfGhost: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    edtConstCaption: TEdit;
    edtConstScript: TEdit;
    cbxConstShortCut: TComboBox;
    btnClose: TButton;
    pnlConstFile: TPanel;
    Label6: TLabel;
    cbxConstFile: TComboBox;
    mnDeleteConst: TMenuItem;
    procedure actDeleteExecute(Sender: TObject);
    procedure actMoveUpExecute(Sender: TObject);
    procedure actMoveDownExecute(Sender: TObject);
    procedure tvwConstChange(Sender: TObject; Node: TTreeNode);
    procedure FormCreate(Sender: TObject);
    procedure PopUpMenuPopup(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure tvwConstChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure cbxConstFileChange(Sender: TObject);
    procedure actNewGroupExecute(Sender: TObject);
    procedure actNewConstExecute(Sender: TObject);
    procedure edtExit(Sender: TObject);
  private
    { Private 錾 }
    FTargetConstFile: TScriptConstFile;
    FTargetItemID: integer;
    procedure UpdateList;
    function GetNodeByID(ID: integer): TTreeNode;
    procedure ChangeActionStatus;
  public
    { Public 錾 }
    function Execute: boolean;
  end;

var
  frmConstEditor: TfrmConstEditor;

implementation

const
  IcoGroup = 0;
  IcoConst = 1;
  IcoIfGhostGroup = 7;


{$R *.DFM}

{ TfrmConstEditor }



function TfrmConstEditor.Execute: boolean;
var i: integer;
begin
  cbxConstFile.Items.Clear;
  for i := 0 to ScriptConstList.Count-1 do begin
    cbxConstFile.Items.Add(ExtractFileName(ScriptConstList.Files[i].FileName));
  end;
  if ScriptConstList.Count > 0 then begin
    FTargetConstFile := ScriptConstList[0];
    cbxConstFile.ItemIndex := 0;
  end else begin
    FTargetConstFile := nil;
    cbxConstFile.Text := '';
  end;
  UpdateList;
  ChangeActionStatus;
  ShowModal;
  Result := true;
end;

procedure TfrmConstEditor.actDeleteExecute(Sender: TObject);
var Node: TTreeNode;
begin
  if tvwConst.Selected = nil then Exit;
  Node := tvwConst.Selected;
  if Node.Level = 0 then begin
    if Node.HasChildren then begin
      if MessageDlg(Node.Text + 'ɑ' + IntToStr(Node.Count) + '̒^폜܂?',
                    mtConfirmation, mbOkCancel, 0) = mrCancel then Exit;
    end;
  end;
  FTargetConstFile.Delete(integer(Node.Data));
  tvwConst.OnChanging := nil;
  tvwConst.Items.Delete(Node);
  tvwConst.OnChanging := tvwConstChanging;
  ChangeActionStatus;
end;

procedure TfrmConstEditor.actMoveUpExecute(Sender: TObject);
var Node, DestNode: TTreeNode;
begin
  Node := tvwConst.Selected;
  if Node = nil then
    Exit;
  FTargetConstFile.MoveUp(integer(Node.Data));
  if Node.getPrevSibling <> nil then begin
    DestNode := Node.getPrevSibling;
    Node.MoveTo(DestNode, naInsert);
  end else if Node.Level = 1 then begin
    //ÕO[v̖Ɉړ
    if Node.Parent.getPrevSibling = nil then Exit;
    DestNode := Node.Parent.getPrevSibling;
    Node.MoveTo(DestNode, naAddChild);
  end;
end;

procedure TfrmConstEditor.actMoveDownExecute(Sender: TObject);
var Node, DestNode, NextNode: TTreeNode;
begin
  Node := tvwConst.Selected;
  if Node = nil then
    Exit;
  FTargetConstFile.MoveDown(integer(Node.Data));
  if Node.getNextSibling <> nil then begin
    NextNode := Node.getNextSibling;
    NextNode.MoveTo(Node, naInsert);
  end else if Node.Level = 1 then begin
    //̃O[v̐擪Ɉړ
    if Node.Parent.getNextSibling = nil then Exit;
    DestNode := Node.Parent.getNextSibling;
    Node.MoveTo(DestNode, naAddChildFirst);
  end;
end;

procedure TfrmConstEditor.tvwConstChange(Sender: TObject; Node: TTreeNode);
var ConstData: TScriptConst;
    MenuData: TScriptConstMenu;
    ID: integer;
begin
  ChangeActionStatus;
  if Node <> nil then
  begin
    pageConstText.Enabled := true;
    ID := integer(Node.Data); // {͂肽ȂLXg
    if Node.Level = 0 then begin
      MenuData := ScriptConstList.GetMenuByID(ID);
      pageConstText.ActivePage := tstMenu;
      edtMenuCaption.Text := MenuData.Caption;
      edtMenuIfGhost.Text := MenuData.IfGhost;
    end else begin
      ConstData := ScriptConstList.GetConstByID(ID);
      pageConstText.ActivePage := tstConst;
      edtConstCaption.Text := ConstData.Caption;
      edtConstScript.Text := ConstData.ConstText;
      cbxConstShortCut.Text := ShortCutToText(ConstData.ShortCut);
    end;
    FTargetItemID := ID;
  end;
end;

procedure TfrmConstEditor.FormCreate(Sender: TObject);
begin
  if Application.Terminated then Exit;
  //j[쐬
  BuildShortCutList(cbxConstShortCut.Items);
  tvwConst.DoubleBuffered := true;
end;

procedure TfrmConstEditor.PopUpMenuPopup(Sender: TObject);
begin
  ChangeActionStatus;
  // ȉ͉ENbNɃG[NȂ߂
  // gbNIȃR[h
  if tvwConst.Selected <> nil then
    tvwConst.Selected.Selected := true;
end;

procedure TfrmConstEditor.btnCloseClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrmConstEditor.UpdateList;
var i, j: integer;
    MenuNode, ConstNode: TTreeNode;
begin
  tvwConst.OnChanging := nil;
  tvwConst.Items.BeginUpdate;
  for i := tvwConst.Items.Count-1 downto 0 do begin
    tvwConst.Items[i].Delete;
  end;
  if FTargetConstFile <> nil then begin
    MenuNode := nil;
    for i := 0 to FTargetConstFile.Count-1 do begin
      MenuNode := tvwConst.Items.Add(MenuNode, FTargetConstFile[i].Caption);
      if FTargetConstFile[i].IfGhost <> '' then begin
        MenuNode.ImageIndex := IcoIfGhostGroup;
        MenuNode.SelectedIndex := IcoIfGhostGroup;
      end else begin
        MenuNode.ImageIndex := IcoGroup;
        MenuNode.SelectedIndex := IcoGroup;
      end;
      MenuNode.Data := Pointer(FTargetConstFile[i].ID);
      for j := 0 to FTargetConstFile[i].Count-1 do begin
        ConstNode := tvwConst.Items.AddChild(MenuNode, FTargetConstFile[i][j].Caption);
        ConstNode.ImageIndex := IcoConst;
        ConstNode.SelectedIndex := IcoConst;
        ConstNode.Data := Pointer(FTargetConstFile[i][j].ID);
      end;
      MenuNode.Expand(false);
    end;
  end;
  tvwConst.Items.EndUpdate;
  if tvwConst.Items.Count > 0 then tvwConst.Items[0].Selected := true;
  tvwConst.OnChanging := tvwConstChanging;
end;

procedure TfrmConstEditor.tvwConstChanging(Sender: TObject;
  Node: TTreeNode; var AllowChange: Boolean);
var ConstData: TScriptConst;
    MenuData:  TScriptConstMenu;
    CanUpdate: boolean;
begin
  // Iړ܂̃ACẽf[^XV
  if FTargetItemID = 0 then Exit; // ȑOɉIĂȂ̂Ȃ牽Ȃ

  ConstData := ScriptConstList.GetConstByID(FTargetItemID);
  CanUpdate := false; // tO
  if ConstData <> nil then begin
    if edtConstCaption.Text <> ConstData.Caption then CanUpdate := true;
    if edtConstScript.Text <> ConstData.ConstText then CanUpdate := true;
    if TextToShortCut(cbxConstShortCut.Text) <> ConstData.ShortCut then CanUpdate := true;
    if edtConstCaption.Text = '' then CanUpdate := false;
    if edtConstScript.Text = '' then CanUpdate := false;
    if CanUpdate then begin
      ConstData.Caption := edtConstCaption.Text;
      ConstData.ConstText := edtConstScript.Text;
      try
        ConstData.ShortCut := TextToShortCut(cbxConstShortCut.Text);
      except
        ConstData.ShortCut := 0;
      end;
      GetNodeByID(FTargetItemID).Text := ConstData.Caption;
    end;
  end else begin
    MenuData := ScriptConstList.GetMenuByID(FTargetItemId);
    if edtMenuCaption.Text <> MenuData.Caption then CanUpdate := true;
    if edtMenuIfGhost.Text <> MenuData.IfGhost then CanUpdate := true;
    if edtMenuCaption.Text = '' then CanUpdate := false;
    if CanUpdate then begin
      MenuData.Caption := edtMenuCaption.Text;
      MenuData.IfGhost := edtMenuIfGhost.Text;
      with GetNodeByID(FTargetItemID) do begin
        Text := MenuData.Caption;
        if MenuData.IfGhost <> '' then begin
          ImageIndex := IcoIfGhostGroup;
          SelectedIndex := IcoIfGhostGroup;
        end else begin
          ImageIndex := IcoGroup;
          SelectedIndex := IcoGroup;
        end;
      end;
    end;
  end;
end;

function TfrmConstEditor.GetNodeByID(ID: integer): TTreeNode;
var i: integer;
begin
  Result := nil;
  for i := 0 to tvwConst.Items.Count-1 do
    if integer(tvwConst.Items[i].Data) = ID then begin
      Result := tvwConst.Items[i];
      Exit;
    end;
end;

procedure TfrmConstEditor.cbxConstFileChange(Sender: TObject);
begin
  FTargetConstFile := ScriptConstList[cbxConstFile.ItemIndex];
  ChangeActionStatus;
  UpdateList;
end;

procedure TfrmConstEditor.actNewGroupExecute(Sender: TObject);
var MenuData: TScriptConstMenu;
    Node: TTreeNode;
begin
  MenuData := FTargetConstFile.AddMenu;
  Node := tvwConst.Items.Add(nil, MenuData.Caption);
  Node.Data := Pointer(MenuData.ID);
  Node.Selected := true;
  edtMenuCaption.SetFocus;
  edtMenuCaption.SelectAll;
end;

procedure TfrmConstEditor.actNewConstExecute(Sender: TObject);
var ConstData: TScriptConst;
    MenuData: TScriptConstMenu;
    MenuNode, NewNode: TTreeNode;
    ID: integer;
begin
  if tvwConst.Selected = nil then
  begin
    ShowMessage('O[v쐬EIĂ');
    Exit;
  end;
  if tvwConst.Selected.Level = 0 then
    MenuNode := tvwConst.Selected
  else
    MenuNode := tvwConst.Selected.Parent;
  ID := integer(MenuNode.Data);
  MenuData := FTargetConstFile.GetMenuByID(ID);
  ConstData := MenuData.AddConst;
  NewNode := tvwConst.Items.AddChild(MenuNode, ConstData.Caption);
  NewNode.ImageIndex := 1;
  NewNode.SelectedIndex := 1;
  NewNode.Data := Pointer(ConstData.ID);
  NewNode.Selected := true;
  edtConstCaption.SetFocus;
  edtConstCaption.SelectAll;
end;

procedure TfrmConstEditor.edtExit(Sender: TObject);
var dummy: boolean;
begin
  tvwConstChanging(self, nil, dummy);
end;

procedure TfrmConstEditor.ChangeActionStatus;
var
  Selected: TTreeNode;
begin
  // Ԃɉăj[̗LEؑւ
  Selected := tvwConst.Selected;
  pageConstText.Enabled := Selected <> nil;
  actMoveDown.Enabled := Selected <> nil;
  actNewConst.Enabled := Selected <> nil;
  actDelete.Enabled   := Selected <> nil;
  actMoveUp.Enabled   := Selected <> nil;
end;

end.
