unit FMOExplorer;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ImgList, ToolWin, ActnList,
  SakuraSeekerInstance, DirectSstp, Menus, Clipbrd;

type
  TfrmFMOExplorer = class(TForm)
    lvwList: TListView;
    ToolBar: TToolBar;
    ImageList: TImageList;
    tbtnRestoreSurface: TToolButton;
    ToolButton2: TToolButton;
    tbtnKillFMO: TToolButton;
    tbtnRefresh: TToolButton;
    ActionList: TActionList;
    actKillFMO: TAction;
    actRestoreSurface: TAction;
    actRefresh: TAction;
    StatusBar: TStatusBar;
    DirectSstp: TDirectSstp;
    PopupMenu: TPopupMenu;
    mnKillFMO: TMenuItem;
    mnRestoreSurface: TMenuItem;
    ToolButton1: TToolButton;
    tbtnCopyInformation: TToolButton;
    actCopyInformation: TAction;
    mnSeparator: TMenuItem;
    mnCopyInformation: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure actRefreshExecute(Sender: TObject);
    procedure lvwListChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure actKillFMOExecute(Sender: TObject);
    procedure lvwListDblClick(Sender: TObject);
    procedure actCopyInformationExecute(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure UpdateList;
  end;

var
  frmFMOExplorer: TfrmFMOExplorer;

implementation

const
  IconFMOEntry = 3;
  IconBrokenFMO = 4;

{$R *.dfm}

procedure TfrmFMOExplorer.FormShow(Sender: TObject);
begin
  UpdateList;
end;

procedure TfrmFMOExplorer.UpdateList;
var i, j: integer;
    valid: boolean;
    HwndToVer, TmpStr: TStringList;
    s: String;
begin
  lvwList.Clear;
  SakuraSeeker.BeginDetect;
  lvwList.Items.BeginUpdate;
  for i := 0 to SakuraSeeker.Count-1 do begin
    with lvwList.Items.Add do begin
      Caption := SakuraSeeker[i].SetName;
      SubItems.Add(SakuraSeeker[i].FMOName);
      SubItems.Add(SakuraSeeker[i].ProcessID);
      SubItems.Add(IntToStr(SakuraSeeker[i].HWnd));
      SubItems.Add('');
      SubItems.Add('?');

      valid := (SakuraSeeker[i].Hwnd <> 0) and (SakuraSeeker[i].Name <> '')
        and (SakuraSeeker[i].KeroName <> '');
      if valid then
        ImageIndex := IconFMOEntry
      else
        ImageIndex := IconBrokenFMO;
        SubItems[4] := 'jFMO';
    end;
  end;
  lvwList.Items.EndUpdate;
  StatusBar.Panels[0].Text := Format('%d', [SakuraSeeker.Count]);

  HwndToVer := TStringList.Create;
  s := '';
  try
    for i := 0 to SakuraSeeker.Count-1 do begin
      s := HwndToVer.Values[IntToStr(SakuraSeeker[i].HWnd)];
      if s <> '' then begin
        lvwList.Items[i].SubItems[3] := s;
        lvwList.Items[i].SubItems[4] := '';
      end else begin
        DirectSSTP.TargetHWnd := SakuraSeeker[i].HWnd;
        DirectSSTP.SstpSender := Application.Title;
        s := DirectSSTP.SstpEXECUTE('GetVersion');
        TmpStr := TStringList.Create;
        try
          TmpStr.Text := s;
          for j := 0 to TmpStr.Count-1 do
            if TmpStr[j] <> '' then begin
              s := TmpStr[j];
              Break;
            end;
        finally
          TmpStr.Free;
        end;
        if s <> '' then begin
          HwndToVer.Values[IntToStr(SakuraSeeker[i].HWnd)] := s;
          lvwList.Items[i].SubItems[3] := s;
          lvwList.Items[i].SubItems[4] := '';
        end else begin
          lvwList.Items[i].SubItems[4] := 'Ȃ';
          lvwList.Items[i].ImageIndex := IconBrokenFMO;
        end;
      end;
    end;
  finally
    HwndToVer.Free;
  end;
end;

procedure TfrmFMOExplorer.actRefreshExecute(Sender: TObject);
begin
  UpdateList;
end;

procedure TfrmFMOExplorer.lvwListChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if Change <> ctState then Exit;
  actKillFMO.Enabled := lvwList.Selected <> nil;
  actCopyInformation.Enabled := lvwList.Selected <> nil;
end;

procedure TfrmFMOExplorer.actKillFMOExecute(Sender: TObject);
var i: integer;
begin
  if lvwList.Selected = nil then Exit;
  for i := lvwList.Items.Count-1 downto 0 do
    if lvwList.Items[i].Selected and (SakuraSeeker.Process[i] <> nil) then begin
      SakuraSeeker.KillFMO(SakuraSeeker.Process[i].FMOName, SakuraSeeker.Process[i].ProcessID);
      lvwList.Items.Delete(i);
    end;
end;

procedure TfrmFMOExplorer.lvwListDblClick(Sender: TObject);
var i, index: integer;
    str: String;
begin
  if lvwList.Selected = nil then Exit;
  index := lvwList.Selected.Index;
  for i := 0 to SakuraSeeker[index].Count-1 do begin
    if i > 0 then str := str + #13#10;
    str := str + SakuraSeeker[index].KeyAt[i] + ': ' + SakuraSeeker[index].DataAt[i];
  end;
  ShowMessage(str);
end;

procedure TfrmFMOExplorer.actCopyInformationExecute(Sender: TObject);
var
  Clip: TClipBoard;
  str: String;
  i, index: integer;
begin
  if lvwList.Selected = nil then
    Exit;
  index := lvwList.Selected.Index;
  for i := 0 to SakuraSeeker[index].Count-1 do
  begin
    if i > 0 then str := str + #13#10;
    str := str + SakuraSeeker[index].KeyAt[i] + ': ' + SakuraSeeker[index].DataAt[i];
  end;
  Clip := ClipBoard();
  Clip.SetTextBuf(PChar(str));
end;

initialization

frmFMOExplorer := nil;

end.
