unit HttpThread;

interface

uses
  Classes, IdHttp, IdException, SysUtils, Dialogs, IdComponent;

type
  THttpWorkEvent = procedure(Sender: TObject; LoadBytes: integer) of object;

  THTTPDownloadThread = class(TThread)
  private
    { Private 錾 }
    FHost: String;
    FURL: String;
    FPost: String;
    FRecvString: String;
    FProxyServer: String;
    FProxyPort: integer;
    FProxyUser: String;
    FProxyPass: String;
    FOnSuccess: TNotifyEvent;
    FOnConnectionFailed: TNotifyEvent;
    FLastErrorMessage: String;
    FOnHttpWork: THttpWorkEvent;
    FLoadBytes: integer;
    FLastTriggeredLoadBytes: integer;
    FTriggerWorkEventBy: integer;
    procedure SetProxyPort(const Value: integer);
    procedure SetProxyServer(const Value: String);
    procedure SetProxyUser(const Value: String);
    procedure SetProxyPass(const Value: String);
    procedure SetOnConnectionFailed(const Value: TNotifyEvent);
    procedure SetOnSuccess(const Value: TNotifyEvent);
    procedure SetOnHttpWork(const Value: THttpWorkEvent);
    procedure WorkHandler(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCount: Integer);
    procedure SetTriggerWorkEventBy(const Value: integer);
  protected
    procedure Execute; override;
    procedure DoSuccess;
    procedure DoConnectionFailed;
    procedure DoHttpWork;
  public
    constructor Create(const Host, URL, Post: String); reintroduce;
    property RecvString: String read FRecvString;
    property ProxyServer: String read FProxyServer write SetProxyServer;
    property ProxyPort: integer read FProxyPort write SetProxyPort;
    property ProxyUser: String read FProxyUser write SetProxyUser;
    property ProxyPass: String read FProxyPass write SetProxyPass;
    property OnConnectionFailed: TNotifyEvent read FOnConnectionFailed write SetOnConnectionFailed;
    property OnSuccess: TNotifyEvent read FOnSuccess write SetOnSuccess;
    property OnHttpWork: THttpWorkEvent read FOnHttpWork write SetOnHttpWork;
    property LastErrorMessage: String read FLastErrorMessage;
    property TriggerWorkEventBy: integer read FTriggerWorkEventBy write SetTriggerWorkEventBy;
  end;

implementation

{: 
  قȂXbhL VCL ̃\bh/֐/vpeB
  ʂ̃Xbh̒爵ꍇAr̖肪܂B

  CXbh̏LIuWFNgɑ΂Ă Synchronize
  \bhgł܂B̃IuWFNgQƂ邽
  ̃\bhXbhNXɒǉASynchronize \bh
  Ƃēn܂B

  Ƃ΁AUpdateCaption \bhȉ̂悤ɒ`A

    procedure THTTPDownloadThread.UpdateCaption;
    begin
      Form1.Caption := 'THTTPDownloadThread Xbh珑܂';
    end;

  Execute \bh̒ Synchronize \bhɓnƂŃC
  XbhL Form1  Caption vpeBSɕ
  Xł܂B

      Synchronize(UpdateCaption);
}

{ THTTPDownloadThread }

constructor THTTPDownloadThread.Create(const Host, URL, Post: String);
begin
  inherited Create(true);
  FHost := Host;
  FURL := URL;
  FPost := Post;
  FTriggerWorkEventBy := 1024; // KBPʂOnHttpWorkCxg
end;

procedure THTTPDownloadThread.DoConnectionFailed;
begin
  FOnConnectionFailed(self);
end;

procedure THTTPDownloadThread.DoHttpWork;
begin
  FOnHttpWork(self, FLoadBytes);
end;

procedure THTTPDownloadThread.DoSuccess;
begin
  FOnSuccess(self);
end;

procedure THTTPDownloadThread.Execute;
var Http: TIdHTTP;
    TmpStr: TStringStream;
begin
  Http := nil;
  TmpStr := nil;
  FLoadBytes := 0;
  FLastTriggeredLoadBytes := 0;
  try
    try
      Http := TIdHTTP.Create(nil);
      Http.Host := FHost;
      Http.ProxyParams.ProxyServer := ProxyServer;
      Http.ProxyParams.ProxyPort := ProxyPort;

      if ProxyUser <> '' then begin
        if ProxyPass <> '' then begin
          Http.ProxyParams.BasicAuthentication := true;
          Http.ProxyParams.ProxyUsername := ProxyUser;
          Http.ProxyParams.ProxyPassword := ProxyPass;
        end;
      end;

      Http.OnWork := WorkHandler;
      if FPost = '' then begin
        FRecvString := Http.Get(FURL);
      end else begin
        TmpStr := TStringStream.Create(FPost);
        FRecvString := Http.Post(FURL, TmpStr);
      end;
      if Assigned(FOnSuccess) then Synchronize(DoSuccess);
    except
      on E:EIdException do begin
        //ShowMessage(E.Message);
        FLastErrorMessage := E.Message;
        if Assigned(FOnConnectionFailed) then Synchronize(DoConnectionFailed);
      end;
    end;
  finally
    Http.Free;
    if TmpStr <> nil then TmpStr.Free;
  end;
end;

procedure THTTPDownloadThread.SetOnConnectionFailed(
  const Value: TNotifyEvent);
begin
  FOnConnectionFailed := Value;
end;

procedure THTTPDownloadThread.SetOnHttpWork(const Value: THttpWorkEvent);
begin
  FOnHttpWork := Value;
end;

procedure THTTPDownloadThread.SetOnSuccess(const Value: TNotifyEvent);
begin
  FOnSuccess := Value;
end;

procedure THTTPDownloadThread.SetProxyPort(const Value: integer);
begin
  if Suspended then
    FProxyPort := Value
  else
    raise EIdException.Create('Tried to change proxy without suspending');
end;

procedure THTTPDownloadThread.SetProxyServer(const Value: String);
begin
  if Suspended then
    FProxyServer := Value
  else
    raise EIdException.Create('Tried to change proxy without suspending');
end;

procedure THTTPDownloadThread.SetProxyUser(const Value: String);
begin
  if Suspended then
    FProxyUser := Value
  else
    raise EIdException.Create('Tried to change proxy without suspending');
end;

procedure THTTPDownloadThread.SetProxyPass(const Value: String);
begin
  if Suspended then
    FProxyPass := Value
  else
    raise EIdException.Create('Tried to change proxy without suspending');
end;

procedure THTTPDownloadThread.SetTriggerWorkEventBy(const Value: integer);
begin
  FTriggerWorkEventBy := Value;
end;

procedure THTTPDownloadThread.WorkHandler(Sender: TObject;
  AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
  if AWorkMode = wmRead then
    //Inc(FLoadBytes, AWorkCount);
    FLoadBytes := AWorkCount;
  if (FLastTriggeredLoadBytes div FTriggerWorkEventBy) <>
  (FLoadBytes div FTriggerWorkEventBy) then begin
    if Assigned(FOnHttpWork) then Synchronize(DoHttpWork);
    FLastTriggeredLoadBytes := FLoadBytes;
  end;
end;

end.
