unit MessageBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Contnrs, ExtCtrls;

type
  TfrmMessageBox = class(TForm)
    memMessage: TMemo;
    btnOk: TButton;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private 錾 }
    FMessages: TObjectList;
    procedure UpdateMessage;
  public
    { Public 錾 }
    procedure ShowMessage(const Mes: String); overload;
    procedure ShowMessage(Mes: TStrings); overload;
  end;

var
  frmMessageBox: TfrmMessageBox;

implementation

{$R *.DFM}

procedure TfrmMessageBox.FormCreate(Sender: TObject);
begin
  FMessages := TObjectList.Create;
end;

procedure TfrmMessageBox.FormDestroy(Sender: TObject);
begin
  FMessages.Free;
end;

procedure TfrmMessageBox.ShowMessage(const Mes: String);
var Str: TStringList;
begin
  Str := TStringList.Create;
  with Str do begin
    Text := Mes;
    Self.ShowMessage(Str);
    Free;
  end;
end;

procedure TfrmMessageBox.ShowMessage(Mes: TStrings);
var Str: TStringList;
begin
  Str := TStringList.Create;
  Str.Assign(Mes);
  FMessages.Add(Str);
  UpdateMessage;
end;

procedure TfrmMessageBox.btnOkClick(Sender: TObject);
begin
  FMessages.Delete(0);
  UpdateMessage;
end;

procedure TfrmMessageBox.UpdateMessage;
begin
  if FMessages.Count > 0 then begin
    memMessage.Lines.Assign(FMessages[0] as TStrings);
  end else begin
    Close;
    Exit;
  end;
  if FMessages.Count <= 1 then //Ō1̃bZ[W̏ꍇ
    btnOk.Caption := '&OK'
  else
    btnOk.Caption := Format('>>(%d)', [FMessages.Count-1]);
  Show;
  btnOk.SetFocus;
end;

procedure TfrmMessageBox.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose :=  FMessages.Count = 0;
end;

end.
