unit RegexUtils;

interface

uses
  BRegExp, Forms, Dialogs, SysUtils;

// m//k Ȃǂň͂܂ĂȂK\𐳂͂
// BRegExpG[̔h
function SafeAndCheckRegExp(var ioStrExpression: String): String;

// ̊֐ŎIɈ͂񂾕̂܂܉ʕ\ƕςȂ̂
// ēxtB^Ďn邽߂̊֐
// O 'm'#255  #255'k' 菜ĕԂ
function FilterAutoRegExp(const Expression: String): String;

// s/// ̐K\ă`FbN
function SafeAndCheckRegExpSubst(Before, After: String;
  Flags: TReplaceFlags; out Expression: String): String;

// K\StringReplaceBOldPatternɐK\gA
// NewPattern\1, \2ȂǂgȊÓA
// SysUtils.StringReplace֐ƂقƂǓ悤ɓ삷
function StringReplaceRegExp(const S, OldPattern, NewPattern: string;
  Flags: TReplaceFlags): String;

var
  RegExp: TBRegExp;

implementation

//K\`FbNƕύX
//߂lG[bZ[Wi펞͋j
function SafeAndCheckRegExp(var ioStrExpression: String): String;
begin
  Result := '';
  try
    RegExp.Match(ioStrExpression,' ');
  except
    on EBRegExpError do
    begin
      ioStrExpression := 'm'#255 + ioStrExpression + #255'k';
      try
        RegExp.Match(ioStrExpression, ' ');
      except
        on E: EBRegExpError do
          Result := E.Message;
      end;
    end;
  end;
end;

//}K\w m[0xFF][0xFF]k ̏
function FilterAutoRegExp(const Expression: String): String;
begin
  Result := Expression;
  try
    if RegExp.Match('m/m'#255'(.*)'#255'k/k', Result) then begin
      Result := Copy(Result, 3, Length(Result) - 4);
    end;
  except
    on EBRegExpError do ; //NOOP
  end;
end;

function SafeAndCheckRegExpSubst(Before, After: String;
  Flags: TReplaceFlags; out Expression: String): String;
var
  Dummy: String;
begin
  Result := '';
  Expression := 's'#255 + Before + #255 + After + #255'k';
  if rfIgnoreCase in Flags then
    Expression := Expression + 'i';
  if rfReplaceAll in Flags then
    Expression := Expression + 'g';
  try
    Dummy := ' ';
    RegExp.Subst(Expression, Dummy);
  except
    on E: EBRegExpError do
    begin
      Result := E.Message;
    end;
  end;
end;

function StringReplaceRegExp(const S, OldPattern, NewPattern: string;
  Flags: TReplaceFlags): String;
var
  Err, Pattern: String;
begin
  Err := SafeAndCheckRegExpSubst(OldPattern, NewPattern, Flags, Pattern);
  if Err <> '' then
    raise EBRegExpError.Create(Err);
  Result := S;
  RegExp.Subst(Pattern, Result);
end;

initialization

try
  RegExp := TBRegExp.Create;
except
  ShowMessage('RegExp.dllJnG[');
  Application.Terminate;
end;

finalization

RegExp.Free;

end.
