unit ReplacePresetEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StrReplaceFrame, StdCtrls, StrReplace, ExtCtrls,
  Menus, BottleDef;

{
  tH[AutoSize = trueɐݒ肳Ă邽߁A
  tH[͒ɉĎIɏkށB

  ɁAtH[́Aׂ Align = alTop ɐݒ肳ꂽ3
  plɂċ؂ĂB

  ԏ̃pl pnlPairsEditor ƁA
  ԉ̃pl pnlOkCancelButtons ́Aɕ\Ă邪A
  ^񒆂̃pl pnlPresetProperties ́AAskForTitlevpeB
  āA\ꂽBꂽ肷B
  ̌ʁAtH[gIɐLяk݂悤ɂȂĂB

  tH[̑傫ύXAƂꍇɂ́A
  U AutoSize = false ɂăTCYύXŁA
  K AutoSize = true ɖ߂ĂƁB
}

type
  TfrmReplacePresetEditor = class(TForm)
    pnlPairsEditor: TPanel;
    lvwPairs: TListView;
    btnAdd: TButton;
    btnDelete: TButton;
    btnMoveUp: TButton;
    btnMoveDown: TButton;
    StrReplaceFrame: TfrmStrReplaceFrame;
    pnlPresetProperties: TPanel;
    pnlOkCancelButtons: TPanel;
    btnOk: TButton;
    btnCancel: TButton;
    gbxPresetProperties: TGroupBox;
    cbxShortCut: TComboBox;
    edtTitle: TEdit;
    lblTitle: TLabel;
    lblShortCut: TLabel;
    cbxConfirmAfterReplace: TCheckBox;
    procedure btnAddClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnMoveUpClick(Sender: TObject);
    procedure btnMoveDownClick(Sender: TObject);
    procedure lvwPairsChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure btnOkClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    FPairs: TReplacePairCollection;
    procedure SetPairs(const Value: TReplacePairCollection);
    function GetAskForTitle: Boolean;
    function GetShortCut: TShortCut;
    function GetTitle: string;
    function GetConfirmAfterReplace: Boolean;
    procedure SetAskForTitle(const Value: Boolean);
    procedure SetShortCut(const Value: TShortCut);
    procedure SetTitle(const Value: string);
    procedure SetConfirmAfterReplace(const Value: Boolean);
  protected
    procedure MoveItem(const Delta: Integer);
    procedure UpdateControls;
    procedure UpdateListViewItem(Target: TListItem);
    procedure FollowEdit;
    procedure FrameUpdate(Sender: TObject);
  public
    constructor Create(AOwner: TCOmponent); override;
    destructor Destroy; override;
    property Pairs: TReplacePairCollection read FPairs write SetPairs;
    property Title: string read GetTitle write SetTitle;
    property ShortCut: TShortCut read GetShortCut write SetShortCut;
    property AskForTitle: Boolean read GetAskForTitle write SetAskForTitle;
    property ConfirmAfterReplace: Boolean read GetConfirmAfterReplace write SetConfirmAfterReplace;
    function Execute: Boolean;
  end;

implementation

{$R *.dfm}

{ TfrmReplacePresetEditor }

constructor TfrmReplacePresetEditor.Create(AOwner: TCOmponent);
begin
  inherited;
  FPairs := TReplacePairCollection.Create(TReplacePair);
end;

destructor TfrmReplacePresetEditor.Destroy;
begin
  FPairs.Free;
  inherited;
end;

procedure TfrmReplacePresetEditor.SetPairs(const Value: TReplacePairCollection);
begin
  FPairs.Assign(Value);
  UpdateControls;
end;

procedure TfrmReplacePresetEditor.UpdateControls;
var
  i, SelectedIndex: Integer;
begin
  if lvwPairs.Selected <> nil then
    SelectedIndex := lvwPairs.Selected.Index
  else
    SelectedIndex := -1;
  with lvwPairs.Items do
  begin
    Clear;
    BeginUpdate;
    try
      for i := 0 to FPairs.Count-1 do
      begin
        UpdateListViewItem(Add);
      end;
      if (SelectedIndex > -1) and (lvwPairs.Selected <> nil) then
        if (lvwPairs.Selected.Index <> SelectedIndex) and
        (lvwPairs.Items.Count-1 > SelectedIndex) then
          lvwPairs.Items[SelectedIndex].Selected := true; 
    finally
      EndUpdate;
    end;
  end;
end;

procedure TfrmReplacePresetEditor.btnAddClick(Sender: TObject);
var
  New: TListItem;
begin
  // VĂI
  StrReplaceFrame.OnContentUpdate := nil;
  try
    StrReplaceFrame.Pair := FPairs.Add;
    New := lvwPairs.Items.Add;
    lvwPairs.Selected := New;
    UpdateListViewItem(New);
    // tH[JXړAҏWJn
    StrReplaceFrame.edtOldPattern.SetFocus;
  finally
    StrReplaceFrame.OnContentUpdate := FrameUpdate;
  end;
end;

procedure TfrmReplacePresetEditor.UpdateListViewItem(Target: TListItem);
var
  Pair: TReplacePair;
begin
  with Target do
  begin
    lvwPairs.Items.BeginUpdate;
    try
      Pair := FPairs[Target.Index];
      Caption := Pair.BeforeStr;
      SubItems.Clear;
      SubItems.Add(Pair.AfterStr);
      if Pair.UseRegExp then
        SubItems.Add('Y')
      else
        SubItems.Add('-');
      if not Pair.IgnoreCase then
        SubItems.Add('Y')
      else
        SubItems.Add('-');
    finally
      lvwPairs.Items.EndUpdate;
    end;
  end;
end;

procedure TfrmReplacePresetEditor.btnDeleteClick(Sender: TObject);
var
  TargetIndex: Integer;
begin
  if lvwPairs.Selected = nil then
    Exit;
  TargetIndex := lvwPairs.Selected.Index;
  FPairs.Delete(TargetIndex);
  lvwPairs.Items.Delete(TargetIndex);
end;

procedure TfrmReplacePresetEditor.btnMoveUpClick(Sender: TObject);
begin
  MoveItem(-1);
end;

procedure TfrmReplacePresetEditor.btnMoveDownClick(Sender: TObject);
begin
  MoveItem(1);
end;

procedure TfrmReplacePresetEditor.lvwPairsChange(Sender: TObject;
  Item: TListItem; Change: TItemChange);
begin
  if Change <> ctState then
    Exit;
  with StrReplaceFrame do
  begin
    if lvwPairs.Selected = nil then
    begin
      Enabled := false;
    end else
    begin
      Enabled := true;
      Pair := FPairs[lvwPairs.Selected.Index];
    end;
  end;
end;

function TfrmReplacePresetEditor.Execute: Boolean;
begin
  UpdateControls;
  StrReplaceFrame.OnContentUpdate := FrameUpdate; 
  if lvwPairs.Items.Count > 0 then
  begin
    lvwPairs.Items[0].Selected := true;
  end;
  Result := ShowModal = mrOk;
end;

procedure TfrmReplacePresetEditor.btnOkClick(Sender: TObject);
var
  i: integer;
begin
  if Pairs.Count = 0 then
  begin
    ShowMessage('Œ1̒u[ݒ肵Ă');
    Exit;
  end;
  for i := 0 to Pairs.Count-1 do
    if not Pairs[i].IsValidPair then
    begin
      ShowMessage(Format('%dԖڂ̕yAɃG[܂', [i+1]));
      Exit;
    end;
  if AskForTitle and (Title = '') then
  begin
    ShowMessage('vZbg̃^Cgw肵Ă');
    Exit;
  end;
  ModalResult := mrOk;
end;

procedure TfrmReplacePresetEditor.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TfrmReplacePresetEditor.FollowEdit;
var
  CurrentPair: TReplacePair;
begin
  if lvwPairs.Selected <> nil then
  begin
    CurrentPair := FPairs[lvwPairs.Selected.Index];
    CurrentPair.Assign(StrReplaceFrame.Pair);
    UpdateListViewItem(lvwPairs.Selected);
  end;
end;

procedure TfrmReplacePresetEditor.FrameUpdate(Sender: TObject);
begin
  FollowEdit;
end;

procedure TfrmReplacePresetEditor.MoveItem(const Delta: Integer);
var
  TargetIndex: Integer;
  Item: TReplacePair;
begin
  if lvwPairs.Selected = nil then
    Exit;
  StrReplaceFrame.OnContentUpdate := nil;
  try
    TargetIndex := lvwPairs.Selected.Index;
    // ͈̓`FbN
    if (Delta < 0) and (TargetIndex < -Delta) then
      Exit;
    if (Delta > 0) and (TargetIndex >= Pairs.Count-Delta) then
      Exit;
    if Delta = 0 then
      Exit; // ꉞ
    // URNVO
    Item := FPairs.Items[TargetIndex];
    Item.Collection := nil;
    // VINSERTVKڂɑ
    FPairs.Insert(TargetIndex + Delta).Assign(Item);
    UpdateControls;
    // Xgr[̑IACe𓮂
    lvwPairs.Items[TargetIndex + Delta].Selected := true;
  finally
    StrReplaceFrame.OnContentUpdate := FrameUpdate;
  end;
end;

function TfrmReplacePresetEditor.GetAskForTitle: Boolean;
begin
  Result := pnlPresetProperties.Visible;
end;

function TfrmReplacePresetEditor.GetShortCut: TShortCut;
begin
  Result := TextToShortCut(cbxShortCut.Text);
end;

function TfrmReplacePresetEditor.GetTitle: string;
begin
  Result := edtTitle.Text;
end;

procedure TfrmReplacePresetEditor.SetAskForTitle(const Value: Boolean);
begin
  pnlPresetProperties.Visible := Value;
end;

procedure TfrmReplacePresetEditor.SetShortCut(const Value: TShortCut);
begin
  cbxShortCut.Text := ShortCutToText(Value);
end;

procedure TfrmReplacePresetEditor.SetTitle(const Value: string);
begin
  edtTitle.Text := Value;
end;

procedure TfrmReplacePresetEditor.SetConfirmAfterReplace(const Value: Boolean);
begin
  cbxConfirmAfterReplace.Checked := Value;
end;

function TfrmReplacePresetEditor.GetConfirmAfterReplace: Boolean;
begin
  result := cbxConfirmAfterReplace.Checked;
end;

procedure TfrmReplacePresetEditor.FormCreate(Sender: TObject);
begin
  BuildShortCutList(cbxShortCut.Items);
end;

end.
