unit ScriptConsts;

{
{gXNvg^ێEB
}

interface

uses Windows, Classes, SysUtils, Contnrs, Menus, Dialogs;

type
  EScriptConstFileError = class(Exception);

  TScriptConst = class(TPersistent) // ʂ̒^
  private
    FConstText: String;
    FShortCut: TShortCut;
    FCaption: String;
    FID: integer;
    procedure SetCaption(const Value: String);
    procedure SetConstText(const Value: String);
    procedure SetShortCut(const Value: TShortCut);
  public
    constructor Create;
    property Caption: String read FCaption write SetCaption;
    property ShortCut: TShortCut read FShortCut write SetShortCut;
    property ConstText: String read FConstText write SetConstText;
    property ID: integer read FID;
    function ToString: String;               // \ɕϊ
    procedure FromString(const Str: String); // ǂݏo
    procedure Assign(Source: TPersistent); override;
  end;

  TScriptConstMenu = class(TObject) // BTScriptConst̃XgB
  private
    FConsts: TObjectList;
    FCaption: String;
    FIfGhost: String;
    FID: integer;
    function GetCount: integer;
    function GetConsts(Index: integer): TScriptConst;
    procedure SetCaption(const Value: String);
    procedure SetIfGhost(const Value: String);
  public
    constructor Create;
    destructor Destroy; override;
    property ID: integer read FID;
    property Count: integer read GetCount;
    property Consts[Index: integer]: TScriptConst read GetConsts; default;
    property List: TObjectList read FConsts;
    property Caption: String read FCaption write SetCaption;
    property IfGhost: String read FIfGhost write SetIfGhost;
    procedure Load(Lines: TStrings);
    procedure Save(Lines: TStrings);
    procedure Delete(const ID: integer);
    function GetConstByID(const ID: integer): TScriptConst;
    function AddConst: TScriptConst;
  end;

  TScriptConstFile = class(TObject) // qBTScriptConstMenũXgB
  private
    FMenus: TObjectList;
    FFileName: String;
    function GetMenus(Index: integer): TScriptConstMenu;
    function GetCount: integer;
    procedure SetFileName(const Value: String);
  public
    constructor Create;
    destructor Destroy; override;
    property FileName: String read FFileName write SetFileName;
    property Count: integer read GetCount;
    property Menus[Index: integer]: TScriptConstMenu read GetMenus; default;
    property List: TObjectList read FMenus;
    procedure LoadFromFile(LoadFileName: String);
    procedure SaveToFile;
    procedure Delete(const ID: integer);
    procedure MoveUp(const ID: integer);
    procedure MoveDown(const ID: integer);
    function GetConstByID(const ID: integer): TScriptConst;
    function GetMenuByID(const ID: integer): TScriptConstMenu;
    function AddMenu: TScriptConstMenu;
  end;

  TScriptConstList = class(TObject) // eBScriptConstFilẽXgB
  private
    FFiles: TObjectList;
    function GetCount: integer;
    function GetFiles(Index: integer): TScriptConstFile;
  public
    constructor Create;
    destructor Destroy; override;
    procedure LoadFromDir(const Dir: String);
    procedure Save;
    property Files[Index: integer]: TScriptConstFile read GetFiles; default;
    property Count: integer read GetCount;
    property List: TObjectList read FFiles;
    function GetConstByID(const ID: integer): TScriptConst;
    function GetMenuByID(const ID: integer): TScriptConstMenu;
    procedure Delete(const ID: integer);
  end;

var
  ScriptConstList: TScriptConstList;

implementation

var OldID: integer; // ^̓IDBTagɓp


// PɃoCgPʂŕĂ郆[eBeB֐
function Token(const Str: String; const Delimiter: char;
  const Index: integer): String;
var i, c, len: integer;
begin
  i := 1;
  c := 0;
  len := length(Str);
  Result := '';
  while i <= len do begin
    if (Str[i] = Delimiter) and (StrByteType(PChar(Str), i) <> mbTrailByte) then begin
      Inc(c);
      if c > Index then Break;
    end else if c = Index then Result := Result + Str[i];
    Inc(i);
  end;
end;

{ TScriptConstList }

constructor TScriptConstList.Create;
begin
  FFiles := TObjectList.Create(true);
end;

procedure TScriptConstList.Delete(const ID: integer);
var i: integer;
begin
  for i := Count-1 downto 0 do begin
    Files[i].Delete(ID);
  end;
end;

destructor TScriptConstList.Destroy;
begin
  FreeAndNil(FFiles);
  inherited;
end;

function TScriptConstList.GetConstByID(const ID: integer): TScriptConst;
var i: integer;
begin
  Result := nil;
  for i := 0 to Count-1 do begin
    Result := Files[i].GetConstByID(ID);
    if Result <> nil then Exit;
  end;
end;

function TScriptConstList.GetCount: integer;
begin
  Result := FFiles.Count;
end;

function TScriptConstList.GetFiles(Index: integer): TScriptConstFile;
begin
  Result := FFiles[Index] as TScriptConstFile;
end;

function TScriptConstList.GetMenuByID(const ID: integer): TScriptConstMenu;
var i: integer;
begin
  Result := nil;
  for i := 0 to Count-1 do begin
    Result := Files[i].GetMenuByID(ID);
    if Result <> nil then Exit;
  end;
end;

procedure TScriptConstList.LoadFromDir(const Dir: String);
var F: TSearchRec;
    i: integer;
    AFile: TScriptConstFile;
begin
  FFiles.Clear;
  i := FindFirst(Dir + '\*.txt', 0, F);
  if i = 0 then begin
    repeat
      AFile := nil;
      try
        AFile := TScriptConstFile.Create;
        AFile.LoadFromFile(Dir + '\' + F.Name);
      except
        AFile.Free;
      end;
      FFiles.Add(AFile);
      i := FindNext(F);
    until i <> 0;
  end;
  FindClose(F);
end;

procedure TScriptConstList.Save;
var i: integer;
begin
  for i := 0 to FFiles.Count-1 do begin
    Files[i].SaveToFile;
  end;
end;

{ TScriptConst }

procedure TScriptConst.Assign(Source: TPersistent);
begin
  inherited;
  if not (Source is TScriptConst) then Exit;
  with (Source as TScriptConst) do begin
    self.Caption := Caption;
    self.ShortCut := ShortCut;
    self.ConstText := ConstText;
  end;
end;

constructor TScriptConst.Create;
begin
  // ^ID𐶐
  // TMenuItemTagɓ邱ƂŃj[ڂɑΉTScriptConst
  // m邱Ƃł
  FID := OldID+1;
  OldID := OldID+1;
end;

procedure TScriptConst.FromString(const Str: String);
begin
  if Str[1] <> #9 then
    raise EScriptConstFileError.Create('^t@C͂ł܂: ' + Str);
  ShortCut  := TextToShortCut(Token(Str, #9, 1));
  Caption   := Token(Str, #9, 2);
  ConstText := Token(Str, #9, 3);
  if (Length(Caption) = 0) or (Length(ConstText) = 0) then
    raise EScriptConstFileError.Create('^t@C͂ł܂: ' + Str);
end;

procedure TScriptConst.SetCaption(const Value: String);
begin
  FCaption := Value;
end;

procedure TScriptConst.SetConstText(const Value: String);
begin
  FConstText := Value;
end;

procedure TScriptConst.SetShortCut(const Value: TShortCut);
begin
  FShortCut := Value;
end;

function TScriptConst.ToString: String;
begin
  Result := #9 + ShortCutToText(ShortCut) + #9 + Caption + #9 + ConstText;
end;

{ TScriptConstFile }

function TScriptConstFile.AddMenu: TScriptConstMenu;
begin
  Result := TScriptConstMenu.Create;
  Result.Caption := 'VO[v';
  Result.IfGhost := '';
  FMenus.Add(Result);
end;

constructor TScriptConstFile.Create;
begin
  FMenus := TObjectList.Create(true);
end;

procedure TScriptConstFile.Delete(const ID: integer);
var i: integer;
begin
  for i := FMenus.Count-1 downto 0 do begin
    Menus[i].Delete(ID); // Item폜(悤Ƃ)
    if Menus[i].ID = ID then begin
      FMenus.Delete(i);  // Menu폜
      Exit;
    end;
  end;
end;

destructor TScriptConstFile.Destroy;
begin
  FreeAndNil(FMenus);
  inherited;
end;

function TScriptConstFile.GetConstByID(const ID: integer): TScriptConst;
var i: integer;
begin
  Result := nil;
  for i := 0 to Count-1 do begin
    Result := Menus[i].GetConstByID(ID);
    if Result <> nil then Exit;
  end;
end;

function TScriptConstFile.GetCount: integer;
begin
  Result := FMenus.Count;
end;

function TScriptConstFile.GetMenuByID(const ID: integer): TScriptConstMenu;
var i: integer;
begin
  Result := nil;
  for i := 0 to Count-1 do
    if Menus[i].ID = ID then begin
      Result := Menus[i];
      Exit;
    end;
end;

function TScriptConstFile.GetMenus(Index: integer): TScriptConstMenu;
begin
  Result := FMenus[Index] as TScriptConstMenu;
end;

procedure TScriptConstFile.LoadFromFile(LoadFileName: String);
var Lines: TStringList;
    Menu: TScriptConstMenu;
begin
  Lines := nil;
  FMenus.Clear;
  try
    Lines := TStringList.Create;
    Lines.LoadFromFile(LoadFileName);
    while Lines.Count > 0 do begin
      Menu := TScriptConstMenu.Create;
      Menu.Load(Lines);
      FMenus.Add(Menu);
    end;
  finally
    Lines.Free;
  end;
  FileName := LoadFileName; // t@C͕ۑĂ
end;

procedure TScriptConstFile.MoveDown(const ID: integer);
var i, j: integer;
    ConstData: TObject;
begin
  for i := Count-1 downto 0 do begin
    if Menus[i].ID = ID then begin
      if i < Count-1 then FMenus.Move(i, i+1);
      Exit;
    end;
    for j := Menus[i].Count-1 downto 0 do begin
      if Menus[i][j].ID = ID then begin
        if j < Menus[i].Count-1 then
          Menus[i].List.Move(j, j+1) // ʂɃj[ňړ
        else if i < Count-1 then begin // j[𒴂Ĉړ
          ConstData := Menus[i][j];
          Menus[i].List.Extract(ConstData);
          Menus[i+1].List.Insert(0, ConstData);
          Exit;
        end;
      end;
    end;
  end;
end;

procedure TScriptConstFile.MoveUp(const ID: integer);
var i, j: integer;
    ConstData: TObject;
begin
  for i := 0 to Count-1 do begin
    if Menus[i].ID = ID then begin
      if i > 0 then FMenus.Move(i, i-1);
      Exit;
    end;
    for j := 0 to Menus[i].Count-1 do begin
      if Menus[i][j].ID = ID then begin
        if j > 0 then
          Menus[i].List.Move(j, j-1) // ʂɃj[ňړ
        else if i > 0 then begin // j[𒴂Ĉړ
          ConstData := Menus[i][j];
          Menus[i].List.Extract(ConstData);
          Menus[i-1].List.Add(ConstData);
          Exit;
        end;
      end;
    end;
  end;
end;

procedure TScriptConstFile.SaveToFile;
var Lines: TStringList;
    i: integer;
begin
  Lines := nil;
  try
    Lines := TStringList.Create;
    for i := 0 to FMenus.Count-1 do begin
      Menus[i].Save(Lines);
    end;
    Lines.SaveToFile(FileName);
  finally
    Lines.Free;
  end;
end;

procedure TScriptConstFile.SetFileName(const Value: String);
begin
  FFileName := Value;
end;

{ TScriptConstMenu }

function TScriptConstMenu.AddConst: TScriptConst;
begin
  Result := TScriptConst.Create;
  Result.Caption := '^';
  Result.ConstText := 'XNvg';
  FConsts.Add(Result);
end;

constructor TScriptConstMenu.Create;
begin
  FID := OldID + 1;
  OldID := OldID + 1;
  FConsts := TObjectList.Create(true);
end;

procedure TScriptConstMenu.Delete(const ID: integer);
var i: integer;
begin
  for i := Count-1 downto 0 do begin
    if Consts[i].ID = ID then FConsts.Delete(i);
  end;
end;

destructor TScriptConstMenu.Destroy;
begin
  FreeAndNil(FConsts);
  inherited;
end;

function TScriptConstMenu.GetConstByID(const ID: integer): TScriptConst;
var i: integer;
begin
  Result := nil;
  for i := 0 to Count-1 do
    if Consts[i].ID = ID then begin
      Result := Consts[i];
      Exit;
    end;
end;

function TScriptConstMenu.GetConsts(Index: integer): TScriptConst;
begin
  Result := FConsts[Index] as TScriptConst;
end;

function TScriptConstMenu.GetCount: integer;
begin
  Result := FConsts.Count;
end;

procedure TScriptConstMenu.Load(Lines: TStrings);
var ConstItem: TScriptConst;
begin
  if Lines.Count = 0 then Exit;
  FConsts.Clear;
  Caption := Token(Lines[0], #9, 0);
  IfGhost := Token(Lines[0], #9, 1);
  Lines.Delete(0);
  while Lines.Count > 0 do begin
    if Lines[0][1] = #9 then begin
      ConstItem := nil;
      try
        ConstItem := TScriptConst.Create;
        ConstItem.FromString(Lines[0]);
        FConsts.Add(ConstItem);
      except
        ConstItem.Free;
      end;
      Lines.Delete(0);
    end else Break;
  end;
end;

procedure TScriptConstMenu.Save(Lines: TStrings);
var i: integer;
begin
  if IfGhost <> '' then
    Lines.Add(Caption + #9 + IfGhost)
  else
    Lines.Add(Caption); //ߋ݊̂߈ꉞ#9͖ʂɂȂ
  for i := 0 to FConsts.Count-1 do Lines.Add(Consts[i].ToString);
end;

procedure TScriptConstMenu.SetCaption(const Value: String);
begin
  FCaption := Value;
end;

procedure TScriptConstMenu.SetIfGhost(const Value: String);
begin
  FIfGhost := Value;
end;

initialization

ScriptConstList := TScriptConstList.Create;
OldID := 0;

finalization

ScriptConstList.Free;

end.
