unit SearchLog;

// uǑvtH[ƁǍ

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Spin, BottleDef, RegexUtils;

type
  // \NXB
  // ŉ炩̕@ŉi邩Ȃ̂ŕʃNXɂ
  TSearchLogRange = (srSelectedLogList, srAboveSelectedLog, srAllLogLists);

  TSearchCond = class(TComponent)
  private
    FScriptRegExp: boolean;
    FMinLength: integer;
    FMaxLength: integer;
    FGhost: String;
    FChannel: String;
    FScriptPattern: String;
    FMinVote: integer;
    FMinAgree: integer;
    FSearchLogRange: TSearchLogRange;
    procedure SetChannel(const Value: String);
    procedure SetGhost(const Value: String);
    procedure SetMaxLength(const Value: integer);
    procedure SetMinLength(const Value: integer);
    procedure SetScriptPattern(const Value: String);
    procedure SetScriptRegExp(const Value: boolean);
    procedure SetMinAgree(const Value: integer);
    procedure SetMinVote(const Value: integer);
    procedure SetSearchLogRange(const Value: TSearchLogRange);
  public
    procedure Assign(Source: TPersistent); override;
    function IsInvalidCondition: boolean;
  published
    property ScriptPattern: String read FScriptPattern write SetScriptPattern;
    property ScriptRegExp: boolean read FScriptRegExp write SetScriptRegExp;
    property Channel: String read FChannel write SetChannel;
    property Ghost: String read FGhost write SetGhost;
    property MinLength: integer read FMinLength write SetMinLength; //
    property MaxLength: integer read FMaxLength write SetMaxLength; //
    property MinVote: integer read FMinVote write SetMinVote;
    property MinAgree: integer read FMinAgree write SetMinAgree;
    property SearchLogRange: TSearchLogRange read FSearchLogRange write SetSearchLogRange;
  end;

  // ǑtH[
  TfrmSearchLog = class(TForm)
    btnOk: TButton;
    btnCancel: TButton;
    gbxCondition: TGroupBox;
    lblScriptPattern: TLabel;
    lblChannel: TLabel;
    lblGhost: TLabel;
    edtScriptPattern: TEdit;
    cbxScriptRegExp: TCheckBox;
    cbxGhost: TComboBox;
    cbxChannel: TComboBox;
    rgpSearchLogRange: TRadioGroup;
    lblMinVote: TLabel;
    lblMinAgree: TLabel;
    spnMinVote: TSpinEdit;
    spnMinAgree: TSpinEdit;
    lblMinVote2: TLabel;
    lblMinAgree2: TLabel;
    procedure btnOkClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    FCondition: TSearchCond;
    procedure SetCondition(const Value: TSearchCond);
    procedure SetChannelList(const Value: TStrings);
    procedure SetGhostList(const Value: TStrings);
    function GetChannelList: TStrings;
    function GetGhostList: TStrings;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute: boolean;
    property Condition: TSearchCond read FCondition write SetCondition;
    property GhostList: TStrings read GetGhostList write SetGhostList;
    property ChannelList: TStrings read GetChannelList write SetChannelList;
  end;

var
  frmSearchLog: TfrmSearchLog;

implementation

{$R *.dfm}

{ TSearchCond }

procedure TSearchCond.Assign(Source: TPersistent);
var
  Src: TSearchCond;
begin
  if not (Source is TSearchCond) then
    inherited
  else
  begin
    Src := Source as TSearchCond;
    FScriptPattern := Src.ScriptPattern;
    FScriptRegExp  := Src.ScriptRegExp;
    FChannel       := Src.Channel;
    FGhost         := Src.Ghost;
    FMinLength     := Src.MinLength;
    FMaxLength     := Src.MaxLength;
    FMinVote       := Src.MinVote;
    FMinAgree      := Src.MinAgree;
    SearchLogRange := Src.SearchLogRange;
  end;
end;

function TSearchCond.IsInvalidCondition: boolean;
begin
  // ۂ̏ł͂ȂƂ`FbN
  Result := true;
  if ScriptPattern <> '' then
    Result := false;
  if (Channel <> '') or (Ghost <> '') then
    Result := false;
  if (MinVote > 0) or (MinAgree > 0) then
    Result := false;
  { if (MinLength > 0) or (MaxLength > 0) then
    Result := false; }
end;

procedure TSearchCond.SetChannel(const Value: String);
begin
  FChannel := Value;
end;

procedure TSearchCond.SetGhost(const Value: String);
begin
  FGhost := Value;
end;

procedure TSearchCond.SetMaxLength(const Value: integer);
begin
  FMaxLength := Value;
end;

procedure TSearchCond.SetMinAgree(const Value: integer);
begin
  FMinAgree := Value;
end;

procedure TSearchCond.SetMinLength(const Value: integer);
begin
  FMinLength := Value;
end;

procedure TSearchCond.SetMinVote(const Value: integer);
begin
  FMinVote := Value;
end;

procedure TSearchCond.SetScriptPattern(const Value: String);
begin
  FScriptPattern := Value;
end;

procedure TSearchCond.SetScriptRegExp(const Value: boolean);
begin
  FScriptRegExp := Value;
end;

{ TTfrmSearchLog }

function TfrmSearchLog.Execute: boolean;
var
  Backup: TSearchCond;
begin
  // LZɐݒ肪ςȂ悤ɃobNAbv
  Backup := TSearchCond.Create(nil);
  try
    Backup.Assign(Condition);
    with Condition do
    begin
      edtScriptPattern.Text   := ScriptPattern;
      cbxScriptRegExp.Checked := ScriptRegExp;
      cbxChannel.Text   := Channel;
      cbxGhost.Text     := Ghost;
      spnMinVote.Value  := MinVote;
      spnMinAgree.Value := MinAgree;
      rgpSearchLogRange.ItemIndex := Ord(SearchLogRange);
    end;
    Result := ShowModal = mrOk;
    // LZɂ͐ݒɖ߂
    if not Result then
      Condition.Assign(Backup);
  finally
    Backup.Free;
  end;
end;

procedure TfrmSearchLog.SetCondition(const Value: TSearchCond);
begin
  FCondition.Assign(Value);
end;

procedure TfrmSearchLog.btnOkClick(Sender: TObject);
var ErrorMsg, CheckScriptPattern :String;
begin
  // OKŃEBhE
  with Condition do
  begin
    CheckScriptPattern := edtScriptPattern.Text;
    ScriptRegExp  := cbxScriptRegExp.Checked;
    Channel  := cbxChannel.Text;
    Ghost    := cbxGhost.Text;
    MinVote  := spnMinVote.Value;
    MinAgree := spnMinAgree.Value;
    SearchLogRange := TSearchLogRange(rgpSearchLogRange.ItemIndex);

    if ScriptRegExp and (CheckScriptPattern <> '') then
    begin
      ErrorMsg := SafeAndCheckRegExp(CheckScriptPattern);
      if ErrorMsg <> '' then begin
        ShowMessage('K\Ɍ肪܂'#13#10 + ErrorMsg);
        Exit;
      end;
    end;
    ScriptPattern := CheckScriptPattern;
  end;
  if Condition.IsInvalidCondition then
    ShowMessage('w肵Ă')
  else
    ModalResult := mrOk;
end;

procedure TfrmSearchLog.btnCancelClick(Sender: TObject);
begin
  // ʃLZŃEBhE
  ModalResult := mrCancel;
end;

procedure TfrmSearchLog.SetChannelList(const Value: TStrings);
begin
  cbxChannel.Items.Assign(Value);
end;

procedure TfrmSearchLog.SetGhostList(const Value: TStrings);
begin
  cbxGhost.Items.Assign(Value);
end;

constructor TfrmSearchLog.Create(AOwner: TComponent);
begin
  inherited;
  FCondition := TSearchCond.Create(nil);
end;

destructor TfrmSearchLog.Destroy;
begin
  FCondition.Free;
  inherited;
end;

function TfrmSearchLog.GetChannelList: TStrings;
begin
  Result := cbxChannel.Items;
end;

function TfrmSearchLog.GetGhostList: TStrings;
begin
  Result := cbxGhost.Items;
end;

procedure TSearchCond.SetSearchLogRange(const Value: TSearchLogRange);
begin
  FSearchLogRange := Value;
end;

end.
