unit SendConfirm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, BottleDef, SppList;

type
  TfrmConfirmSend = class(TForm)
    btnOk: TButton;
    btnCancel: TButton;
    cbxDontAlertAnyMore: TCheckBox;
    memPrompt: TMemo;
    memInfo: TMemo;
    pnlPreview: TPanel;
    Image: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private 錾 }
    FDefaultImage: TBitmap; // vr[pT[tBXȂꍇ̃{g摜
  public
    { Public 錾 }
    function Execute(const Channel, Ghost: String): boolean;
  end;

var
  frmConfirmSend: TfrmConfirmSend;

function SendConfirmDialog(const Channel, Ghost: String): boolean;

implementation

{$R *.DFM}

function SendConfirmDialog(const Channel, Ghost: String): boolean;
var MyfrmConfirmSend: TfrmConfirmSend;
begin
  Application.CreateForm(TfrmConfirmSend, MyfrmConfirmSend);
  with MyfrmConfirmSend do begin
    try
      cbxDontAlertAnyMore.Checked := Pref.NoConfirm;
      Result := Execute(Channel, Ghost);
      Pref.NoConfirm := cbxDontAlertAnyMore.Checked;
    finally
      Release;
    end;
  end;
end;

function TfrmConfirmSend.Execute(const Channel, Ghost: String): boolean;
var Mes: String;
    Bmp: TBitmap;
    SurfaceImageExists: boolean;
begin
  Bmp := TBitmap.Create;
  try
    if Ghost = ChannelDefault then
      SurfaceImageExists := false
    else
      SurfaceImageExists := Spps.TryGetImage(Ghost, 0, Bmp);
    if SurfaceImageExists then
      with Image do
      begin
        Picture.Bitmap := Bmp;
        if (Width < Bmp.Width) or (Height < Bmp.Height) then
        begin
          Stretch := true;
        end else
          Stretch := false;
        begin
        end;
      end
    else
      with Image do
      begin
        Picture.Bitmap := FDefaultImage;
        Stretch := false;
      end
  finally
    Bmp.Free;
  end;

  Mes := memInfo.Lines.Text;
  Mes := StringReplace(Mes, '%channel', Channel, [rfReplaceAll]);
  Mes := StringReplace(Mes, '%ghost', Ghost, [rfReplaceAll]);
  memInfo.Lines.Text := Mes;
  Result := ShowModal = mrOk;
end;

procedure TfrmConfirmSend.FormCreate(Sender: TObject);
begin
  FDefaultImage := TBitmap.Create;
  FDefaultImage.Assign(Image.Picture.Bitmap);
end;

procedure TfrmConfirmSend.FormDestroy(Sender: TObject);
begin
  FDefaultImage.Free;
end;

end.
