unit SpecialCharEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Spin, StdCtrls;

type
  TfrmSpecialCharEditor = class(TForm)
    btnOk: TButton;
    btnCancel: TButton;
    lblChar: TLabel;
    edtChar: TEdit;
    lblCost: TLabel;
    spnCost: TSpinEdit;
    procedure btnOkClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    FCost: integer;
    FSpecialChar: String;
    procedure SetCost(const Value: integer);
    procedure SetSpecialChar(const Value: String);
    { Private 錾 }
  public
    property SpecialChar: String read FSpecialChar write SetSpecialChar;
    property Cost: integer read FCost write SetCost;
    function Execute: boolean;
  end;

var
  frmSpecialCharEditor: TfrmSpecialCharEditor;

implementation

{$R *.dfm}

{ TForm1 }

function TfrmSpecialCharEditor.Execute: boolean;
begin
  spnCost.Value := Cost;
  edtChar.Text := SpecialChar;
  Result := ShowModal = mrOk;
end;

procedure TfrmSpecialCharEditor.SetCost(const Value: integer);
begin
  FCost := Value;
end;

procedure TfrmSpecialCharEditor.SetSpecialChar(const Value: String);
begin
  FSpecialChar := Value;
end;

procedure TfrmSpecialCharEditor.btnOkClick(Sender: TObject);
var
  OK: boolean;
begin
  OK := false;
  if (Length(edtChar.Text) = 1) and not (edtChar.Text[1] in LeadBytes) then
    OK := true;
  if (Length(edtChar.Text) = 2) and (edtChar.Text[1] in LeadBytes) then
    OK := true;
  SpecialChar := edtChar.Text;
  Cost := spnCost.Value;
  if OK then
    ModalResult := mrOk;
end;

procedure TfrmSpecialCharEditor.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

end.
