unit StrListEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Menus;

type
  TfrmStrListEditor = class(TForm)
    pnlHeader: TPanel;
    pnlFooter: TPanel;
    memStrings: TMemo;
    btnCancel: TButton;
    btnOk: TButton;
    lblCaption: TLabel;
    mnConst: TPopupMenu;
    btnConst: TButton;
    procedure memStringsChange(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnConstMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FCanAllowEmpty: boolean;
    FConsts: TStrings;
    procedure SetCanAllowEmpty(const Value: boolean);
    procedure SetConsts(const Value: TStrings);
    { Private 錾 }
  public
    { Public 錾 }
    procedure InsertConstItem(Sender: TObject);
    property CanAllowEmpty: boolean read FCanAllowEmpty write SetCanAllowEmpty;
    property Consts: TStrings read FConsts write SetConsts;
  end;

var
  frmStrListEditor: TfrmStrListEditor;

function StrListEdit(const List: TStrings; CaptionStr: String;
  AllowEmpty: boolean = false): boolean; overload;
function StrListEdit(const List: TStrings; CaptionStr: String;
  AllowEmpty: boolean; ConstList: TStrings): boolean; overload;

implementation

{$R *.dfm}

function StrListEdit(const List: TStrings; CaptionStr: String;
  AllowEmpty: boolean = false): boolean;
begin
  Result := StrListEdit(List, CaptionStr, AllowEmpty, nil);
end;

function StrListEdit(const List: TStrings; CaptionStr: String;
  AllowEmpty: boolean; ConstList: TStrings): boolean;
var MyfrmStrListEditor: TfrmStrListEditor;
begin
  Application.CreateForm(TfrmStrListEditor, MyfrmStrListEditor);
  with MyfrmStrListEditor do begin
    try
      CanAllowEmpty := AllowEmpty;
      lblCaption.Caption := CaptionStr;
      memStrings.Lines := List; // Using Assign method (of course)
      Consts := ConstList;
      Result := ShowModal = mrOk;
      if Result then List.Assign(memStrings.Lines);
    finally
      Release;
    end;
  end;
end;

procedure TfrmStrListEditor.memStringsChange(Sender: TObject);
begin
  btnOk.Enabled := (memStrings.Lines.Count > 0) or CanAllowEmpty;
end;

procedure TfrmStrListEditor.btnOkClick(Sender: TObject);
begin
  if (memStrings.Lines.Count = 0) and not CanAllowEmpty then Exit;
  ModalResult := mrOk;
end;

procedure TfrmStrListEditor.SetCanAllowEmpty(const Value: boolean);
begin
  FCanAllowEmpty := Value;
end;

procedure TfrmStrListEditor.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TfrmStrListEditor.btnConstMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var Pos: TPoint;
begin
  if Button <> mbLeft then Exit;
  if FConsts.Count = 0 then Exit;
  Pos := btnConst.ClientToScreen(Point(0, btnConst.Height));
  mnConst.Popup(Pos.X, Pos.Y);
end;

procedure TfrmStrListEditor.InsertConstItem(Sender: TObject);
begin
  memStrings.Lines.Add(Consts[(Sender as TMenuItem).Tag]);
end;

procedure TfrmStrListEditor.SetConsts(const Value: TStrings);
var i: integer;
    AMenu: TMenuItem;
begin
  if Value <> nil then begin
    FConsts.Assign(Value);
    mnConst.Items.Clear;
    for i := 0 to Consts.Count-1 do begin
      AMenu := TMenuItem.Create(self);
      with AMenu do begin
        Caption := Consts[i];
        Tag := i;
        OnClick := InsertConstItem;
        if (i mod 20 = 0) and (i > 0) then AMenu.Break := mbBarBreak;
      end;
      mnConst.Items.Add(AMenu);
    end;
    btnConst.Visible := true;
    btnConst.Enabled := FConsts.Count > 0;
  end else begin
    FConsts.Clear;
    btnConst.Visible := false;
  end;
end;

procedure TfrmStrListEditor.FormCreate(Sender: TObject);
begin
  FConsts := TStringList.Create;
end;

procedure TfrmStrListEditor.FormDestroy(Sender: TObject);
begin
  FConsts.Free;
end;

end.
