unit StrReplaceFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls, StrReplace;

type
  TfrmStrReplaceFrame = class(TFrame)
    edtNewPattern: TEdit;
    edtOldPattern: TEdit;
    lblOldPattern: TLabel;
    lblNewPattern: TLabel;
    cbxUseRegExp: TCheckBox;
    cbxDontIgnoreCase: TCheckBox;
    procedure ContentUpdate(Sender: TObject);
  private
    FPair: TReplacePair;
    FOnContentUpdate: TNotifyEvent;
    FUpdateCount: Integer;
    procedure SetPairRec(const Value: TReplacePair);
    procedure UpdateControls;
    procedure ControlsToData;
    function GetPairRec: TReplacePair;
    procedure SetOnContentUpdate(const Value: TNotifyEvent);
  protected
    procedure BeginUpdate;
    procedure EndUpdate;
    procedure SetEnabled(Value: boolean); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Pair: TReplacePair read GetPairRec write SetPairRec;
    property OnContentUpdate: TNotifyEvent read FOnContentUpdate
      write SetOnContentUpdate;
  end;

implementation

{$R *.dfm}

{ TfrmStrReplaceFrame }

procedure TfrmStrReplaceFrame.ControlsToData;
begin
  with FPair do
  begin
    BeforeStr  := edtOldPattern.Text;
    AfterStr   := edtNewPattern.Text;
    UseRegExp  := cbxUseRegExp.Checked;
    IgnoreCase := not cbxDontIgnoreCase.Checked;
  end;
end;

constructor TfrmStrReplaceFrame.Create(AOwner: TComponent);
begin
  inherited;
  FPair := TReplacePair.Create(nil);
end;

destructor TfrmStrReplaceFrame.Destroy;
begin
  FPair.Free;
  inherited;
end;

function TfrmStrReplaceFrame.GetPairRec: TReplacePair;
begin
  ControlsToData;
  Result := FPair;
end;

procedure TfrmStrReplaceFrame.SetOnContentUpdate(const Value: TNotifyEvent);
begin
  FOnContentUpdate := Value;
end;

procedure TfrmStrReplaceFrame.SetPairRec(const Value: TReplacePair);
begin
  FPair.Assign(Value);
  UpdateControls;
end;

procedure TfrmStrReplaceFrame.UpdateControls;
begin
  with FPair do
  begin
    BeginUpdate;
    try
      edtOldPattern.Text := BeforeStr;
      edtNewPattern.Text := AfterStr;
      cbxUseRegExp.Checked := UseRegExp;
      cbxDontIgnoreCase.Checked := not IgnoreCase;
    finally
      EndUpdate;
    end;
  end;
end;

procedure TfrmStrReplaceFrame.ContentUpdate(Sender: TObject);
begin
  if Assigned(FOnContentUpdate) and (FUpdateCount = 0) then
    FOnContentUpdate(Self);
end;

procedure TfrmStrReplaceFrame.BeginUpdate;
begin
  Inc(FUpdateCount);
end;

procedure TfrmStrReplaceFrame.EndUpdate;
begin
  Dec(FUpdateCount);
  if FUpdateCount = 0 then
    ContentUpdate(Self);
end;

procedure TfrmStrReplaceFrame.SetEnabled(Value: boolean);
begin
  if Enabled <> Value then
  begin
    edtOldPattern.Enabled := Value;
    edtNewPattern.Enabled := Value;
    cbxUseRegExp.Enabled := Value;
    cbxDontIgnoreCase.Enabled := Value;
    inherited SetEnabled(Value);
  end;
end;

end.
