unit SurfacePreview;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TfrmSurfacePreview = class(TForm)
    Image: TImage;
    Timer: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Private 錾 }
    FIsHidden: boolean;
  public
    { Public 錾 }
    procedure HideAway;
    procedure ShowPreview(Bmp: TBitmap; X, Y: integer);
    function IsHidden: boolean;
  end;

var
  frmSurfacePreview: TfrmSurfacePreview;

implementation

{$R *.dfm}

procedure TfrmSurfacePreview.FormCreate(Sender: TObject);
begin
  HideAway;
end;

procedure TfrmSurfacePreview.HideAway;
begin
  // Ƃ肠ȂƂɓ
  // ̃EBhÉAShow/HideĂ̂ł͂ȂāA
  // ۂɂ͕ƒnɈړĂ邾łB
  // (Show/Hide\bhgƃtH[JXڂ肵Ėʓ|Ȃ̂)
  Left := Low(smallint);
  Top := Low(smallint);
  FIsHidden := true;
end;

function TfrmSurfacePreview.IsHidden: boolean;
begin
  Result := FIsHidden;
end;

procedure TfrmSurfacePreview.ShowPreview(Bmp: TBitmap; X, Y: integer);
begin
  Image.Picture.Graphic := Bmp;
  ClientWidth := Bmp.Width;
  ClientHeight := Bmp.Height;
  Self.Left := X;
  Self.Top := Y;
  FIsHidden := false;

  // ŏ^C}[Zbg
  Timer.Enabled := false; // 񂱂ŌvZbg
  Timer.Enabled := true;
end;

procedure TfrmSurfacePreview.TimerTimer(Sender: TObject);
begin
  HideAway;
end;

end.
