unit TalkShowFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls, SsParser, ExtCtrls, SppList, Logs,
  BottleDef;

type
  TfrmTalkShow = class(TFrame)
    PanelBevel: TPanel;
    PaintBox: TPaintBox;
    ScrollBar: TScrollBar;
    procedure PaintBoxPaint(Sender: TObject);
    procedure ScrollBarChange(Sender: TObject);
    procedure FrameResize(Sender: TObject);
    procedure ScrollBarEnter(Sender: TObject);
  private
    FSsParser: TSsParser;
    FGhost: String;
    FScript: String;
    FWholeHeight: integer;
    FBuffer: TBitmap;
    FPrevControl: TWinControl;
    procedure SetSsParser(const Value: TSsParser);
    procedure SetPrevControl(const Value: TWinControl);
  protected
    function DrawSingleTalk(VertPos: integer;
      Sur0, Sur1: integer; Talk: String): integer;
    function DrawSingleImage(X, Y, Surface: integer;
      var Height: integer): integer;
    function DrawSeparateLine(VertPos: integer): integer;
  public
    { Public 錾 }
    // XNvg̉͂Ɏgp[T
    property SsParser: TSsParser read FSsParser write SetSsParser;
    // XN[o[NbNꂽŃtH[JXړRg[
    // XN[o[̂tH[JXĂ܂Ȃ߂̑[u
    property PrevControl: TWinControl read FPrevControl write SetPrevControl;
    procedure View(ALog: TLogItem); overload;
    procedure View(Script, Ghost: String); overload;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetPreviewFont(Font: TFont);
  end;

implementation

{$R *.dfm}

{ TfrmTalkShow }

procedure TfrmTalkShow.SetSsParser(const Value: TSsParser);
begin
  FSsParser := Value;
end;

procedure TfrmTalkShow.View(ALog: TLogItem);
begin
  if (ALog.Ghost = FGhost) and (ALog.Script = FScript) then
    Exit;
  FGhost := ALog.Ghost;
  FScript := ALog.Script;
  FWholeHeight := -1; // `
  PaintBoxPaint(self);
end;

procedure TfrmTalkShow.PaintBoxPaint(Sender: TObject);
var i, y, sur, sur0, sur1: integer;
    UnyuTalking, InSync: boolean;
    Talk: String;
  procedure TalkEnd;
  begin
    if FWholeHeight > 0 then // 2xڈȍ~̕`ł
      if (i < FSsParser.Count) and
         (StrToInt(FSsParser.Extra[i]) < ScrollBar.Position) then
      begin
        y := StrToInt(FSsParser.Extra[i]) - ScrollBar.Position;
        Talk := '';
        Exit;
      end;
    if Talk <> '' then
    begin
      if InSync then
      begin
        FBuffer.Canvas.Font.Color := Pref.TalkColorS;
        y := y + DrawSingleTalk(y, sur0, sur1, Talk) + 5
      end else if UnyuTalking then
      begin
        FBuffer.Canvas.Font.Color := Pref.TalkColorU;
        y := y + DrawSingleTalk(y, -1, sur1, Talk) + 5
      end else begin
        FBuffer.Canvas.Font.Color := Pref.TalkColorH;
        y := y + DrawSingleTalk(y, sur0, -1, Talk) + 5;
      end;
      Talk := '';
    end;
  end;
begin
  // 
  FBuffer.Width  := PaintBox.Width;
  FBuffer.Height := PaintBox.Height;

  with FBuffer.Canvas do
  begin
    Brush.Color := Pref.BgColor;
    Brush.Style := bsSolid;
    FillRect(Rect(0, 0, PaintBox.Width, PaintBox.Height));
    Brush.Style := bsClear;
  end;
  if FSsParser.InputString <> FScript then
  begin
    with FSsParser do
    begin
      LeaveEscape := false;
      EscapeInvalidMeta := false;
      InputString := FScript;
    end;
  end;

  if FWholeHeight < 0 then // -1͖`
    y := 2
  else
    y := - ScrollBar.Position + 2;
  sur0 := 0;  // XR[v0T[tBX
  sur1 := 10; // XR[v1T[tBX
  Talk := '';
  UnyuTalking := false;
  InSync := false;
  //
  i := 0;
  while i < FSsParser.Count do
  begin
    case FSsParser.MarkUpType[i] of
      mtTag:
        begin
          if (FSsParser[i] = '\h') and UnyuTalking then
          begin
            if not InSync then
              TalkEnd;
            UnyuTalking := false;
          end else if (FSsParser[i] = '\u') and not UnyuTalking then
          begin
            if not InSync then
              TalkEnd;
            UnyuTalking := true;
          end else if FSsParser[i] = '\_s' then
          begin
            TalkEnd;
            InSync := not InSync;
          end else if (FSsParser.Match(FSsParser[i], '\s[%D]') > 0) or (FSsParser[i] = '\s[-1]') then
          begin
            TalkEnd;
            sur := StrToInt(FSsParser.GetParam(FSsParser[i], 1));
            if InSync then
            begin
              sur0 := sur;
              sur1 := sur;
            end else if UnyuTalking then
              sur1 := sur
            else
              sur0 := sur;
          end else if FSsParser.Match(FSsParser[i], '\s%d') > 0 then
          begin
            TalkEnd;
            sur := Ord(FSsParser[i][3]) - Ord('0');
            if InSync then
            begin
              sur0 := sur;
              sur1 := sur;
            end else if UnyuTalking then
              sur1 := sur
            else
              sur0 := sur;
          end else if FSsParser.Match(FSsParser[i], '\n') >= 2 then
          begin
            if Talk <> '' then
              Talk := Talk + #13#10;
          end else if FSsParser[i] = '\c' then
          begin
            TalkEnd;
            y := y + DrawSeparateLine(y);
          end;
        end;
      mtStr, mtMeta:
        Talk := Talk + FSsParser[i];
    end;
    if FWholeHeight < 0 then // ̕`ł
    begin
      // `悳ꂽ̈ʒuLĂB
      // ȍ~̕`悪
      FSsParser.Extra[i] := IntToStr(y);
    end;
    // `̈悪EBhẺ[߂
    // IA`悾͑Ŝ𑖍
    if (y > ScrollBar.Position + PaintBox.Height) and
      (FWholeHeight > 0) then
    begin
      Break;
    end;
    Inc(i);
  end;
  TalkEnd;
  PaintBox.Canvas.Draw(0, 0, FBuffer);

  if FWholeHeight = -1 then
  begin
    if FScript <> '' then
      FWholeHeight := y;
    ScrollBar.Position := 0;
    if FWholeHeight > PaintBox.Height then
    begin
      with ScrollBar do
      begin
        Max := FWholeHeight - PaintBox.Height;
        Min := 0;
        Enabled := true;
        LargeChange := PaintBox.Height;
        SmallChange := PaintBox.Canvas.Font.Size;
        // PageSize := Max * PaintBox.Height div FWholeHeight;
      end;
    end else
    begin
      ScrollBar.Enabled := false;
    end;
  end;
end;

function TfrmTalkShow.DrawSingleTalk(VertPos, Sur0, Sur1: integer;
  Talk: String): integer;
var Bmp: TBitmap;
    H, BH, X: integer;
    ARect: TRect;
begin
  Bmp := TBitmap.Create;
  try
    X := 2;
    BH := 0;
    if Sur0 >= 0 then
      X := X + DrawSingleImage(X, VertPos, Sur0, BH) + 2;
    if Sur1 >= 0 then
      X := X + DrawSingleImage(X, VertPos, Sur1, BH) + 2;

    ARect := Rect(X + 10, VertPos, PaintBox.Width-5, VertPos+10000);
    H := DrawTextEx(FBuffer.Canvas.Handle, PChar(Talk), -1, ARect,
      DT_WORDBREAK or DT_NOPREFIX, nil);

    if H > BH then
      Result := H
    else
      Result := BH;
  finally
    Bmp.Free;
  end;
end;

procedure TfrmTalkShow.ScrollBarChange(Sender: TObject);
begin
  PaintBoxPaint(self);
end;

function TfrmTalkShow.DrawSingleImage(X, Y, Surface: integer;
  var Height: integer): integer;
var Bmp: TBitmap;
begin
  Result := 0;
  if FGhost = '' then
    Exit; // S[Xgw肳ĂȂȂ\łȂ
  Bmp := TBitmap.Create;
  try
    if Spps.TryGetImage(FGhost, Surface, Bmp) then
    begin
      Result := Bmp.Width;
      FBuffer.Canvas.Draw(X, Y, Bmp);
      if Bmp.Height > Height then
        Height := Bmp.Height;
    end;
  finally
    Bmp.Free;
  end;
end;

procedure TfrmTalkShow.FrameResize(Sender: TObject);
begin
  FWholeHeight := -1; // 킩ȂȂ
end;

procedure TfrmTalkShow.View(Script, Ghost: String);
begin
  if (Ghost = FGhost) and (Script = FScript) then
    Exit;
  FGhost := Ghost;
  FScript := Script;
  with FSsParser do
  begin
    LeaveEscape := false;
    EscapeInvalidMeta := false;
    InputString := FScript;
  end;
  FWholeHeight := -1; // `
  PaintBoxPaint(self);
end;

function TfrmTalkShow.DrawSeparateLine(VertPos: integer): integer;
begin
  with FBuffer.Canvas do
  begin
    Pen.Color := Pref.TextColor;
    Pen.Mode := pmCopy;
    MoveTo(5, VertPos);
    LineTo(PaintBox.Width-5, VertPos);
    Result := 4;
  end;
end;

constructor TfrmTalkShow.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FBuffer := TBitmap.Create;
  FWholeHeight := -1;
end;

destructor TfrmTalkShow.Destroy;
begin
  FBuffer.Free;
  inherited;
end;

procedure TfrmTalkShow.SetPreviewFont(Font: TFont);
begin
  FBuffer.Canvas.Font.Assign(Font);
end;

procedure TfrmTalkShow.SetPrevControl(const Value: TWinControl);
begin
  FPrevControl := Value;
end;

procedure TfrmTalkShow.ScrollBarEnter(Sender: TObject);
begin
  if PrevControl <> nil then
    PrevControl.SetFocus;
end;

end.
