unit SakuraAPI;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Sakura;

type
  TSakuraAPI = class(TComponent)
  private
    { Private 錾 }
    FMes: integer;
    FTargetHWnd: THandle;
    FOnRegisterAPI: TNotifyEvent;
    procedure SetTargetHWnd(const Value: THandle);
    procedure SetOnRegisterAPI(const Value: TNotifyEvent);
  protected
    { Protected 錾 }
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Loaded; override;
    //
    function SendAPI(Mes: cardinal; wParam: integer; lParam: integer): integer;
    function ExecuteRemakeMenu: integer;
    function ExecuteRewriteFMO: integer;
    function GetHeadCollisionRectSakura: TRect;
    function GetFaceCollisionRectSakura: TRect;
    function GetBustCollisionRectSakura: TRect;
    function GetCenterPointSakura: TPoint;
    function GetHeadCollisionRectKero: TRect;
    function GetFaceCollisionRectKero: TRect;
    function GetBustCollisionRectKero: TRect;
    function GetCenterPointKero: TPoint;
    function GetGhostState: integer;
    function GetAbsoluteKinokoFieldCenterPointSakura: TPoint;
    function GetAbsoluteKinokoFieldCenterPointKero: TPoint;
    function GetProcessID: Cardinal;
    function GetSharedMemory(const Slot: integer = -1): pointer;
    function NotifyEvent: integer;
  published
    { Published 錾 }
    property WM_SAKURAAPI: integer read FMes;
    property TargetHWnd: THandle read FTargetHWnd write SetTargetHWnd;
    property OnRegisterAPI: TNotifyEvent read FOnRegisterAPI write SetOnRegisterAPI;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TSakuraAPI]);
end;

{ TSakuraAPI }

constructor TSakuraAPI.Create;
begin
  inherited;
end;

destructor TSakuraAPI.Destroy;
begin
  inherited;
  //
end;

function TSakuraAPI.ExecuteRemakeMenu: integer;
begin
  Result := SendAPI(SA_EXECUTEREMAKEMENU, 0, 0);
end;

function TSakuraAPI.ExecuteRewriteFMO: integer;
begin
  Result := SendAPI(SA_EXECUTEREWRITEFMO, 1, 0);
end;

function TSakuraAPI.GetAbsoluteKinokoFieldCenterPointKero: TPoint;
begin
  Result.X := SendAPI(SA_GETABSOLUTEKINOKOFIELDCENTERPOINTKERO, 137, 0);
  Result.Y := SendAPI(SA_GETABSOLUTEKINOKOFIELDCENTERPOINTKERO, 137, 1);
end;

function TSakuraAPI.GetAbsoluteKinokoFieldCenterPointSakura: TPoint;
begin
  Result.X := SendAPI(SA_GETABSOLUTEKINOKOFIELDCENTERPOINTSAKURA, 132, 0);
  Result.Y := SendAPI(SA_GETABSOLUTEKINOKOFIELDCENTERPOINTSAKURA, 132, 1);
end;

function TSakuraAPI.GetBustCollisionRectKero: TRect;
begin
  Result.Left   := SendAPI(SA_GETBUSTCOLLISIONRECTKERO, 135, 0);
  Result.Top    := SendAPI(SA_GETBUSTCOLLISIONRECTKERO, 135, 1);
  Result.Right  := SendAPI(SA_GETBUSTCOLLISIONRECTKERO, 135, 2);
  Result.Bottom := SendAPI(SA_GETBUSTCOLLISIONRECTKERO, 135, 3);
end;

function TSakuraAPI.GetBustCollisionRectSakura: TRect;
begin
  Result.Left   := SendAPI(SA_GETBUSTCOLLISIONRECTSAKURA, 130, 0);
  Result.Top    := SendAPI(SA_GETBUSTCOLLISIONRECTSAKURA, 130, 1);
  Result.Right  := SendAPI(SA_GETBUSTCOLLISIONRECTSAKURA, 130, 2);
  Result.Bottom := SendAPI(SA_GETBUSTCOLLISIONRECTSAKURA, 130, 3);
end;

function TSakuraAPI.GetCenterPointKero: TPoint;
begin
  Result.X := SendAPI(SA_GETCENTERPOINTKERO, 136, 0);
  Result.Y := SendAPI(SA_GETCENTERPOINTKERO, 136, 1);
end;

function TSakuraAPI.GetCenterPointSakura: TPoint;
begin
  Result.X := SendAPI(SA_GETCENTERPOINTSAKURA, 131, 0);
  Result.Y := SendAPI(SA_GETCENTERPOINTSAKURA, 131, 1);
end;

function TSakuraAPI.GetFaceCollisionRectKero: TRect;
begin
  Result.Left   := SendAPI(SA_GETFACECOLLISIONRECTKERO, 134, 0);
  Result.Top    := SendAPI(SA_GETFACECOLLISIONRECTKERO, 134, 1);
  Result.Right  := SendAPI(SA_GETFACECOLLISIONRECTKERO, 134, 2);
  Result.Bottom := SendAPI(SA_GETFACECOLLISIONRECTKERO, 134, 3);
end;

function TSakuraAPI.GetFaceCollisionRectSakura: TRect;
begin
  Result.Left   := SendAPI(SA_GETFACECOLLISIONRECTSAKURA, 129, 0);
  Result.Top    := SendAPI(SA_GETFACECOLLISIONRECTSAKURA, 129, 1);
  Result.Right  := SendAPI(SA_GETFACECOLLISIONRECTSAKURA, 129, 2);
  Result.Bottom := SendAPI(SA_GETFACECOLLISIONRECTSAKURA, 129, 3);
end;

function TSakuraAPI.GetHeadCollisionRectKero: TRect;
begin
  Result.Left   := SendAPI(SA_GETHEADCOLLISIONRECTKERO, 133, 0);
  Result.Top    := SendAPI(SA_GETHEADCOLLISIONRECTKERO, 133, 1);
  Result.Right  := SendAPI(SA_GETHEADCOLLISIONRECTKERO, 133, 2);
  Result.Bottom := SendAPI(SA_GETHEADCOLLISIONRECTKERO, 133, 3);
end;

function TSakuraAPI.GetHeadCollisionRectSakura: TRect;
begin
  Result.Left   := SendAPI(SA_GETHEADCOLLISIONRECTSAKURA, 128, 0);
  Result.Top    := SendAPI(SA_GETHEADCOLLISIONRECTSAKURA, 128, 1);
  Result.Right  := SendAPI(SA_GETHEADCOLLISIONRECTSAKURA, 128, 2);
  Result.Bottom := SendAPI(SA_GETHEADCOLLISIONRECTSAKURA, 128, 3);
end;

function TSakuraAPI.GetGhostState: integer;
begin
  Result := SendAPI(SA_GETGHOSTSTATE, 140, 0);
end;

function TSakuraAPI.GetProcessID: Cardinal;
begin
  Result := SendAPI(SA_GETPROCESSID, 138, 0);
end;

function TSakuraAPI.GetSharedMemory(const Slot: integer = -1): pointer;
begin
  Result := pointer(SendAPI(SA_GETSHAREDMEMORY, 139, Slot));
end;

function TSakuraAPI.SendAPI(Mes: cardinal; wParam: integer;
  lParam: integer): integer;
begin
  Result := SendMessage(TargetHWnd, Mes, wParam, lParam);
end;

procedure TSakuraAPI.SetTargetHWnd(const Value: THandle);
begin
  FTargetHWnd := Value;
end;

function TSakuraAPI.NotifyEvent: integer;
begin
  Result := SendAPI(SA_NOTIFYEVENT, 256, 0);
end;

procedure TSakuraAPI.SetOnRegisterAPI(const Value: TNotifyEvent);
begin
  FOnRegisterAPI := Value;
end;

procedure TSakuraAPI.Loaded;
begin
  inherited;
  if csDesigning in ComponentState then Exit;
  FMes := RegisterWindowMessage('Sakura');
  if FMes = 0 then
    raise Exception.Create('RegisterWindowMessageɎs܂')
  else
    if Assigned(FOnRegisterAPI) then
      FOnRegisterAPI(Self);
end;

end.
