unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SsParser, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    ListView1: TListView;
    SsParser: TSsParser;
    Edit2: TEdit;
    Button2: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var i: integer;
    Li: TListItem;
begin
  ListView1.Items.Clear;
  SsParser.InputString := Edit1.Text;
  for i := 0 to SsParser.Count-1 do begin
    Li := ListView1.Items.Add;
    case SsParser.MarkUpType[i] of
      mtTag:    Li.Caption := 'Tag';
      mtTagErr: Li.Caption := 'TagErr';
      mtMeta:   Li.Caption := 'Meta';
      mtStr:    Li.Caption := 'Str';
    end;
    Li.SubItems.Add(IntToStr(i));
    Li.SubItems.Add(SsParser[i]);
    Li.SubItems.Add(IntToStr(SsParser.Position[i]));
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var i: integer;
    Str: String;
begin
  i := SsParser.Match(Edit1.Text, Edit2.Text);
  Str := Copy(Edit1.Text, 1, i);
  ShowMessage(IntToStr(i) + #13#10 + Str);
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  SsParser.LeaveEscape := CheckBox2.Checked;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  SsParser.EscapeInvalidMeta := CheckBox1.Checked;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  try
    ShowMessage(SsParser.GetParam(Edit1.Text, StrToInt(Edit2.Text)));
  except
    on EConvertError do ShowMessage('Edit2 is not Integer');
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
var i: integer;
    from: Int64;
const
    loop = 100;
begin
  from := GetTickCount;
  for i := 1 to loop do
    SsParser.InputString := Edit1.Text;
  ShowMessage(Format('%d loops, %d ms.', [loop, GetTickCount - from]));
end;

end.
