unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SakuraSeeker, ComCtrls, Menus, ExtCtrls, StdCtrls, TestDSstp;

type
  TForm1 = class(TForm)
    ListView1: TListView;
    StatusBar1: TStatusBar;
    SakuraSeeker1: TSakuraSeeker;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Update1: TMenuItem;
    Exit1: TMenuItem;
    Timer1: TTimer;
    Panel1: TPanel;
    Button1: TButton;
    TestDSstp1: TTestDSstp;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Update1Click(Sender: TObject);
    procedure SakuraSeeker1AfterDetection(Sender: TObject);
    procedure SakuraSeeker1DetectResultChanged(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private 錾 }
  protected
    procedure GetMessage(var Message: TWMCopyData); message WM_COPYDATA;
  public
    { Public 錾 }
    procedure Update;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var SakuraSeeker: TSakuraSeeker;
begin
  SakuraSeeker := TSakuraSeeker.Create(Self);
  SakuraSeeker.BeginDetect;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Update1Click(Sender: TObject);
begin
  SakuraSeeker1.BeginDetect;
  Update;
end;

procedure TForm1.Update;
var i: integer;
    Item: TListItem;
begin
  ListView1.Items.Clear;
  for i := 0 to SakuraSeeker1.Count-1 do begin
    Item := ListView1.Items.Add;
    Item.Caption := SakuraSeeker1[i].ProcessID;
    Item.SubItems.Add(IntToStr(SakuraSeeker1[i].HWnd));
    Item.SubItems.Add(SakuraSeeker1[i].Name);
  end;
end;

procedure TForm1.SakuraSeeker1AfterDetection(Sender: TObject);
begin
  StatusBar1.SimpleText := IntToStr(SakuraSeeker1.Count) + '   ' +
  DateTimeToStr(Now);
  Update;
end;

procedure TForm1.SakuraSeeker1DetectResultChanged(Sender: TObject);
begin
  ShowMessage('Status Changed!');
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  SakuraSeeker1.BeginDetect;
end;

procedure TForm1.Button1Click(Sender: TObject);
var Target: THandle;
    Dat: TCopyDataStruct;
    Str: String;
begin
  if ListView1.Selected = nil then Exit;
  Target := SakuraSeeker1[ListView1.Selected.Index].HWnd;

  Str := 'SEND SSTP/1.4'#13#10'HWnd: '+IntToStr(Form1.Handle)+#13#10'Charset: Shift_JIS'#13#10 +
         'Sender: Tester'#13#10'Script: \tĂĂB\e'#13#10#13#10;

  Dat.dwData := 9801;
  Dat.cbData := Length(Str);
  Dat.lpData := PChar(Str);

  SendMessage(Target, WM_COPYDATA, Form1.Handle, LPARAM(@Dat));

end;

procedure TForm1.GetMessage(var Message: TWMCopyData);
begin
  inherited;
  ShowMessage(PChar(Message.CopyDataStruct^.lpData));
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if SakuraSeeker1.Count > 0 then
    TestDSstp1.Go(SakuraSeeker1[0].HWnd);
end;

end.
