﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Net;
using WinnyProtocolAnalyzer;

namespace WinnyProtocolAnalyzer.Data
{
    [Serializable]
    [XmlRoot("キー")]
    public class Key
    {
        [XmlElement("エンドポイント")]
        public EndPoint EndPoint { get; set; }
        [XmlElement("ファイルサイズ")]
        public int Length { get; set; }
        [XmlElement("ファイルのハッシュ値")]
        public string Hash { get; set; }
        [XmlElement("ファイル名")]
        public string Name { get; set; }
        [XmlElement("トリップ情報")]
        public string Trip { get; set; }
        [XmlElement("キー消滅判定タイマー")]
        public int Timer { get; set; }
        [XmlElement("被参照ブロック数")]
        public int ReferencedBlockCount { get; set; }
        [XmlElement("キー更新日時(UNIX Time)")]
        public int RenewalTimer { get; set; }
        [XmlElement("キー無視フラグ")]
        public bool KeyIgnoreFlag { get; set; }
        [XmlElement("キーバージョン")]
        public int KeyVersion { get; set; }

        /// <summary>
        /// Key クラスの新しいインスタンスを作成します。
        /// </summary>
        public Key()
        {
            EndPoint = new EndPoint();
            Length = 0;
            Hash = "";
            Name = "";
            Trip = "";
            Timer = 0;
            ReferencedBlockCount = 0;
            RenewalTimer = 0;
            KeyIgnoreFlag = false;
            KeyVersion = 0;
        }

        /// <summary>
        /// Key クラスの新しいインスタンスを作成します。
        /// </summary>
        /// <param name="Point">ポイント</param>
        /// <param name="Port">ポート</param>
        /// <param name="Length">ファイルサイズ</param>
        /// <param name="Hash">ファイルのハッシュ値</param>
        /// <param name="Name">ファイル名</param>
        /// <param name="Trip">トリップ情報</param>
        /// <param name="Timer">キー消滅判定タイマー</param>
        /// <param name="ReferencedBlockCount">被参照ブロック数</param>
        /// <param name="RenewalTimer">キー更新日時</param>
        /// <param name="KeyIgnoreFlag">キー無視フラグ</param>
        /// <param name="KeyVersion">キーバージョン</param>
        public Key(string IPAddress, int Port, bool ReverseLookup, int Length, string Hash, string Name, string Trip, int Timer, int ReferencedBlockCount, int RenewalTimer, bool KeyIgnoreFlag, int KeyVersion)
        {
            this.EndPoint = new EndPoint(IPAddress, Port, ReverseLookup);
            this.Length = Length;
            this.Hash = Hash;
            this.Name = Utility.ValidFileName(Name);
            this.Trip = Trip;
            this.Timer = Timer;
            this.ReferencedBlockCount = ReferencedBlockCount;
            this.RenewalTimer = RenewalTimer;
            this.KeyIgnoreFlag = KeyIgnoreFlag;
            this.KeyVersion = KeyVersion;
        }

        /// <summary>
        /// Key クラスの新しいインスタンスを作成します。
        /// </summary>
        /// <param name="Point">ポイント</param>
        /// <param name="Port">ポート</param>
        /// <param name="Length">ファイルサイズ</param>
        /// <param name="Hash">ファイルのハッシュ値</param>
        /// <param name="Name">ファイル名</param>
        /// <param name="Trip">トリップ情報</param>
        /// <param name="Timer">キー消滅判定タイマー</param>
        /// <param name="ReferencedBlockCount">被参照ブロック数</param>
        /// <param name="RenewalTimer">キー更新日時</param>
        /// <param name="KeyIgnoreFlag">キー無視フラグ</param>
        /// <param name="KeyVersion">キーバージョン</param>
        public Key(IPAddress IPAddress, int Port, bool ReverseLookup, int Length, string Hash, string Name, string Trip, int Timer, int ReferencedBlockCount, int RenewalTimer, bool KeyIgnoreFlag, int KeyVersion)
        {
            this.EndPoint = new EndPoint(IPAddress, Port, ReverseLookup);
            this.Length = Length;
            this.Hash = Hash;
            this.Name = Utility.ValidFileName(Name);
            this.Trip = Trip;
            this.Timer = Timer;
            this.ReferencedBlockCount = ReferencedBlockCount;
            this.RenewalTimer = RenewalTimer;
            this.KeyIgnoreFlag = KeyIgnoreFlag;
            this.KeyVersion = KeyVersion;
        }
    }
}
