﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace WinnyProtocolAnalyzer
{
    enum InitializeResult { Normal, Transfer, Reverse, Error };

    enum Command : byte
    {
        WinnyProtocolHeader = 0, LineSpeedAcknowledgment = 1, ConnectionTypeAcknowledgment = 2, NodeInformationAcknowledgment = 3,
        NodeReference = 4, DiffusionQueryRequest = 10, QueryRequest = 12, QuerySend = 13,
        ConnectionClose = 31, ConnectionLimit = 32
    };

    enum TopLevelDomain { ccTLD = 128, gTLD = 64 };

    static class Property
    {
        public const int ThreadWait = 1000;
        public const int NetworkTimeout = 30000;       
        public const int BufferSize = 65536;

        public const int PortMin = 1024;
        public const int PortMax = 65536;
        public const float LineSpeedDefault = 10000;
        public const int ThreadDefault = 2;

        public const string NodeKey = "opiewf6ascxlv";


        public const int KeyLength = 4;
        public const int DummyLength = 2;
        public const byte KeyExchangeInstruction = 97;
        public const int KeyExchangeInstructionLength = 1;

        public const int WinnyVersion = 12710;
        public const string ProtocolHeaderKey = "98789asj";
        public const string AuthenticationString = "Winny Ver2.0b1  ";
        public const int AuthenticationStringLength = 16;

        public const int ClusterCount = 3;
        public const int ClusterWordMaxLength = 255;
        public const int TripLength = 11;
        public const int HashLength = 128 / 8;
        public const short KeyTimer = 60 * 25;
        public const int DiffusionQueryInterval = 30;
        public const int QueryKeepingLimit = 5;    // min.

        public const string NodeListSerializeFileName = @"\Nodes.xml";
        public const string NodeListSerializeFileName_dat = @"\Nodes.dat";
        public const string KeyListSerializaFileName = @"\Keys.xml";
        public const string KeyListSerializaFileName_dat = @"\Keys.dat";
        public const int BinaryFormatThreshold = 5000;
        public const int UpdateTiming = 60000;

        public const string Command_04 = "04: 他ノード情報の通知";
        public const string Command_10 = "10: 拡散クエリ送信要求";
        public const string Command_12 = "12: 拡散クエリ転送要求(検索条件付き)";
        public const string Command_13 = "13: クエリ送信";


    }
}
