﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace WinnyProtocolAnalyzer
{
    class Query
    {
        public DateTime Time { get; set; }
        public EndPoint Source { get; set; }
        public EndPoint Destination { get; set; }
        public byte[] Data { get; set; }

        /// <summary>
        /// Query クラスの新しいインスタンスを作成します。
        /// </summary>
        public Query()
        {
            Time = DateTime.Now;
            Source = new EndPoint();
            Destination = new EndPoint();
            Data = null;
        }

        /// <summary>
        /// Query クラスの新しいインスタンスを作成します。
        /// </summary>
        /// <param name="Source">エンドポイント</param>
        /// <param name="Destination">エンドポイント</param>
        /// <param name="Data">データ</param>
        public Query(EndPoint Source, EndPoint Destination, byte[] Data)
        {
            this.Time = DateTime.Now;
            this.Source = Source;
            this.Destination = Destination;
            this.Data = Data;
        }
    }
}
