﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Diagnostics;
using System.Xml.Serialization;

namespace WinnyProtocolAnalyzer
{
    [Serializable]
    [XmlRoot("環境設定")]
    public class Settings
    {
        [XmlElement("接続待ち受けポート")]
        public int Port { get; set; }
        [XmlElement("UPnPオプション")]
        public bool UPnP { get; set; }
        [XmlElement("回線速度")]
        public float LineSpeed { get; set; }
        [XmlElement("最大接続数")]
        public int Connections { get; set; }
        [XmlElement("キーワード候補")]
        public List<Keyword> Keywords { get; set; }
        [XmlElement("クラスタワード候補")]
        public List<Cluster> Clusters { get; set; }
        [XmlElement("設定済みクラスタワード")]
        public string[] ClusterWords { get; set; }
        [XmlElement("データフォルダ")]
        public string DataFolder { get; set; }
        [XmlElement("すべての要素のアドレス解決を行う")]
        public bool ReverseResolution { get; set; }
        [XmlElement("ノード要素のみアドレス解決を行う")]
        public bool ReverseResolutionOnlyForNode { get; set; }
        [XmlElement("キー要素のみアドレス解決を行う")]
        public bool ReverseResolutionOnlyForKey { get; set; }

        public Settings()
        {
            Port = new Random().Next(Property.PortMin, Property.PortMax);
            UPnP = false;
            LineSpeed = Property.LineSpeedDefault;
            Connections = Property.ThreadDefault;
            Keywords = new List<Keyword>();
            Clusters = new List<Cluster>();
            ClusterWords = new string[Property.ClusterCount] { "", "", "" };
            DataFolder = Environment.CurrentDirectory + @"\Data";
            if (!Directory.Exists(DataFolder))
            {
                Directory.CreateDirectory(DataFolder);
            }

            ReverseResolution = false;
            ReverseResolutionOnlyForNode = false;
            ReverseResolutionOnlyForKey = false;
        }
    }

    [Serializable]
    [XmlRoot("クラスタ")]
    public class Cluster
    {
        [XmlElement("クラスタワード")]
        public string ClusterWord { get; set; }
        [XmlElement("有効")]
        public bool Enable { get; set; }

        public Cluster()
        {
            ClusterWord = "";
            Enable = false;
        }

        public Cluster(string ClusterWord, bool Enable)
        {
            this.ClusterWord = ClusterWord;
            this.Enable = Enable;
        }
    }

    [Serializable]
    [XmlRoot("キーワード")]
    public class Keyword
    {
        [XmlElement("キーワード")]
        public string Keywords { get; set; }
        [XmlElement("有効")]
        public bool Enable { get; set; }

        public Keyword()
        {
            Keywords = "";
            Enable = false;
        }

        public Keyword(string Keyword, bool Enable)
        {
            this.Keywords = Keyword;
            this.Enable = Enable;
        }
    }
}
